/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import smartin.miapi.client.model.MiapiItemModel;
import smartin.miapi.client.model.MiapiModel;
import smartin.miapi.item.modular.Transform;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.modules.properties.slot.SlotProperty;

@OnlyIn(value=Dist.CLIENT)
public class ModuleModel {
    private final List<Pair<Matrix4f, MiapiModel>> actualModels;
    public final ModuleInstance instance;
    public Map<String, ModuleModel> subModuleModels = new HashMap<String, ModuleModel>();
    public ItemStack stack;
    public final String key;
    @Nullable
    public final ItemDisplayContext context;
    public boolean renderSubmodules = true;

    public ModuleModel(ModuleInstance instance, ItemStack stack, String key, @Nullable ItemDisplayContext displayContext) {
        this.instance = instance;
        this.stack = stack;
        this.actualModels = this.generateModel(key, displayContext);
        this.key = key;
        this.context = displayContext;
    }

    private List<Pair<Matrix4f, MiapiModel>> generateModel(String key, ItemDisplayContext context) {
        Minecraft.getInstance().getProfiler().push("generate model");
        ArrayList<Pair<Matrix4f, MiapiModel>> modelList = new ArrayList<Pair<Matrix4f, MiapiModel>>();
        Transform transform = SlotProperty.getTransformStack(this.instance).get("item".equals(key) ? null : key).copy();
        Matrix4f matrix4f = Transform.toModelTransformation(transform).toMatrix();
        for (MiapiItemModel.ModelSupplier supplier : MiapiItemModel.modelSuppliers) {
            supplier.getModels(key, context, this.instance, this.stack).forEach(model -> modelList.add(new Pair((Object)matrix4f, model)));
        }
        List<Pair<Matrix4f, MiapiModel>> model2 = modelList;
        for (MiapiItemModel.ModelSupplier supplier : MiapiItemModel.modelSuppliers) {
            model2 = supplier.filter(model2, this.stack, this.instance, key, context);
        }
        Minecraft.getInstance().getProfiler().pop();
        return model2;
    }

    public void render(String modelType, ItemStack stack, PoseStack matrices, ItemDisplayContext mode, float tickDelta, MultiBufferSource vertexConsumers, LivingEntity entity, int light, int overlay) {
        Minecraft.getInstance().getProfiler().push("submodule-logic");
        Matrix4f submoduleMatrix = new Matrix4f();
        Minecraft.getInstance().getProfiler().pop();
        this.actualModels.forEach(matrix4fMiapiModelPair -> {
            Minecraft.getInstance().getProfiler().push("submodule-logic");
            matrices.pushPose();
            Transform.applyPosition(matrices, (Matrix4f)matrix4fMiapiModelPair.getFirst());
            Minecraft.getInstance().getProfiler().pop();
            ((MiapiModel)matrix4fMiapiModelPair.getSecond()).render(matrices, stack, mode, tickDelta, vertexConsumers, entity, light, overlay);
            Minecraft.getInstance().getProfiler().push("submodule-logic");
            matrices.popPose();
            submoduleMatrix.mul((Matrix4fc)((MiapiModel)matrix4fMiapiModelPair.getSecond()).subModuleMatrix());
            Minecraft.getInstance().getProfiler().pop();
        });
        if (this.renderSubmodules) {
            this.instance.getSubModuleMap().forEach((id, instance1) -> {
                Minecraft.getInstance().getProfiler().push("submodule-logic");
                matrices.pushPose();
                Transform.applyPosition(matrices, submoduleMatrix);
                ModuleModel subModuleModel = this.subModuleModels.get(id);
                if (subModuleModel == null) {
                    subModuleModel = new ModuleModel((ModuleInstance)instance1, stack, this.key, this.context);
                    this.subModuleModels.put((String)id, subModuleModel);
                }
                Minecraft.getInstance().getProfiler().pop();
                subModuleModel.render(modelType, stack, matrices, mode, tickDelta, vertexConsumers, entity, light, overlay);
                matrices.popPose();
            });
        }
    }
}

