/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.client.model.item;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.block.model.ItemOverride;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import smartin.miapi.client.model.DynamicBakery;

@OnlyIn(value=Dist.CLIENT)
public class BakedSingleModelOverrides
extends ItemOverrides {
    public final DynamicBakedOverride[] dynamicOverrides;
    public final ResourceLocation[] dynamicConditionTypes;

    public BakedSingleModelOverrides(Map<ConditionHolder, BakedModel> modelHashMap) {
        super(DynamicBakery.dynamicBaker, null, new ArrayList());
        this.dynamicConditionTypes = (ResourceLocation[])modelHashMap.keySet().stream().flatMap(conditionHolder -> conditionHolder.conditions.stream()).map(Condition::getType).distinct().toArray(ResourceLocation[]::new);
        Object2IntOpenHashMap object2IntMap = new Object2IntOpenHashMap();
        for (int i = 0; i < this.dynamicConditionTypes.length; ++i) {
            object2IntMap.put((Object)this.dynamicConditionTypes[i], i);
        }
        ArrayList list = Lists.newArrayList();
        modelHashMap.forEach((arg_0, arg_1) -> BakedSingleModelOverrides.lambda$new$4((Object2IntMap)object2IntMap, list, arg_0, arg_1));
        DynamicBakedOverride[] dynamicCondition = new DynamicBakedOverride[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            dynamicCondition[i] = (DynamicBakedOverride)list.get(i);
        }
        this.dynamicOverrides = dynamicCondition;
    }

    public BakedModel resolve(@NotNull BakedModel model, @NotNull ItemStack stack, @Nullable ClientLevel world, @Nullable LivingEntity entity, int seed) {
        if (this.dynamicOverrides.length != 0) {
            int j;
            int i = this.dynamicConditionTypes.length;
            float[] fs = new float[i];
            for (j = 0; j < i; ++j) {
                ResourceLocation identifier = this.dynamicConditionTypes[j];
                ItemPropertyFunction modelPredicateProvider = ItemProperties.getProperty((ItemStack)stack, (ResourceLocation)identifier);
                fs[j] = modelPredicateProvider != null ? modelPredicateProvider.call(stack, world, entity, seed) : Float.NEGATIVE_INFINITY;
            }
            for (j = 0; j < this.dynamicOverrides.length; ++j) {
                DynamicBakedOverride bakedOverride = this.dynamicOverrides[j];
                if (!bakedOverride.test(fs) || bakedOverride.model == null) continue;
                return bakedOverride.model;
            }
        }
        return model;
    }

    private static /* synthetic */ void lambda$new$4(Object2IntMap object2IntMap, List list, ConditionHolder conditionHolder, BakedModel bakedModel) {
        InlinedCondition[] inlinedConditions = (InlinedCondition[])conditionHolder.conditions.stream().map(condition -> {
            int i = object2IntMap.getInt((Object)condition.getType());
            return new InlinedCondition(i, condition.getThreshold());
        }).toArray(InlinedCondition[]::new);
        list.add(new DynamicBakedOverride(inlinedConditions, bakedModel));
    }

    @OnlyIn(value=Dist.CLIENT)
    static class DynamicBakedOverride {
        private final InlinedCondition[] conditions;
        @Nullable
        final BakedModel model;

        DynamicBakedOverride(InlinedCondition[] conditions, @Nullable BakedModel model) {
            this.conditions = conditions;
            this.model = model;
        }

        boolean test(float[] values) {
            for (InlinedCondition inlinedCondition : this.conditions) {
                float f = values[inlinedCondition.index];
                if (!(f < inlinedCondition.threshold)) continue;
                return false;
            }
            return true;
        }
    }

    public static class ConditionHolder {
        public ResourceLocation identifier;
        public List<Condition> conditions;

        public ConditionHolder(ItemOverride override) {
            this.identifier = override.getModel();
            this.conditions = override.getPredicates().map(condition -> new Condition((ItemOverride.Predicate)condition)).toList();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this == obj) {
                return true;
            }
            if (obj instanceof ConditionHolder) {
                ConditionHolder otherCondition = (ConditionHolder)obj;
                if (this.conditions.size() == otherCondition.conditions.size()) {
                    for (Condition condition : this.conditions) {
                        if (otherCondition.conditions.contains(condition)) continue;
                        return false;
                    }
                    return true;
                }
            }
            return false;
        }

        public boolean isAcceptable(ConditionHolder other) {
            for (Condition condition : other.conditions) {
                Optional<Condition> exist = this.conditions.stream().filter(condition1 -> condition1.type.equals((Object)condition.type)).findFirst();
                if (!exist.isPresent() || !(condition.threshold < exist.get().threshold)) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            int result = 17;
            result = 31 * result + this.conditions.size();
            return result;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("ConditionHolder-" + this.identifier.toString() + "\n");
            for (Condition condition : this.conditions) {
                builder.append(condition.toString() + ",");
            }
            return builder.toString();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private record InlinedCondition(int index, float threshold) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Condition {
        private final ResourceLocation type;
        private final float threshold;

        public Condition(ItemOverride.Predicate condition) {
            this.type = condition.getProperty();
            this.threshold = condition.getValue();
        }

        public Condition(ResourceLocation type, float threshold) {
            this.type = type;
            this.threshold = threshold;
        }

        public ResourceLocation getType() {
            return this.type;
        }

        public float getThreshold() {
            return this.threshold;
        }

        public boolean equals(Object obj) {
            Condition otherCondition;
            if (obj == null) {
                return false;
            }
            if (this == obj) {
                return true;
            }
            if (obj instanceof Condition) {
                otherCondition = (Condition)obj;
                if (otherCondition.type.equals((Object)this.type) && otherCondition.threshold == this.threshold) {
                    return true;
                }
            }
            if (obj instanceof ItemOverride.Predicate) {
                otherCondition = (ItemOverride.Predicate)obj;
                return otherCondition.getProperty().equals((Object)this.type) && otherCondition.getValue() == this.threshold;
            }
            return false;
        }

        public String toString() {
            return "Condition - " + this.type.toString() + " - " + this.threshold;
        }
    }
}

