/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.client.model.item;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;

public class DualKeyCache<K1, K2, V> {
    private final Map<K1, Map<K2, V>> cache = new HashMap<K1, Map<K2, V>>();
    private final Map<K1, V> singleKeyCache = new HashMap<K1, V>();

    public V getNullSave(K1 key1, K2 key2, BiFunction<K1, K2, V> compute) {
        if (key2 == null) {
            return (V)this.singleKeyCache.computeIfAbsent(key1, k -> compute.apply(k, key2));
        }
        Map innerMap = this.cache.computeIfAbsent(key1, k1 -> new HashMap());
        return (V)innerMap.computeIfAbsent(key2, k2 -> compute.apply(key1, key2));
    }

    public void put(K1 key1, K2 key2, V value) {
        this.cache.computeIfAbsent(key1, k -> new HashMap()).put(key2, value);
    }

    public boolean contains(K1 key1, K2 key2) {
        Map<K2, V> innerMap = this.cache.get(key1);
        return innerMap != null && innerMap.containsKey(key2);
    }

    public void clear() {
        this.cache.clear();
        this.singleKeyCache.clear();
    }
}

