/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.client.model.item;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import smartin.miapi.client.model.DynamicBakery;
import smartin.miapi.client.model.item.ItemBakedModelOverrides;
import smartin.miapi.client.renderer.SpriteLoader;
import smartin.miapi.modules.properties.render.ModelProperty;
import smartin.miapi.registries.RegistryInventory;

@OnlyIn(value=Dist.CLIENT)
public class ItemBakedModelReplacement
implements UnbakedModel,
BakedModel {
    public static LivingEntity currentEntity = null;

    public static boolean isModularItem(ResourceLocation identifier) {
        if (identifier != null && identifier.toString() != null) {
            return RegistryInventory.MODULAR_ITEMS.get(identifier.toString().replace("item/", "")) != null;
        }
        return false;
    }

    public ItemOverrides getOverrides() {
        return ItemBakedModelOverrides.EMPTY;
    }

    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction face, RandomSource random) {
        return new ArrayList<BakedQuad>();
    }

    public boolean useAmbientOcclusion() {
        return false;
    }

    public boolean isGui3d() {
        return false;
    }

    public boolean usesBlockLight() {
        return false;
    }

    public boolean isCustomRenderer() {
        return true;
    }

    public TextureAtlasSprite getParticleIcon() {
        ResourceLocation stoneTextureId = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"block/stone");
        return (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(TextureAtlas.LOCATION_BLOCKS).apply(stoneTextureId);
    }

    public ItemTransforms getTransforms() {
        return ItemTransforms.NO_TRANSFORMS;
    }

    public Collection<ResourceLocation> getDependencies() {
        return SpriteLoader.miapiModels;
    }

    public void resolveParents(Function<ResourceLocation, UnbakedModel> modelLoader) {
        SpriteLoader.miapiModels.forEach(modelLoader::apply);
    }

    @Nullable
    public BakedModel bake(ModelBaker baker, Function<Material, TextureAtlasSprite> spriteGetter, ModelState state) {
        ModelProperty.textureGetter = spriteGetter;
        DynamicBakery.dynamicBaker = baker;
        return this;
    }

    public String toString() {
        return "CustomModel{}";
    }
}

