/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.client.model.module;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BannerRenderer;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BannerPatternLayers;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import smartin.miapi.client.model.MiapiModel;

@OnlyIn(value=Dist.CLIENT)
public class BannerMiapiModel
implements MiapiModel {
    ModelPart banner;
    BannerPatternLayers patterns;
    DyeColor baseColor;
    BannerMode mode;
    Matrix4f transform;

    public BannerMiapiModel(BannerPatternLayers patterns, BannerMode mode, DyeColor color, Matrix4f transform) {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition modelPartData = modelData.getRoot();
        modelPartData.addOrReplaceChild("flag", CubeListBuilder.create().texOffs(0, 0).addBox(-10.0f, 0.0f, -2.0f, 20.0f, 40.0f, 1.0f), PartPose.ZERO);
        this.banner = modelPartData.getChild("flag").bake(64, 64);
        this.patterns = patterns;
        this.mode = mode;
        this.transform = transform;
        this.baseColor = color;
    }

    @Nullable
    public static BannerMiapiModel getFromStack(ItemStack stack, BannerMode mode, Matrix4f transform) {
        Item item = stack.getItem();
        if (item instanceof BannerItem) {
            BannerItem bannerItem = (BannerItem)item;
            DyeColor dyeColor = bannerItem.getColor();
            BannerPatternLayers patternList = (BannerPatternLayers)stack.getComponents().get(DataComponents.BANNER_PATTERNS);
            if (dyeColor != null && patternList != null) {
                if (mode == null) {
                    mode = BannerMode.MODEL;
                }
                return new BannerMiapiModel(patternList, mode, dyeColor, transform);
            }
        }
        return null;
    }

    @Override
    public void render(PoseStack matrices, ItemStack stack, ItemDisplayContext transformationMode, float tickDelta, MultiBufferSource vertexConsumers, LivingEntity entity, int light, int overlay) {
        matrices.pushPose();
        switch (this.mode.ordinal()) {
            case 1: {
                matrices.scale(0.0625f, -0.0625f, -0.0625f);
                matrices.pushPose();
                matrices.translate(8.0, -8.0, -8.75);
                matrices.scale(1.0f, 1.0f, -1.0f);
                matrices.mulPose(this.transform);
                matrices.scale(16.0f, 16.0f, 1.0f);
                matrices.scale(0.05f, 0.05f, 2.0f);
                BannerRenderer.renderPatterns((PoseStack)matrices, (MultiBufferSource)vertexConsumers, (int)light, (int)overlay, (ModelPart)this.banner, (Material)ModelBakery.BANNER_BASE, (boolean)true, (DyeColor)this.baseColor, (BannerPatternLayers)this.patterns);
                matrices.popPose();
                matrices.pushPose();
                matrices.translate(8.0, -8.0, -7.25);
                matrices.scale(1.0f, 1.0f, 1.0f);
                matrices.mulPose(this.transform);
                matrices.scale(16.0f, 16.0f, 1.0f);
                matrices.scale(0.05f, 0.05f, 2.0f);
                BannerRenderer.renderPatterns((PoseStack)matrices, (MultiBufferSource)vertexConsumers, (int)light, (int)overlay, (ModelPart)this.banner, (Material)ModelBakery.BANNER_BASE, (boolean)true, (DyeColor)this.baseColor, (BannerPatternLayers)this.patterns);
                matrices.popPose();
                break;
            }
            case 2: {
                matrices.scale(0.0625f, -0.0625f, -0.0625f);
                matrices.pushPose();
                matrices.translate(8.0, -8.0, -8.75);
                matrices.scale(1.0f, 1.0f, -1.0f);
                matrices.mulPose(this.transform);
                matrices.mulPose(Axis.XP.rotationDegrees(10.0f));
                matrices.scale(16.0f, 16.0f, 1.0f);
                matrices.scale(0.05f, 0.05f, 2.0f);
                BannerRenderer.renderPatterns((PoseStack)matrices, (MultiBufferSource)vertexConsumers, (int)light, (int)overlay, (ModelPart)this.banner, (Material)ModelBakery.BANNER_BASE, (boolean)true, (DyeColor)this.baseColor, (BannerPatternLayers)this.patterns);
                matrices.popPose();
                matrices.pushPose();
                matrices.translate(8.0, -8.0, -7.25);
                matrices.scale(1.0f, 1.0f, 1.0f);
                matrices.mulPose(this.transform);
                matrices.mulPose(Axis.XP.rotationDegrees(10.0f));
                matrices.scale(16.0f, 16.0f, 1.0f);
                matrices.scale(0.05f, 0.05f, 1.0f);
                BannerRenderer.renderPatterns((PoseStack)matrices, (MultiBufferSource)vertexConsumers, (int)light, (int)overlay, (ModelPart)this.banner, (Material)ModelBakery.BANNER_BASE, (boolean)true, (DyeColor)this.baseColor, (BannerPatternLayers)this.patterns);
                matrices.popPose();
                break;
            }
            default: {
                matrices.pushPose();
                matrices.scale(0.0625f, -0.0625f, -0.0625f);
                matrices.translate(0.0f, -1.0f, 0.0f);
                matrices.pushPose();
                matrices.mulPose(new Matrix4f((Matrix4fc)this.transform));
                matrices.scale(16.0f, 16.0f, 16.0f);
                matrices.scale(0.05f, 0.05f, 0.05f);
                BannerRenderer.renderPatterns((PoseStack)matrices, (MultiBufferSource)vertexConsumers, (int)light, (int)overlay, (ModelPart)this.banner, (Material)ModelBakery.BANNER_BASE, (boolean)true, (DyeColor)this.baseColor, (BannerPatternLayers)this.patterns);
                matrices.popPose();
                matrices.popPose();
            }
        }
        matrices.popPose();
    }

    public static BannerMode getMode(String key) {
        try {
            switch (key.toLowerCase()) {
                case "item": {
                    return BannerMode.ITEM;
                }
                case "item_alt": {
                    return BannerMode.ITEM_ALT;
                }
            }
            return BannerMode.valueOf(key);
        }
        catch (Exception e) {
            return BannerMode.MODEL;
        }
    }

    public static enum BannerMode {
        MODEL,
        ITEM,
        ITEM_ALT;

    }
}

