/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.client.model.module;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import smartin.miapi.client.model.MiapiModel;
import smartin.miapi.item.modular.Transform;
import smartin.miapi.material.MaterialIcons;

@OnlyIn(value=Dist.CLIENT)
public class BlockRenderModel
implements MiapiModel {
    BlockState blockState;
    public MaterialIcons.SpinSettings spinSettings = null;
    Transform transform;

    public BlockRenderModel(BlockState block, Transform transform) {
        this.blockState = block;
        this.transform = transform;
    }

    @Override
    public void render(PoseStack matrixStack, ItemStack stack, ItemDisplayContext transformationMode, float tickDelta, MultiBufferSource vertexConsumers, LivingEntity entity, int light, int overlay) {
        matrixStack.pushPose();
        this.transform.applyPosition(matrixStack);
        if (this.spinSettings != null) {
            this.spinSettings.multiplyMatrices(matrixStack);
        }
        Minecraft.getInstance().getBlockRenderer().renderSingleBlock(this.blockState, matrixStack, vertexConsumers, light, overlay);
        matrixStack.popPose();
    }
}

