/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.client.renderer;

import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class MovedVertexConsumer
implements VertexConsumer {
    public VertexConsumer delegate;
    float uOffset;
    float vOffset;

    public MovedVertexConsumer(VertexConsumer delegate, TextureAtlasSprite original, TextureAtlasSprite target) {
        this.delegate = delegate;
        this.uOffset = target.getU0() - original.getU0();
        this.vOffset = target.getV0() - original.getV0();
    }

    public void addVertex(float x, float y, float z, int color, float u, float v, int packedOverlay, int packedLight, float normalX, float normalY, float normalZ) {
        this.addVertex(x, y, z);
        this.setColor(color);
        this.setUv(u += this.uOffset, v += this.vOffset);
        this.setOverlay(packedOverlay);
        this.setLight(packedLight);
        this.setNormal(normalX, normalY, normalZ);
    }

    public VertexConsumer addVertex(float x, float y, float z) {
        return this.delegate.addVertex(x, y, z);
    }

    public VertexConsumer setColor(int red, int green, int blue, int alpha) {
        return this.delegate.setColor(red, green, blue, alpha);
    }

    public VertexConsumer setUv(float u, float v) {
        return this.delegate.setUv(u, v);
    }

    public VertexConsumer setUv1(int u, int v) {
        return this.delegate.setUv1(u, v);
    }

    public VertexConsumer setOverlay(int v) {
        return this.delegate.setOverlay(v);
    }

    public VertexConsumer setUv2(int u, int v) {
        return this.delegate.setUv2(u, v);
    }

    public VertexConsumer setNormal(float x, float y, float z) {
        return this.delegate.setNormal(x, y, z);
    }
}

