/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.client.renderer;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import smartin.miapi.datapack.ReloadEvents;
import smartin.miapi.events.MiapiEvents;

@OnlyIn(value=Dist.CLIENT)
public class SpriteLoader {
    public static List<String> preLoadTexturePaths = new ArrayList<String>();
    public static List<ResourceLocation> miapiModels = new ArrayList<ResourceLocation>();

    public static void setup() {
        ReloadEvents.START.subscribe((isClient, registryAccess) -> ((MiapiEvents.EmptyEvent)MiapiEvents.CLEAR_CACHE.invoker()).onReload());
    }

    public static void clientStart() {
        preLoadTexturePaths.add("skin");
        preLoadTexturePaths.add("gui");
        preLoadTexturePaths.forEach(preLoadTexturePath -> {});
        Minecraft.getInstance().getResourceManager().listResourceStacks("models", identifier -> identifier.getNamespace().equals("miapi")).forEach((identifier, resources) -> miapiModels.add((ResourceLocation)identifier));
    }

    protected static void onTextureStitch(TextureAtlas atlas, Consumer<ResourceLocation> spriteAdder) {
        if (TextureAtlas.LOCATION_BLOCKS.equals((Object)atlas.location())) {
            Map map = Minecraft.getInstance().getResourceManager().listResources("textures/item", s -> s.getNamespace().equals("miapi"));
            map.forEach((identifier, resource) -> {
                String string = identifier.toString().replace("textures/", "").replace(".png", "");
                spriteAdder.accept(ResourceLocation.parse((String)string));
            });
        }
    }
}

