/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.armortrim.ArmorTrim;
import net.minecraft.world.item.armortrim.TrimPattern;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TrimRenderer {
    public static final TextureAtlas armorTrimsAtlas = Minecraft.getInstance().getModelManager().getAtlas(Sheets.ARMOR_TRIMS_SHEET);
    public static final TextureAtlas atlas = Minecraft.getInstance().getModelManager().getAtlas(TextureAtlas.LOCATION_BLOCKS);

    public static void renderTrims(PoseStack matrixStack, BakedQuad bakedQuad, TrimMode trimMode, int light, MultiBufferSource vertexConsumers, Holder<ArmorMaterial> armorMaterial, ItemStack itemStack) {
        ArmorTrim armorTrim = (ArmorTrim)itemStack.getComponents().get(DataComponents.TRIM);
        if (armorTrim != null) {
            TextureAtlasSprite sprite;
            switch (trimMode.ordinal()) {
                case 1: {
                    TextureAtlasSprite textureAtlasSprite = null;
                    break;
                }
                case 2: {
                    TextureAtlasSprite textureAtlasSprite = armorTrimsAtlas.getSprite(armorTrim.innerTexture(armorMaterial));
                    break;
                }
                case 3: {
                    TextureAtlasSprite textureAtlasSprite = armorTrimsAtlas.getSprite(armorTrim.innerTexture(armorMaterial));
                    break;
                }
                default: {
                    TextureAtlasSprite textureAtlasSprite = sprite = null;
                }
            }
            if (sprite != null) {
                VertexConsumer vertexConsumer = sprite.wrap(vertexConsumers.getBuffer(Sheets.armorTrimsSheet((boolean)((TrimPattern)armorTrim.pattern().value()).decal())));
                vertexConsumer.putBulkData(matrixStack.last(), bakedQuad, 1.0f, 1.0f, 1.0f, 1.0f, light, OverlayTexture.NO_OVERLAY);
            }
        }
    }

    public static enum TrimMode {
        NONE,
        ITEM,
        ARMOR_LAYER_ONE,
        ARMOR_LAYER_TWO;

    }
}

