/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.config;

import com.redpxnda.nucleus.codec.auto.ConfigAutoCodec;
import com.redpxnda.nucleus.config.ConfigBuilder;
import com.redpxnda.nucleus.config.ConfigManager;
import com.redpxnda.nucleus.config.ConfigObject;
import com.redpxnda.nucleus.config.ConfigType;
import java.util.ArrayList;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import smartin.miapi.Environment;
import smartin.miapi.Miapi;
import smartin.miapi.config.MiapiClientConfig;
import smartin.miapi.config.MiapiServerConfig;
import smartin.miapi.events.MiapiEvents;
import smartin.miapi.loot.LootHelper;
import smartin.miapi.modules.abilities.key.KeyBindManager;
import smartin.miapi.modules.properties.GlintProperty;

@ConfigAutoCodec.ConfigClassMarker
public class MiapiConfig {
    public static MiapiConfig INSTANCE = new MiapiConfig();
    @OnlyIn(value=Dist.CLIENT)
    public MiapiClientConfig client;
    public MiapiServerConfig server;
    public static ConfigObject<MiapiServerConfig> serverConfigObject;
    @OnlyIn(value=Dist.CLIENT)
    public static ConfigObject<MiapiClientConfig> clientConfigObject;

    public static MiapiClientConfig getClientConfig() {
        if (INSTANCE == null || MiapiConfig.INSTANCE.client == null) {
            return new MiapiClientConfig();
        }
        return MiapiConfig.INSTANCE.client;
    }

    public static MiapiServerConfig getServerConfig() {
        if (INSTANCE == null || MiapiConfig.INSTANCE.server == null) {
            return new MiapiServerConfig();
        }
        return MiapiConfig.INSTANCE.server;
    }

    public static void setupConfigs() {
        if (Environment.isClient()) {
            MiapiConfig.setupClientConfig();
        }
        serverConfigObject = ConfigManager.register((ConfigBuilder)ConfigBuilder.automatic(MiapiServerConfig.class).id("miapi:server").fileLocation("miapi_server").type(ConfigType.SERVER_CLIENT_SYNCED).creator(MiapiServerConfig::new).updateListener(c -> {
            MiapiServerConfig.INSTANCE = c;
            MiapiConfig.INSTANCE.server = c;
            ((MiapiEvents.EmptyEvent)MiapiEvents.CLEAR_CACHE.invoker()).onReload();
            if (Miapi.server == null || Miapi.server.getConnection() != null) {
                // empty if block
            }
            LootHelper.adjusted = new ArrayList<LootItemFunction>();
            if (MiapiConfig.getServerConfig().lootCategory.isEnabled) {
                if (MiapiConfig.getServerConfig().lootCategory.isSwappingMaterials) {
                    LootHelper.adjusted.add(MiapiConfig.getServerConfig().lootCategory.materialSwapLootFunction);
                }
                if (MiapiConfig.getServerConfig().lootCategory.isSwappingModules) {
                    LootHelper.adjusted.add(MiapiConfig.getServerConfig().lootCategory.moduleSwapLootFunction);
                }
            }
        }));
        serverConfigObject.load();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void setupClientConfig() {
        clientConfigObject = ConfigManager.register((ConfigBuilder)ConfigBuilder.automatic(MiapiClientConfig.class).id("miapi:client").fileLocation("miapi_client").type(ConfigType.COMMON).creator(MiapiClientConfig::new).updateListener(c -> {
            MiapiClientConfig.INSTANCE = c;
            MiapiConfig.INSTANCE.client = c;
            if (Environment.isClient()) {
                GlintProperty.updateConfig();
            }
            KeyBindManager.configLoad(MiapiConfig.getClientConfig().other.bindings);
            ((MiapiEvents.EmptyEvent)MiapiEvents.CLEAR_CACHE.invoker()).onReload();
        }));
    }
}

