/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.craft;

import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.client.Minecraft;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import smartin.miapi.Miapi;
import smartin.miapi.blocks.ModularWorkBenchEntity;
import smartin.miapi.client.gui.crafting.CraftingScreenHandler;
import smartin.miapi.item.ModularItemStackConverter;
import smartin.miapi.mixin.RegistryOpsAccessor;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.modules.properties.slot.SlotProperty;
import smartin.miapi.modules.properties.util.ComponentApplyProperty;
import smartin.miapi.modules.properties.util.CraftingProperty;
import smartin.miapi.registries.RegistryInventory;

public class CraftAction {
    public final ItemModule toAdd;
    public final Player player;
    public final List<String> slotLocation = new ArrayList<String>();
    private ItemStack old;
    private final ModularWorkBenchEntity blockEntity;
    private Container linkedInventory;
    private int inventoryOffset;
    public Map<ResourceLocation, JsonElement> data = new ConcurrentHashMap<ResourceLocation, JsonElement>();
    public static final List<CraftingEvent> events = new ArrayList<CraftingEvent>();
    public CraftingScreenHandler screenHandler;

    public CraftAction(ItemStack old, SlotProperty.ModuleSlot slot, @Nullable ItemModule toAdd, Player player, ModularWorkBenchEntity bench, Map<ResourceLocation, JsonElement> data, CraftingScreenHandler craftingScreenHandler) {
        this.screenHandler = craftingScreenHandler;
        this.old = ModularItemStackConverter.getModularVersion(old);
        this.toAdd = toAdd;
        this.slotLocation.addAll(slot.getAsLocation());
        this.player = player;
        this.blockEntity = bench;
        this.data = data;
    }

    public CraftAction(FriendlyByteBuf buf, ModularWorkBenchEntity bench, CraftingScreenHandler craftingScreenHandler) {
        int size = buf.readInt();
        this.screenHandler = craftingScreenHandler;
        for (int i = 0; i < size; ++i) {
            this.slotLocation.add(buf.readUtf());
        }
        String modules = buf.readUtf();
        this.toAdd = !modules.equals("null") ? RegistryInventory.ITEM_MODULE_MIAPI_REGISTRY.get(modules) : null;
        this.player = CraftAction.getPlayerFromUuid(buf.readUUID());
        this.blockEntity = bench;
        int numBuffers = buf.readInt();
        for (int i = 0; i < numBuffers; ++i) {
            String key = buf.readUtf();
            String value = buf.readUtf();
            JsonElement element = (JsonElement)Miapi.gson.fromJson(value, JsonElement.class);
            this.data.put(ResourceLocation.parse((String)key), element);
        }
    }

    public FriendlyByteBuf toPacket(FriendlyByteBuf buf) {
        buf.writeInt(this.slotLocation.size());
        for (String slot : this.slotLocation) {
            buf.writeUtf(slot);
        }
        if (this.toAdd != null) {
            buf.writeUtf(this.toAdd.id().toString());
        } else {
            buf.writeUtf("null");
        }
        buf.writeUUID(this.player.getUUID());
        buf.writeInt(this.data.size());
        this.data.forEach((key, value) -> {
            buf.writeUtf(key.toString());
            String jsonString = Miapi.gson.toJson(value);
            buf.writeUtf(jsonString);
        });
        return buf;
    }

    public void setItem(ItemStack stack) {
        this.old = ModularItemStackConverter.getModularVersion(stack);
    }

    public boolean canPerform() {
        ItemStack crafted = this.getPreview();
        AtomicBoolean test = new AtomicBoolean(true);
        this.forEachCraftingProperty(crafted, (guiCraftingProperty, module, inventory, start, end, buffer) -> {
            if (test.get()) {
                test.set(guiCraftingProperty.canPerform(this.old, crafted, this.blockEntity, this.player, this, this.toAdd, inventory, buffer));
            }
        });
        return test.get();
    }

    public Pair<Map<CraftingProperty, Boolean>, Boolean> fullCanPerform() {
        HashMap map = new HashMap();
        ItemStack crafted = this.getPreview();
        AtomicBoolean test = new AtomicBoolean(true);
        this.forEachCraftingProperty(crafted, (guiCraftingProperty, module, inventory, start, end, dataMap) -> {
            boolean result = guiCraftingProperty.canPerform(this.old, crafted, this.blockEntity, this.player, this, this.toAdd, inventory, dataMap);
            map.put(guiCraftingProperty, result);
            if (test.get()) {
                test.set(result);
            }
        });
        return Pair.of(map, (Object)test.get());
    }

    protected void updateItem(ItemStack stack, ModuleInstance instance) {
        instance.getRoot().writeToItem(stack);
    }

    public void linkInventory(Container inventory, int offset) {
        this.linkedInventory = inventory;
        this.inventoryOffset = offset;
    }

    public ItemStack perform() {
        ItemStack[] craftingStack = new ItemStack[]{this.craft()};
        ComponentApplyProperty.updateItemStack(craftingStack[0], this.player.level().registryAccess());
        this.forEachCraftingProperty(craftingStack[0], (craftingProperty, module, inventory, start, end, buffer) -> {
            List<ItemStack> itemStacks = craftingProperty.performCraftAction(this.old, craftingStack[0], this.player, this.blockEntity, this, this.toAdd, inventory, buffer);
            craftingStack[0] = itemStacks.removeFirst();
            if (module != null) {
                // empty if block
            }
            for (int i = start; i < end; ++i) {
                this.linkedInventory.setItem(i, itemStacks.get(i - start));
            }
        });
        ComponentApplyProperty.updateItemStack(craftingStack[0], this.player.level().registryAccess());
        ModuleInstance parsingInstance = ItemModule.getModules(craftingStack[0]);
        for (int i = this.slotLocation.size() - 1; i >= 0; --i) {
            if (parsingInstance == null) {
                return craftingStack[0];
            }
            parsingInstance = parsingInstance.getSubModuleMap().get(this.slotLocation.get(i));
        }
        for (CraftingEvent eventHandler : events) {
            craftingStack[0] = eventHandler.onCraft(this.old, craftingStack[0], parsingInstance);
        }
        this.linkedInventory.setChanged();
        if (this.player != null && this.player.level() != null) {
            RegistryOps.RegistryInfoLookup lookup = ((RegistryOpsAccessor)RegistryOps.create((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)this.player.level().registryAccess())).getLookupProvider();
            ItemModule.getModules(craftingStack[0]).allSubModules().forEach(m -> {
                m.lookup = lookup;
                m.registryAccess = this.player.level().registryAccess();
            });
        }
        return craftingStack[0];
    }

    private ItemStack craft() {
        ItemStack craftingStack = this.old.copy();
        ModuleInstance oldBaseModule = ItemModule.getModules(this.old);
        ModuleInstance newBaseModule = oldBaseModule.copy();
        Map<Object, Object> subModuleMap = new HashMap();
        if (this.slotLocation.isEmpty()) {
            if (this.toAdd == null || this.toAdd == ItemModule.empty || this.toAdd.id().equals((Object)Miapi.id("empty"))) {
                return ItemStack.EMPTY;
            }
            subModuleMap = oldBaseModule.getSubModuleMap();
            ModuleInstance newModule = new ModuleInstance(this.toAdd);
            subModuleMap.forEach((id, module) -> {
                SlotProperty.ModuleSlot slot = SlotProperty.getSlots(newModule).get(id);
                if (slot != null && slot.allowedIn((ModuleInstance)module)) {
                    newModule.setSubModule((String)id, (ModuleInstance)module);
                    newModule.sortSubModule();
                }
            });
            newModule.writeToItem(craftingStack);
            newModule.clearCaches();
            return craftingStack;
        }
        ModuleInstance parsingInstance = newBaseModule;
        for (int i = this.slotLocation.size() - 1; i > 0; --i) {
            if (parsingInstance == null) {
                Miapi.LOGGER.error("Critical error in replace Logic!, step craft slot position of crafting was not found!");
                this.slotLocation.forEach(slot -> Miapi.LOGGER.error("slot id" + slot));
                return this.old;
            }
            parsingInstance = parsingInstance.getSubModule(this.slotLocation.get(i));
        }
        if ((this.toAdd == null || this.toAdd == ItemModule.empty || this.toAdd.id().equals((Object)Miapi.id("empty"))) && parsingInstance != null) {
            parsingInstance.removeSubModule(this.slotLocation.getFirst());
        } else {
            ModuleInstance newModule = new ModuleInstance(this.toAdd);
            ModuleInstance moduleMapInstance = parsingInstance.getSubModule(this.slotLocation.getFirst());
            if (moduleMapInstance != null) {
                subModuleMap = moduleMapInstance.getSubModuleMap();
            }
            subModuleMap.forEach((id, module) -> {
                SlotProperty.ModuleSlot slot = SlotProperty.getSlots(newModule).get(id);
                if (slot != null && slot.allowedIn((ModuleInstance)module)) {
                    newModule.setSubModule((String)id, (ModuleInstance)module);
                }
            });
            parsingInstance.setSubModule(this.slotLocation.getFirst(), newModule);
        }
        newBaseModule.writeToItem(craftingStack);
        craftingStack = craftingStack.copy();
        return craftingStack;
    }

    public ItemStack getPreview() {
        AtomicReference<ItemStack> craftingStack = new AtomicReference<ItemStack>(this.craft());
        this.forEachCraftingProperty(craftingStack.get(), (guiCraftingProperty, module, inventory, start, end, buffer) -> craftingStack.set(guiCraftingProperty.preview(this.old, (ItemStack)craftingStack.get(), this.player, this.blockEntity, this, this.toAdd, inventory, buffer)));
        ComponentApplyProperty.updateItemStack(craftingStack.get(), Miapi.registryAccess);
        ModuleInstance parsingInstance = ItemModule.getModules(craftingStack.get());
        for (int i = this.slotLocation.size() - 1; i >= 0; --i) {
            if (parsingInstance == null) {
                Miapi.LOGGER.error("Critical error in replace Logic!, step preview slot position of crafting was not found!");
                this.slotLocation.forEach(slot -> Miapi.LOGGER.error("slot id" + slot));
                return this.old;
            }
            if (this.player != null && this.player.level() != null) {
                parsingInstance.registryAccess = this.player.level().registryAccess();
            }
            parsingInstance = parsingInstance.getSubModule(this.slotLocation.get(i));
        }
        for (CraftingEvent eventHandler : events) {
            craftingStack.set(eventHandler.onPreview(this.old, craftingStack.get(), parsingInstance));
        }
        ItemModule.getModules(craftingStack.get()).clearCaches();
        this.linkedInventory.setChanged();
        try {
            if (this.player != null && this.player.level() != null) {
                ModuleInstance moduleInstance = ItemModule.getModules(craftingStack.get());
                RegistryOps ops = RegistryOps.create((DynamicOps)NbtOps.INSTANCE, (HolderLookup.Provider)this.player.level().registryAccess());
                ItemStack stack = craftingStack.get();
                ((ModuleInstance)((Pair)ModuleInstance.CODEC.decode((DynamicOps)ops, (Object)((Tag)ModuleInstance.CODEC.encodeStart((DynamicOps)ops, (Object)moduleInstance).result().get())).result().get()).getFirst()).writeToItem(stack);
                return stack;
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return craftingStack.get();
    }

    public void setData(Map<ResourceLocation, JsonElement> dataMap) {
        this.data = dataMap;
    }

    @Nullable
    public ModuleInstance getModifyingModuleInstance(ItemStack itemStack) {
        ModuleInstance parsingInstance = ItemModule.getModules(itemStack);
        for (int i = this.slotLocation.size() - 1; i >= 0; --i) {
            if (parsingInstance == null) {
                Miapi.LOGGER.error("Critical error in replace Logic!, step modifiying module slot position of crafting was not found!");
                this.slotLocation.forEach(slot -> Miapi.LOGGER.error("slot id" + slot));
                return parsingInstance;
            }
            parsingInstance = parsingInstance.getSubModule(this.slotLocation.get(i));
        }
        return parsingInstance;
    }

    public void forEachCraftingProperty(ItemStack crafted, PropertyConsumer propertyConsumer) {
        ModuleInstance parsingInstance = ItemModule.getModules(crafted);
        for (int i = this.slotLocation.size() - 1; i >= 0; --i) {
            if (parsingInstance == null) {
                Miapi.LOGGER.error("Critical error in replace Logic!, step crafting property slot position of crafting was not found!");
                this.slotLocation.forEach(slot -> Miapi.LOGGER.error("slot id" + slot));
                return;
            }
            parsingInstance = parsingInstance.getSubModule(this.slotLocation.get(i));
        }
        AtomicInteger integer = new AtomicInteger(this.inventoryOffset);
        ModuleInstance newInstance = parsingInstance;
        List<CraftingProperty> sortedProperties = RegistryInventory.MODULE_PROPERTY_MIAPI_REGISTRY.getFlatMap().values().stream().filter(CraftingProperty.class::isInstance).filter(property -> ((CraftingProperty)((Object)property)).shouldExecuteOnCraft(newInstance, ItemModule.getModules(crafted), crafted, this)).map(CraftingProperty.class::cast).sorted(Comparator.comparingDouble(CraftingProperty::getPriority)).toList();
        for (CraftingProperty craftingProperty : sortedProperties) {
            ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>();
            int startPos = integer.get();
            int endPos = startPos + craftingProperty.getSlotPositions().size();
            for (int i = startPos; i < endPos; ++i) {
                itemStacks.add(this.linkedInventory.getItem(i));
            }
            propertyConsumer.accept(craftingProperty, newInstance, itemStacks, startPos, endPos, this.data);
            integer.set(endPos);
        }
    }

    protected static Player getPlayerFromUuid(UUID uuid) {
        if (Miapi.server != null) {
            return Miapi.server.getPlayerList().getPlayer(uuid);
        }
        if (Minecraft.getInstance() != null && Minecraft.getInstance().level != null) {
            return Minecraft.getInstance().level.getPlayerByUUID(uuid);
        }
        return null;
    }

    public static interface PropertyConsumer {
        public void accept(CraftingProperty var1, ModuleInstance var2, List<ItemStack> var3, int var4, int var5, Map<ResourceLocation, JsonElement> var6);
    }

    public static interface CraftingEvent {
        public ItemStack onCraft(ItemStack var1, ItemStack var2, @Nullable ModuleInstance var3);

        public ItemStack onPreview(ItemStack var1, ItemStack var2, @Nullable ModuleInstance var3);
    }
}

