/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.datapack;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.UnboundedMapCodec;
import dev.architectury.event.events.common.PlayerEvent;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import smartin.miapi.Environment;
import smartin.miapi.Miapi;
import smartin.miapi.modules.cache.CacheCommands;
import smartin.miapi.network.Networking;
import smartin.miapi.registries.MiapiRegistry;

public class ReloadEvents {
    public static MiapiRegistry<DataSyncer> DATA_SYNCER_REGISTRY = MiapiRegistry.getInstance(DataSyncer.class);
    private static final List<String> RECEIVED_SYNCER = new ArrayList<String>();
    private static final int MAX_PAYLOAD_SIZE = 1000000;
    protected static final String RELOAD_PACKET_ID = "miapi:events_reload_s2c";
    public static final Map<ResourceLocation, String> DATA_PACKS = Collections.synchronizedMap(new LinkedHashMap());
    public static final Map<ResourceLocation, String> RAW_DATA_PACKS = Collections.synchronizedMap(new LinkedHashMap());
    public static Map<String, List<String>> SYNCED_PATHS = new HashMap<String, List<String>>();
    public static final ReloadEvent START = new ReloadEvent();
    public static final ReloadEvent MAIN = new ReloadEvent();
    public static final ReloadEvent END = new ReloadEvent();
    public static volatile int reloadCounter = 0;
    private static long clientReloadTimeStart = System.nanoTime();

    public static void registerDataPackPathToSync(String modId, String path) {
        SYNCED_PATHS.computeIfAbsent(modId, k -> new ArrayList()).add(path);
    }

    public static void setup() {
        if (Environment.isClient()) {
            ReloadEvents.clientSetup();
        }
        Networking.registerC2SPacket(RELOAD_PACKET_ID, (buf, serverPlayerEntity) -> {
            boolean allowHandshake = buf.readBoolean();
            boolean reloadServer = buf.readBoolean();
            if (!allowHandshake) {
                Miapi.LOGGER.warn("Client " + String.valueOf(serverPlayerEntity.getUUID()) + " rejected reload? this should never happen!");
                Miapi.server.sendSystemMessage((Component)Component.literal((String)("Client " + String.valueOf(serverPlayerEntity.getDisplayName()) + " failed to reload.")));
            } else if (reloadServer && serverPlayerEntity.hasPermissions(4)) {
                CacheCommands.triggerServerReload();
            } else {
                ReloadEvents.triggerReloadOnClient(serverPlayerEntity);
            }
        });
        UnboundedMapCodec codec = Codec.unboundedMap((Codec)ResourceLocation.CODEC, Miapi.CHUNKED_STRING_CODEC);
        StreamCodec streamCodec = ByteBufCodecs.fromCodecTrusted((Codec)codec);
        DATA_SYNCER_REGISTRY.register(Miapi.id("data_packs"), (DataSyncer)new SimpleSyncer<Map<ResourceLocation, String>>(streamCodec){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Map<ResourceLocation, String> getDataServer() {
                LinkedHashMap<ResourceLocation, String> toSend;
                Map<ResourceLocation, String> map = DATA_PACKS;
                synchronized (map) {
                    toSend = new LinkedHashMap<ResourceLocation, String>(DATA_PACKS);
                }
                return toSend;
            }

            @Override
            public void interpretData(Map<ResourceLocation, String> data) {
                Minecraft.getInstance().execute(() -> {
                    Map<ResourceLocation, String> map = DATA_PACKS;
                    synchronized (map) {
                        DATA_PACKS.clear();
                        DATA_PACKS.putAll(data);
                    }
                    DataPackLoader.trigger(data);
                });
            }
        });
        PlayerEvent.PLAYER_JOIN.register(ReloadEvents::triggerReloadOnClient);
        START.subscribe((isClient, registryAccess) -> ++reloadCounter);
        END.subscribe((isClient, registryAccess) -> --reloadCounter);
        DataPackLoader.subscribe(dataPack -> {
            Map<ResourceLocation, String> map = DATA_PACKS;
            synchronized (map) {
                DATA_PACKS.clear();
                DATA_PACKS.putAll(dataPack);
            }
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void requestClientSideDataReload(boolean forceServerReload) {
        FriendlyByteBuf buf = Networking.createBuffer();
        buf.writeBoolean(true);
        buf.writeBoolean(forceServerReload);
        Networking.sendC2S(RELOAD_PACKET_ID, buf);
    }

    public static void triggerReloadOnClient(ServerPlayer entity) {
        DATA_SYNCER_REGISTRY.getFlatMap().forEach((id, syncer) -> {
            try {
                byte[] fullData = syncer.createDataServer().copy().array();
                ReloadEvents.sendInChunks(entity, id.toString(), fullData);
            }
            catch (RuntimeException e) {
                Miapi.LOGGER.error("Datasyncer " + String.valueOf(id) + " was not able to create Packet with error ", (Throwable)e);
            }
        });
    }

    private static void sendInChunks(ServerPlayer entity, String id, byte[] data) {
        int totalChunks = (int)Math.ceil((double)data.length / 1000000.0);
        for (int i = 0; i < totalChunks; ++i) {
            int start = i * 1000000;
            int end = Math.min(start + 1000000, data.length);
            byte[] chunk = Arrays.copyOfRange(data, start, end);
            FriendlyByteBuf buf = Networking.createBuffer();
            buf.writeUtf(id);
            buf.writeInt(totalChunks);
            buf.writeInt(i);
            buf.writeInt(chunk.length);
            buf.writeBytes(chunk);
            Networking.sendS2C(RELOAD_PACKET_ID, entity, buf);
        }
    }

    public static boolean isInReload() {
        return reloadCounter != 0;
    }

    private static void clientSetup() {
        HashMap chunkBuffer = new HashMap();
        HashMap expectedChunks = new HashMap();
        Networking.registerS2CPacket(RELOAD_PACKET_ID, buffer -> {
            String id = buffer.readUtf();
            int totalChunks = buffer.readInt();
            int chunkIndex = buffer.readInt();
            int len = buffer.readInt();
            if (len < 0 || len > 1000000) {
                Miapi.LOGGER.error("MIAPI invalid chunk length {} for {}", (Object)len, (Object)id);
                return;
            }
            byte[] chunk = new byte[len];
            buffer.readBytes(chunk);
            chunkBuffer.computeIfAbsent(id, k -> new ArrayList<Object>(Collections.nCopies(totalChunks, null))).set(chunkIndex, chunk);
            expectedChunks.putIfAbsent(id, totalChunks);
            if (((List)chunkBuffer.get(id)).stream().allMatch(Objects::nonNull)) {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                for (byte[] part : (List)chunkBuffer.get(id)) {
                    try {
                        out.write(part);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        return;
                    }
                }
                byte[] merged = out.toByteArray();
                FriendlyByteBuf reconstructed = new FriendlyByteBuf(Unpooled.wrappedBuffer((byte[])merged));
                DATA_SYNCER_REGISTRY.get(id).interpretDataClient(reconstructed);
                RECEIVED_SYNCER.add(id);
                chunkBuffer.remove(id);
                expectedChunks.remove(id);
            }
            if (RECEIVED_SYNCER.size() == DATA_SYNCER_REGISTRY.getFlatMap().keySet().size()) {
                RECEIVED_SYNCER.clear();
                chunkBuffer.clear();
                expectedChunks.clear();
                ReloadEvents.executeReloadClient();
            }
        });
    }

    private static void executeReloadClient() {
        Minecraft.getInstance().execute(() -> {
            clientReloadTimeStart = System.nanoTime();
            ++reloadCounter;
            Object access = Minecraft.getInstance().level != null ? Minecraft.getInstance().level.registryAccess() : Minecraft.getInstance().getConnection().registryAccess();
            START.fireEvent(true, (RegistryAccess)access);
            MAIN.fireEvent(true, (RegistryAccess)access);
            END.fireEvent(true, (RegistryAccess)access);
            --reloadCounter;
            Miapi.LOGGER.info("Client load took " + (double)(System.nanoTime() - clientReloadTimeStart) / 1000.0 / 1000.0 + " ms");
        });
    }

    public static class ReloadEvent {
        private final Map<EventListener, Float> mainListeners = new HashMap<EventListener, Float>();

        public void subscribe(EventListener listener, float priority) {
            this.mainListeners.put(listener, Float.valueOf(priority));
        }

        public void subscribe(EventListener listener) {
            this.subscribe(listener, 0.0f);
        }

        public void unsubscribe(EventListener listener) {
            this.mainListeners.remove(listener);
        }

        public void fireEvent(boolean isClient, @Nullable RegistryAccess registryAccess) {
            try {
                this.mainListeners.entrySet().stream().sorted(Map.Entry.comparingByValue()).forEach(eventListenerFloatEntry -> {
                    try {
                        ((EventListener)eventListenerFloatEntry.getKey()).onEvent(isClient, registryAccess);
                    }
                    catch (RuntimeException e) {
                        Miapi.LOGGER.error("Exception during reload", (Throwable)e);
                    }
                });
            }
            catch (RuntimeException e) {
                Miapi.LOGGER.error("Exception during Reload!", (Throwable)e);
            }
        }
    }

    @FunctionalInterface
    public static interface EventListener {
        public void onEvent(boolean var1, @Nullable RegistryAccess var2);
    }

    public static class DataPackLoader {
        protected static final List<EventListener> listeners = new ArrayList<EventListener>();

        public static void subscribe(EventListener listener) {
            listeners.add(listener);
        }

        public static void unsubscribe(EventListener listener) {
            listeners.remove(listener);
        }

        public static void trigger(Map<ResourceLocation, String> dataPack) {
            for (EventListener listener : listeners) {
                try {
                    listener.onEvent(dataPack);
                }
                catch (Exception e) {
                    Miapi.LOGGER.error("Exception during reload", (Throwable)e);
                }
            }
        }

        public static interface EventListener {
            public void onEvent(Map<ResourceLocation, String> var1);
        }
    }

    public static interface DataSyncer<T> {
        public FriendlyByteBuf createDataServer();

        public void interpretDataClient(FriendlyByteBuf var1);
    }

    public static abstract class SimpleSyncer<T>
    implements DataSyncer {
        public StreamCodec<ByteBuf, T> streamCodec;

        public SimpleSyncer(StreamCodec<ByteBuf, T> streamCodec) {
            this.streamCodec = streamCodec;
        }

        public abstract T getDataServer();

        public abstract void interpretData(T var1);

        @Override
        public FriendlyByteBuf createDataServer() {
            FriendlyByteBuf buf = Networking.createBuffer();
            this.streamCodec.encode((Object)buf, this.getDataServer());
            return buf;
        }

        @Override
        public void interpretDataClient(FriendlyByteBuf buf) {
            this.interpretData(this.streamCodec.decode((Object)buf));
        }
    }
}

