/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.datapack;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.netty.handler.codec.DecoderException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import smartin.miapi.Miapi;
import smartin.miapi.config.MiapiConfig;
import smartin.miapi.datapack.ReloadEvents;
import smartin.miapi.editor.DocPage;
import smartin.miapi.item.ItemToModularConverter;
import smartin.miapi.material.CodecMaterial;
import smartin.miapi.material.CodecMaterialExtension;
import smartin.miapi.material.MaterialProperty;
import smartin.miapi.material.base.Material;
import smartin.miapi.material.composite.material.DatapackComposite;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.ItemModuleExtension;
import smartin.miapi.modules.abilities.key.KeyBindManager;
import smartin.miapi.modules.edit_options.CreateItemOption.CreateItemOption;
import smartin.miapi.modules.edit_options.skins.SkinOptions;
import smartin.miapi.modules.synergies.SynergyManager;
import smartin.miapi.registries.MiapiRegistry;
import smartin.miapi.registries.RegistryInventory;

public class ReloadHelpers {
    public static void registerReloadHandlers() {
        ReloadHelpers.registerReloadHandler("miapi/modules", RegistryInventory.ITEM_MODULE_MIAPI_REGISTRY, ItemModule::loadFromData, -0.5f);
        ReloadHelpers.registerReloadHandler("miapi/module_extensions", () -> {}, (boolean isClient, ResourceLocation path, JsonElement data, RegistryAccess access) -> ItemModuleExtension.loadModuleExtension(path, data, isClient), (boolean isClient, ResourceLocation path, T data, RegistryAccess access) -> data.apply(), -0.4f);
        ReloadHelpers.registerReloadHandler("miapi/synergies", SynergyManager::clear, (boolean isClient, ResourceLocation path, JsonElement data, RegistryAccess access) -> (SynergyManager.Synergy)((Pair)SynergyManager.SYNERGY_CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)data).getOrThrow(string -> new DecoderException("Could not decode Synergy " + String.valueOf(path) + string))).getFirst(), (boolean isClient, ResourceLocation path, T data, RegistryAccess access) -> data.register(), 2.0f);
        ReloadHelpers.registerReloadHandler("miapi/wiki", () -> DocPage.PAGE_LOOKUP.clear(), (boolean isClient, ResourceLocation path, JsonElement data, RegistryAccess registryAccess) -> (DocPage)((Pair)DocPage.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)data).getOrThrow(s -> new DecoderException("could not decode wiki info" + s))).getFirst(), (boolean isClient, ResourceLocation path, T data, RegistryAccess registryAccess) -> DocPage.setupLookup(data), 0.0f);
        ReloadHelpers.registerReloadHandler(ReloadEvents.MAIN, "miapi/skins/module", SkinOptions.skins, (boolean isClient, ResourceLocation path, String data, RegistryAccess registryAccess) -> SkinOptions.load(path, data), 1.0f);
        ReloadHelpers.registerReloadHandler(ReloadEvents.MAIN, "miapi/skins/tab", SkinOptions.tabMap, (boolean isClient, ResourceLocation path, String data, RegistryAccess registryAccess) -> SkinOptions.loadTabData(data), 1.0f);
        ReloadHelpers.registerReloadHandler(ReloadEvents.END, "miapi/create_options", (Boolean isClient) -> CreateItemOption.CREATE_ITEM_MIAPI_REGISTRY.clear(), (boolean isClient, ResourceLocation path, String data, RegistryAccess registryAccess) -> {
            CreateItemOption.CreateItem createItem = (CreateItemOption.CreateItem)Miapi.gson.fromJson(data, CreateItemOption.JsonCreateItem.class);
            if (createItem.getBaseModule() != null && createItem.getItem() != null) {
                CreateItemOption.CREATE_ITEM_MIAPI_REGISTRY.register(path, createItem);
            } else {
                Miapi.LOGGER.error("could not find module or item for create option " + String.valueOf(path));
                Miapi.LOGGER.error(data);
            }
        }, 0.0f);
        ReloadHelpers.registerReloadHandler(ReloadEvents.MAIN, "miapi/key_binding", true, isClient -> {}, isClient -> {}, (isClient, id, data, registryAccess) -> KeyBindManager.processKeybind(isClient, id, data), 0.0f);
        ReloadHelpers.registerReloadHandler("miapi/data_composite", DatapackComposite.DATA_COMPOSITE_REGISTRY, DatapackComposite.DATA_PACK_CODEC, 0.0f);
        ReloadHelpers.registerReloadHandler(ReloadEvents.MAIN, "miapi/material_extensions", (Boolean isClient) -> {}, (boolean isClient, ResourceLocation path, String data, RegistryAccess registryAccess) -> MaterialProperty.loadMaterialExtention(path, data, registryAccess), -1.5f);
        ReloadHelpers.registerHierarchicalReloadHandler("miapi/materials", CodecMaterial.CODEC, CodecMaterialExtension.CODEC, () -> MaterialProperty.MATERIAL_REGISTRY.clear(), (isClient, path, data, registryAccess) -> {
            data.setID(path);
            MaterialProperty.MATERIAL_REGISTRY.register(path, (Material)data);
            data.generateConverters(isClient);
        }, -2.0f);
        ReloadHelpers.registerReloadHandler(ReloadEvents.MAIN, "miapi/modular_converter", ItemToModularConverter.regexes, (boolean isClient, ResourceLocation path, String data, RegistryAccess registryAccess) -> ItemToModularConverter.setupModularConverter(path, data), 1.0f);
    }

    public static void registerReloadHandler(ReloadEvents.ReloadEvent event, String location, boolean syncToClient, Consumer<Boolean> beforeLoop, Consumer<Boolean> afterLoop, SingleFileHandler handler, float priority) {
        if (syncToClient) {
            ReloadEvents.registerDataPackPathToSync("miapi", location);
        }
        event.subscribe((isClient, registryAccess) -> {
            beforeLoop.accept(isClient);
            ReloadEvents.DATA_PACKS.forEach((path, data) -> {
                if (path.getPath().startsWith(location + "/")) {
                    try {
                        handler.reloadFile(isClient, (ResourceLocation)path, (String)data, registryAccess);
                    }
                    catch (RuntimeException e) {
                        Miapi.LOGGER.warn("could not load " + String.valueOf(path), (Throwable)e);
                    }
                }
            });
            afterLoop.accept(isClient);
        }, priority);
    }

    public static void registerReloadHandler(ReloadEvents.ReloadEvent event, String location, Consumer<Boolean> beforeLoop, SingleFileHandler handler, float priority) {
        ReloadHelpers.registerReloadHandler(event, location, true, beforeLoop, bl -> {}, handler, priority);
    }

    public static void registerReloadHandler(ReloadEvents.ReloadEvent event, String location, Map<?, ?> toClear, SingleFileHandler handler, float prio) {
        ReloadHelpers.registerReloadHandler(event, location, true, bl -> toClear.clear(), bl -> {}, handler, prio);
    }

    public static <T> void registerReloadHandler(String location, Map<ResourceLocation, T> registry, Codec<T> codec, float priority) {
        ReloadHelpers.registerReloadHandler(location, registry::clear, registry::put, codec, priority);
    }

    public static <T> void registerReloadHandler(String location, MiapiRegistry<T> registry, Codec<T> codec, float priority) {
        ReloadHelpers.registerReloadHandler(location, registry::clear, registry::register, codec, priority);
    }

    public static <T> void registerReloadHandler(String location, MiapiRegistry<T> registry, SimpleDecoder<T> decoder, float prio) {
        ReloadHelpers.registerReloadHandler(location, registry::clear, decoder, (boolean isClient, ResourceLocation path, T data, RegistryAccess registryAccess) -> registry.register(path, data), prio);
    }

    public static <T> void registerReloadHandler(final String location, Runnable clear, final SimpleDecoder<T> decoder, final SingleDecodedFileHandler<T> onDecode, float prio) {
        ReloadHelpers.registerReloadHandler(ReloadEvents.MAIN, location, true, before -> {}, after -> {}, new SingleFileHandler(){

            @Override
            public void reloadFile(boolean isClient, ResourceLocation path, String data, RegistryAccess registryAccess) {
                try {
                    JsonElement element = (JsonElement)Miapi.gson.fromJson(data, JsonObject.class);
                    ResourceLocation shortened = Miapi.id(path.toString().replace(":" + location + "/", ":").replace(".json", ""));
                    Object decoded = decoder.decode(isClient, shortened, element, registryAccess);
                    onDecode.reloadFile(isClient, shortened, decoded, registryAccess);
                }
                catch (RuntimeException e) {
                    Miapi.LOGGER.error("could not decode " + String.valueOf(path) + " for full-path " + String.valueOf(path) + e.getMessage());
                    if (MiapiConfig.getServerConfig().other.verboseLogging) {
                        Miapi.LOGGER.error("", (Throwable)e);
                    }
                    Miapi.LOGGER.error("raw data :");
                    Miapi.LOGGER.error(data);
                }
            }
        }, prio);
        ReloadEvents.START.subscribe((isClient, registryAccess) -> clear.run());
    }

    public static <T> void registerReloadHandler(String location, Runnable clear, BiConsumer<ResourceLocation, T> onDecode, Codec<T> codec, float priority) {
        ReloadHelpers.registerReloadHandler(location, clear, () -> {}, (isClient, path, data, registryAccess) -> onDecode.accept(path, data), codec, priority);
    }

    public static <T> void registerReloadHandler(String location, Runnable clear, Runnable post, SingleDecodedFileHandler<T> onDecode, Codec<T> codec, float priority) {
        CodecOptimisedFileHandler<Object> handler = new CodecOptimisedFileHandler<Object>(codec, (isClient, path, data, registryAccess) -> {
            ResourceLocation shortened = Miapi.id(path.toString().replace(":" + location + "/", ":").replace(".json", ""));
            onDecode.reloadFile(isClient, shortened, data, registryAccess);
        }, location);
        ReloadHelpers.registerReloadHandler(ReloadEvents.MAIN, location, true, before -> {}, after -> post.run(), handler, priority);
        ReloadEvents.START.subscribe((isClient, registryAccess) -> clear.run());
    }

    public static <B, E extends Extension<B>> void registerHierarchicalReloadHandler(String location, MiapiRegistry<B> registry, Codec<B> baseCodec, Codec<E> extCodec, float priority) {
        ReloadHelpers.registerHierarchicalReloadHandler(location, baseCodec, extCodec, registry::clear, (isClient, path, data, registryAccess) -> registry.register(path, data), priority);
    }

    public static <K, B extends K, E extends Extension<B>> void registerHierarchicalReloadHandler(String location, Codec<B> baseCodec, Codec<E> extCodec, final MiapiRegistry<K> registry, float priority) {
        ReloadHelpers.registerHierarchicalReloadHandler(location, baseCodec, extCodec, registry::clear, new SingleDecodedFileHandler<B>(){

            @Override
            public void reloadFile(boolean isClient, ResourceLocation path, B data, RegistryAccess registryAccess) {
                registry.register(path, data);
            }
        }, priority);
    }

    public static <B, E extends Extension<B>> void registerHierarchicalReloadHandler(String location, Codec<B> baseCodec, Codec<E> extCodec, Runnable clear, SingleDecodedFileHandler<B> baseHandler, float priority) {
        ReloadHelpers.registerHierarchicalReloadHandler(location, baseCodec, extCodec, clear, baseHandler, (isClient, path, data, registryAccess) -> {}, priority);
    }

    public static <B, E extends Extension<B>> void registerHierarchicalReloadHandler(String location, Codec<B> baseCodec, Codec<E> extCodec, Runnable clear, SingleDecodedFileHandler<B> baseHandler, SingleDecodedFileHandler<E> extensionHandler, float priority) {
        HashMap pendingBase = new HashMap();
        HashMap pendingExts = new HashMap();
        Codec<BaseOrExtension<B, E>> unionCodec = ReloadHelpers.createCodec(baseCodec, extCodec);
        ReloadHelpers.registerReloadHandler(location, clear, () -> {
            for (Map.Entry entry : pendingBase.entrySet()) {
                baseHandler.reloadFile(false, (ResourceLocation)entry.getKey(), entry.getValue(), null);
            }
            for (Map.Entry entry : pendingExts.entrySet()) {
                Extension ext = (Extension)entry.getValue();
                extensionHandler.reloadFile(false, (ResourceLocation)entry.getKey(), ext, null);
                Object base = pendingBase.get(ext.getTarget());
                if (base == null) {
                    Miapi.LOGGER.error("Missing base {} for extension {}", (Object)ext.getTarget(), entry.getKey());
                    continue;
                }
                Object extended = ext.applyTo(base);
                baseHandler.reloadFile(false, (ResourceLocation)entry.getKey(), extended, null);
            }
            pendingBase.clear();
            pendingExts.clear();
        }, (isClient, id, decoded, registryAccess) -> {
            if (decoded instanceof BaseOrExtension.Base) {
                BaseOrExtension.Base b = (BaseOrExtension.Base)decoded;
                pendingBase.put(id, b.base());
            } else if (decoded instanceof BaseOrExtension.Ext) {
                BaseOrExtension.Ext e = (BaseOrExtension.Ext)decoded;
                pendingExts.put(id, e.extension());
            }
        }, unionCodec, priority);
    }

    public static <T, E extends Extension<T>> Codec<BaseOrExtension<T, E>> createCodec(Codec<T> baseCodec, Codec<E> extCodec) {
        return Codec.either(extCodec, baseCodec).xmap(either -> (BaseOrExtension)either.map(BaseOrExtension.Ext::new, BaseOrExtension.Base::new), boe -> {
            if (boe instanceof BaseOrExtension.Ext) {
                BaseOrExtension.Ext e = (BaseOrExtension.Ext)boe;
                return Either.left(e.extension());
            }
            return Either.right(((BaseOrExtension.Base)boe).base());
        });
    }

    @FunctionalInterface
    public static interface SimpleDecoder<T> {
        public T decode(boolean var1, ResourceLocation var2, JsonElement var3, RegistryAccess var4) throws DecoderException;
    }

    @FunctionalInterface
    public static interface SingleDecodedFileHandler<T> {
        public void reloadFile(boolean var1, ResourceLocation var2, T var3, RegistryAccess var4);
    }

    @FunctionalInterface
    public static interface SingleFileHandler {
        public void reloadFile(boolean var1, ResourceLocation var2, String var3, RegistryAccess var4);
    }

    public record CodecOptimisedFileHandler<T>(Codec<T> codec, SingleDecodedFileHandler<T> handler, String path) implements SingleFileHandler
    {
        @Override
        public void reloadFile(boolean isClient, ResourceLocation path, String data, RegistryAccess registryAccess) {
            try {
                DataResult result = this.codec().decode((DynamicOps)RegistryOps.create((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)registryAccess), (Object)((JsonElement)Miapi.gson.fromJson(data, JsonElement.class)));
                this.handler().reloadFile(isClient, path, ((Pair)result.getOrThrow(s -> new DecoderException("Could not decode " + String.valueOf(path) + " " + s))).getFirst(), registryAccess);
            }
            catch (RuntimeException e) {
                Miapi.LOGGER.error("could not decode " + String.valueOf(path) + " for full-path " + String.valueOf(path) + e.getMessage());
                if (MiapiConfig.getServerConfig().other.verboseLogging) {
                    Miapi.LOGGER.error("", (Throwable)e);
                }
                Miapi.LOGGER.error("raw data :");
                Miapi.LOGGER.error(data);
            }
        }
    }

    public static sealed interface BaseOrExtension<T, E extends Extension<T>> {

        public record Ext<T, E extends Extension<T>>(E extension) implements BaseOrExtension<T, E>
        {
        }

        public record Base<T, E extends Extension<T>>(T base) implements BaseOrExtension<T, E>
        {
        }
    }

    public static interface Extension<T> {
        public ResourceLocation getTarget();

        public T applyTo(T var1);
    }
}

