/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.editor;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import dev.architectury.event.EventResult;
import dev.architectury.platform.Platform;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import org.jetbrains.annotations.Nullable;
import smartin.miapi.Miapi;
import smartin.miapi.datapack.ReloadEvents;
import smartin.miapi.editor.EditorEvents;
import smartin.miapi.editor.JsonEditor;
import smartin.miapi.editor.MiapiEditor;
import smartin.miapi.editor.syntax.EditorInterface;
import smartin.miapi.events.MiapiEvents;
import smartin.miapi.modules.cache.CacheCommands;
import smartin.miapi.modules.conditions.ConditionManager;
import smartin.miapi.modules.properties.util.EditorError;

public class LiveDataPackManager
implements AutoCloseable {
    private static final String RUNTIME_FOLDER = "miapi_runtime_datapacks";
    private static final String CONTEXT_FILE = "miapi-editor-context.json";
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static LiveDataPackManager INSTANCE;
    private final List<DataPackContext> loadedPacks = new ArrayList<DataPackContext>();
    private final File runtimeFolder;
    private WatchService watchService;
    private final Map<WatchKey, DataPackContext> watchKeys = new HashMap<WatchKey, DataPackContext>();
    public List<MiapiEditor> openedEditors = new ArrayList<MiapiEditor>();
    boolean isValidating = false;
    public static Supplier<Boolean> isEnabled;

    public static void setup() {
        MiapiEvents.PLAYER_TICK_END.register(player -> {
            if (Platform.getEnv() == Dist.CLIENT && Miapi.server != null && INSTANCE != null && INSTANCE.checkAndValidateDatapacks(false)) {
                CacheCommands.triggerServerReload();
            }
            return EventResult.pass();
        });
        MiapiEvents.ADJUST_RAW_DATA.register(event -> {
            if (Platform.getEnv() == Dist.CLIENT && Miapi.server != null && isEnabled.get().booleanValue()) {
                LiveDataPackManager.getInstance().processDataPacks(event);
            }
            return EventResult.pass();
        });
    }

    public static LiveDataPackManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new LiveDataPackManager();
        }
        return INSTANCE;
    }

    private LiveDataPackManager() {
        this.runtimeFolder = this.getRuntimeFolder();
        if (!this.runtimeFolder.exists()) {
            this.runtimeFolder.mkdirs();
        }
        this.setupFileWatcher();
        this.scanForDataPacks();
    }

    private File getRuntimeFolder() {
        return Platform.getGameFolder().resolve(RUNTIME_FOLDER).toFile();
    }

    private void setupFileWatcher() {
        try {
            this.watchService = this.runtimeFolder.toPath().getFileSystem().newWatchService();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void watchDataPack(DataPackContext context) {
        this.watchDataPack(context, new File(context.directory, context.dataPath));
    }

    public void watchDataPack(DataPackContext context, File dataDir) {
        if (!context.watchFiles) {
            return;
        }
        try {
            if (dataDir.exists() && dataDir.isDirectory()) {
                WatchKey key = dataDir.toPath().register(this.watchService, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_DELETE);
                this.watchKeys.put(key, context);
                if (dataDir.isDirectory()) {
                    Arrays.stream(dataDir.listFiles(File::isDirectory)).forEach(f -> this.watchDataPack(context, (File)f));
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void unwatchDataPack(DataPackContext context) {
        this.watchKeys.entrySet().removeIf(entry -> {
            if (entry.getValue() == context) {
                ((WatchKey)entry.getKey()).cancel();
                return true;
            }
            return false;
        });
    }

    private boolean checkFileChanges() {
        if (this.watchService == null) {
            return false;
        }
        boolean changeOccured = false;
        try {
            DataPackContext context;
            WatchKey key = this.watchService.poll();
            if (key != null && (context = this.watchKeys.get(key)) != null && context.watchFiles) {
                for (WatchEvent<?> event : key.pollEvents()) {
                    Path changed = (Path)event.context();
                    if (!changed.toString().endsWith(".json")) continue;
                    changeOccured = true;
                }
                key.reset();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return changeOccured;
    }

    public void scanForDataPacks() {
        this.loadedPacks.forEach(this::unwatchDataPack);
        this.watchKeys.clear();
        this.loadedPacks.clear();
        File[] directories = this.runtimeFolder.listFiles(File::isDirectory);
        if (directories != null) {
            for (File dir : directories) {
                DataPackContext context = this.loadOrCreateContext(dir);
                this.loadedPacks.add(context);
                this.watchDataPack(context);
            }
        }
    }

    public DataPackContext createNewPack(String name, String id, String author, String description, boolean enabled) {
        File newDir;
        id = id.toLowerCase();
        if (!(name.isEmpty() || id.isEmpty() || (newDir = new File(this.runtimeFolder, id)).exists())) {
            newDir.mkdirs();
            DataPackContext context = this.createDefaultContext(newDir);
            context.name = name;
            context.id = id;
            context.author = author;
            context.description = description;
            context.enabled = enabled;
            context.dataPath = "data";
            this.saveContext(context);
            this.loadedPacks.add(context);
            this.watchDataPack(context);
            return context;
        }
        return null;
    }

    public void deletePack(DataPackContext context) {
        try {
            this.unwatchDataPack(context);
            this.deleteDirectory(context.directory);
            this.loadedPacks.remove(context);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void deleteDirectory(File directory) throws IOException {
        File[] files = directory.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    this.deleteDirectory(file);
                    continue;
                }
                Files.delete(file.toPath());
            }
        }
        Files.delete(directory.toPath());
    }

    private DataPackContext loadOrCreateContext(File directory) {
        DataPackContext context;
        File contextFile = new File(directory, CONTEXT_FILE);
        if (contextFile.exists()) {
            try {
                String json = Files.readString(contextFile.toPath());
                context = (DataPackContext)GSON.fromJson(json, DataPackContext.class);
                context.directory = directory;
                context.repair();
            }
            catch (IOException e) {
                e.printStackTrace();
                context = this.createDefaultContext(directory);
            }
        } else {
            context = this.createDefaultContext(directory);
        }
        this.saveContext(context);
        return context;
    }

    private DataPackContext createDefaultContext(File directory) {
        DataPackContext context = new DataPackContext();
        context.name = directory.getName();
        context.id = directory.getName().toLowerCase();
        context.author = "Unknown";
        context.description = "A MIAPI runtime datapack";
        context.enabled = true;
        context.dataPath = "data";
        context.directory = directory;
        return context;
    }

    public void saveContext(DataPackContext context) {
        try {
            File contextFile = new File(context.directory, CONTEXT_FILE);
            String json = GSON.toJson((Object)context);
            Files.writeString(contextFile.toPath(), (CharSequence)json, new OpenOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void processDataPacks(MiapiEvents.ReloadEventData event) {
        for (DataPackContext context : this.loadedPacks) {
            File dataDir;
            if (context.enabled && !context.passedValidation) {
                Minecraft.getInstance().player.sendSystemMessage((Component)Component.literal((String)(context.name + " Could not load, it did not pass Validation")));
            }
            if (!context.enabled || !context.passedValidation || !(dataDir = new File(context.directory, context.dataPath)).exists() || !dataDir.isDirectory()) continue;
            try {
                Stream<Path> paths = Files.walk(dataDir.toPath(), new FileVisitOption[0]);
                try {
                    paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> path.toString().endsWith(".json")).forEach(path -> {
                        try {
                            ResourceLocation location = this.getResourceLocation(dataDir.toPath(), (Path)path);
                            String content = Files.readString(path);
                            if (this.shouldLoadJson(Files.readString(path))) {
                                event.data.put(location, content);
                            }
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    });
                }
                finally {
                    if (paths == null) continue;
                    paths.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private boolean shouldLoadJson(String content) {
        try {
            JsonObject element = (JsonObject)Miapi.gson.fromJson(content, JsonObject.class);
            if (!element.has("load_condition")) {
                return true;
            }
            boolean allowed = ConditionManager.get(element.get("load_condition")).isAllowed(new ConditionManager.ConditionContext(this){

                @Override
                public ConditionManager.ConditionContext copy() {
                    return this;
                }
            });
            if (allowed) {
                element.remove("load_condition");
                return true;
            }
            return false;
        }
        catch (Exception e) {
            return true;
        }
    }

    public boolean checkAndValidateDatapacks(boolean forced) {
        if (!(forced || this.isValidating || this.checkFileChanges() && !ReloadEvents.isInReload())) {
            return false;
        }
        this.isValidating = true;
        ArrayList<MiapiEditor> editors = new ArrayList<MiapiEditor>(this.openedEditors);
        editors.forEach(miapiEditor -> {
            if (miapiEditor instanceof Closeable) {
                Closeable closeable = (Closeable)((Object)miapiEditor);
                try {
                    closeable.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            MiapiEditor.editors.remove(miapiEditor);
        });
        for (DataPackContext context : this.loadedPacks) {
            File dataDir;
            if (!context.enabled) continue;
            context.passedValidation = true;
            if (forced) {
                context.validatedFiles.clear();
            }
            if (!(dataDir = new File(context.directory, context.dataPath)).exists() || !dataDir.isDirectory()) {
                dataDir.mkdirs();
                continue;
            }
            try {
                Stream<Path> paths = Files.walk(dataDir.toPath(), new FileVisitOption[0]);
                try {
                    paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> path.toString().endsWith(".json")).forEach(path -> {
                        File file = path.toFile();
                        String relativePath = dataDir.toPath().relativize((Path)path).toString();
                        ValidationCache cache = context.getValidationCache(relativePath, file, forced);
                        if (cache.shouldLoad() && cache.blockLoad()) {
                            try {
                                String pathWithoutExt = relativePath.replace(".json", "").replace("\\", "/");
                                pathWithoutExt = pathWithoutExt.replaceFirst("/", ":");
                                ResourceLocation resourceLocation = Miapi.id(pathWithoutExt);
                                String data = Files.readString(file.toPath());
                                if (this.shouldLoadJson(data)) {
                                    JsonEditor editor = new JsonEditor(Files.readString(file.toPath()), f -> {}, (Path)path, resourceLocation);
                                    editor.resourceLocation = resourceLocation;
                                    editor.closeOnNoError = true;
                                    MiapiEditor.editors.add(editor);
                                    this.openedEditors.add(editor);
                                }
                            }
                            catch (RuntimeException e) {
                                Miapi.LOGGER.warn("", (Throwable)e);
                            }
                            catch (IOException e) {
                                Miapi.LOGGER.warn("", (Throwable)e);
                            }
                            context.passedValidation = false;
                        }
                    });
                }
                finally {
                    if (paths == null) continue;
                    paths.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                this.isValidating = false;
                return false;
            }
        }
        for (DataPackContext context : this.loadedPacks) {
            if (context.passedValidation) continue;
            this.isValidating = false;
            return false;
        }
        this.isValidating = false;
        return true;
    }

    private ResourceLocation getResourceLocation(Path dataDir, Path filePath) {
        Path relativePath = dataDir.relativize(filePath);
        if (relativePath.getNameCount() < 2) {
            return null;
        }
        String namespace = relativePath.getName(0).toString().toLowerCase();
        String path = relativePath.subpath(1, relativePath.getNameCount()).toString().replace('\\', '/').toLowerCase();
        return ResourceLocation.tryBuild((String)namespace, (String)path);
    }

    public List<DataPackContext> getLoadedPacks() {
        return new ArrayList<DataPackContext>(this.loadedPacks);
    }

    @Override
    public void close() {
        if (this.watchService != null) {
            try {
                this.watchService.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    static {
        isEnabled = () -> false;
    }

    public static class DataPackContext {
        public String name;
        public String id;
        public String author;
        public String description;
        public boolean enabled;
        public String dataPath;
        public boolean watchFiles = true;
        public transient File directory;
        public transient boolean passedValidation = true;
        public transient Map<String, ValidationCache> validatedFiles = new HashMap<String, ValidationCache>();

        public void repair() {
            if (this.dataPath == null) {
                this.dataPath = "data";
            }
            if (this.validatedFiles == null) {
                this.validatedFiles = new HashMap<String, ValidationCache>();
            }
        }

        public void createDatapack(ZipOutputStream zos, File dataPath) {
            try {
                if (dataPath == null || !dataPath.exists() || !dataPath.isDirectory()) {
                    throw new IllegalArgumentException("Data path must exist and be a directory: " + String.valueOf(dataPath));
                }
                Path basePath = dataPath.toPath();
                Files.walk(basePath, new FileVisitOption[0]).forEach(path -> {
                    try {
                        String relativePath = basePath.relativize((Path)path).toString().replace("\\", "/");
                        if (Files.isDirectory(path, new LinkOption[0])) {
                            if (!relativePath.isEmpty()) {
                                String dirPath = "data/" + relativePath + "/";
                                zos.putNextEntry(new ZipEntry(dirPath));
                                zos.closeEntry();
                            }
                            return;
                        }
                        String zipPath = "data/" + relativePath;
                        ZipEntry entry = new ZipEntry(zipPath);
                        zos.putNextEntry(entry);
                        try (InputStream is = Files.newInputStream(path, new OpenOption[0]);){
                            int len;
                            byte[] buffer = new byte[4096];
                            while ((len = is.read(buffer)) > 0) {
                                zos.write(buffer, 0, len);
                            }
                        }
                        zos.closeEntry();
                    }
                    catch (IOException e) {
                        Miapi.LOGGER.warn("Could not write data ", (Throwable)e);
                    }
                });
            }
            catch (IOException e) {
                Miapi.LOGGER.warn("Could not write data ", (Throwable)e);
            }
        }

        @Nullable
        public ValidationCache getValidationCache(String relativePath, File file, boolean forced) {
            boolean isValid;
            ValidationCache cache;
            block11: {
                cache = this.validatedFiles.get(relativePath);
                if (cache == null || cache.lastModified != file.lastModified() || !cache.blockLoad() && forced) {
                    try {
                        String pathWithoutExt = relativePath.replace(".json", "").replace("\\", "/");
                        pathWithoutExt = pathWithoutExt.replaceFirst("/", ":");
                        ResourceLocation resourceLocation = Miapi.id(pathWithoutExt);
                        ArrayList<EditorInterface> interfaces = new ArrayList<EditorInterface>();
                        ((EditorEvents.EditorInterfaceEvent)EditorEvents.EDITOR_INTERFACES.invoker()).onGetInterfaces(new EditorEvents.EditorInterfaceData(resourceLocation, file.getPath(), interfaces));
                        String content = Files.readString(file.toPath());
                        JsonElement json = JsonParser.parseString((String)content);
                        boolean shouldLoad = true;
                        if (json.isJsonObject() && json.getAsJsonObject().has("load_condition")) {
                            shouldLoad = ConditionManager.get(json.getAsJsonObject().get("load_condition")).isAllowed(new ConditionManager.ConditionContext(this){

                                @Override
                                public ConditionManager.ConditionContext copy() {
                                    return this;
                                }
                            });
                        }
                        if (shouldLoad) {
                            long lastModified;
                            boolean isValid2 = true;
                            ArrayList<EditorError> allErrors = new ArrayList<EditorError>();
                            for (EditorInterface iface : interfaces) {
                                List<EditorError> errors = iface.validateContent(json, content);
                                allErrors.addAll(errors);
                                if (errors.stream().anyMatch(error -> error.severity() == EditorError.ErrorSeverity.ERROR)) {
                                    isValid2 = false;
                                    break;
                                }
                                if (!errors.stream().anyMatch(error -> error.severity() == EditorError.ErrorSeverity.WARNING)) continue;
                            }
                            if ((cache = new ValidationCache(lastModified = Files.getLastModifiedTime(file.toPath(), new LinkOption[0]).toMillis(), shouldLoad, !shouldLoad || !isValid2, allErrors)).blockLoad()) {
                                Miapi.LOGGER.warn("could not validate file " + String.valueOf(file.toPath()));
                            }
                            this.validatedFiles.put(relativePath, cache);
                            break block11;
                        }
                        long lastModified = Files.getLastModifiedTime(file.toPath(), new LinkOption[0]).toMillis();
                        cache = new ValidationCache(lastModified, shouldLoad, false, List.of());
                        this.validatedFiles.put(relativePath, cache);
                    }
                    catch (Exception e) {
                        long lastModified = 0L;
                        try {
                            lastModified = Files.getLastModifiedTime(file.toPath(), new LinkOption[0]).toMillis();
                        }
                        catch (IOException ex) {
                            Miapi.LOGGER.warn("", (Throwable)ex);
                        }
                        cache = new ValidationCache(lastModified, false, false, List.of(new EditorError(0, "Critical load issue," + e.getMessage(), EditorError.ErrorSeverity.ERROR)));
                        this.validatedFiles.put(relativePath, cache);
                    }
                }
            }
            boolean bl = isValid = cache != null && cache.shouldLoad();
            if (!isValid) {
                Miapi.LOGGER.warn("fail");
            }
            return cache;
        }

        public boolean isFileValid(String relativePath, File file) {
            boolean isValid;
            ValidationCache cache = this.getValidationCache(relativePath, file, false);
            boolean bl = isValid = cache != null && cache.shouldLoad();
            if (!isValid) {
                Miapi.LOGGER.warn("fail");
            }
            return isValid;
        }

        private boolean validateFile(String relativePath, File file) {
            try {
                String content = Files.readString(file.toPath());
                JsonParser.parseString((String)content);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
    }

    private record ValidationCache(long lastModified, boolean shouldLoad, boolean blockLoad, List<EditorError> errors) {
    }
}

