/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.editor;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.datafixers.util.Pair;
import imgui.ImGui;
import imgui.type.ImBoolean;
import imgui.type.ImString;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import smartin.miapi.Miapi;
import smartin.miapi.editor.MiapiEditor;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.registries.RegistryInventory;

public class ModuleEditor
implements MiapiEditor {
    private final ImBoolean show = new ImBoolean(true);
    private final ImString itemModuleName = new ImString(128);
    private final ModuleInstance module;
    Consumer<ModuleInstance> onChange;
    public Map<String, ModuleEditor> subModuleEditors = new LinkedHashMap<String, ModuleEditor>();
    public List<Pair<ImString, ImString>> moduleData = new ArrayList<Pair<ImString, ImString>>();

    public ModuleEditor(ModuleInstance module, Consumer<ModuleInstance> onChange) {
        this.module = module;
        this.onChange = onChange;
        this.itemModuleName.set((Object)module.moduleID);
        module.getSubModuleMap().forEach((id, m) -> this.subModuleEditors.put((String)id, new ModuleEditor((ModuleInstance)m, change -> {
            module.setSubModule((String)id, (ModuleInstance)change);
            onChange.accept(module);
        })));
        module.moduleData.forEach((id, data) -> {
            ImString imString = new ImString(128);
            imString.set(id.toString());
            this.moduleData.add((Pair<ImString, ImString>)new Pair((Object)ModuleEditor.of(id.toString()), (Object)ModuleEditor.of(data.toString())));
        });
    }

    private void renderModuleInstance() {
        ImGui.separator();
        if (ImGui.inputText((String)"Item Module", (ImString)this.itemModuleName, (int)0)) {
            ResourceLocation id2 = Miapi.id(this.itemModuleName.get());
            ItemModule module1 = RegistryInventory.ITEM_MODULE_MIAPI_REGISTRY.get(Miapi.id(this.itemModuleName.get()));
            if (module1 != null) {
                this.module.setModule(module1);
                this.module.moduleID = id2;
            } else {
                ImGui.text((String)"invalid ID");
            }
        }
        ImGui.separator();
        if (ImGui.collapsingHeader((String)"Submodules", (int)32)) {
            this.subModuleEditors.forEach((id, editor) -> {
                if (ImGui.treeNode((String)id)) {
                    editor.renderModuleInstance();
                    ImGui.treePop();
                }
            });
        }
        ImGui.separator();
        if (ImGui.collapsingHeader((String)"Module Data", (int)32)) {
            this.moduleData.forEach(pair -> {
                JsonElement element;
                ImGui.pushID((String)((ImString)pair.getFirst()).toString());
                ImString id = (ImString)pair.getFirst();
                ImString data = (ImString)pair.getSecond();
                String old = id.get();
                if (ImGui.inputText((String)"Key", (ImString)id, (int)0)) {
                    try {
                        element = JsonParser.parseString((String)data.get());
                        this.module.moduleData.remove(Miapi.id(old));
                        this.module.moduleData.put(Miapi.id(id.get()), element);
                    }
                    catch (RuntimeException e) {
                        ImGui.text((String)"invalid data!");
                    }
                }
                if (ImGui.inputText((String)"value", (ImString)data, (int)0)) {
                    try {
                        element = JsonParser.parseString((String)data.get());
                        this.module.moduleData.put(Miapi.id(id.get()), element);
                    }
                    catch (RuntimeException e) {
                        ImGui.text((String)"invalid data!");
                    }
                }
                if (ImGui.button((String)"Remove")) {
                    this.moduleData.remove(pair);
                    this.module.moduleData.remove(Miapi.id(id.get()));
                }
                ImGui.popID();
            });
            if (ImGui.button((String)"Add Entry")) {
                this.module.moduleData.put(ResourceLocation.parse((String)"miapi:new_data"), JsonParser.parseString((String)"{}"));
                this.moduleData.add((Pair<ImString, ImString>)new Pair((Object)ModuleEditor.of("miapi:new_data"), (Object)ModuleEditor.of("{}")));
            }
        }
    }

    public static ImString of(String string) {
        ImString imString = new ImString(1024);
        imString.set(string);
        return imString;
    }

    @Override
    public void render(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        if (!this.show.get()) {
            MiapiEditor.editors.remove(this);
            return;
        }
        ImGui.setNextWindowSize((float)400.0f, (float)300.0f, (int)4);
        if (ImGui.begin((String)("Module Editor##" + System.identityHashCode(this)), (ImBoolean)this.show)) {
            this.renderModuleInstance();
        }
        if (ImGui.button((String)"Save")) {
            this.onChange.accept(this.module);
        }
        ImGui.end();
    }
}

