/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.editor.material;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import imgui.ImGui;
import imgui.type.ImString;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import smartin.miapi.modules.properties.util.ModuleProperty;
import smartin.miapi.registries.RegistryInventory;

public class PropertyEditor {
    private final List<PropertyEntry> propertyData = new ArrayList<PropertyEntry>();
    private final String title;
    private final Map<ModuleProperty<?>, Object> propertyMap;
    private boolean showPropertyDropdown = false;
    private final ImString searchText = new ImString(128);

    public PropertyEditor(String title, Map<ModuleProperty<?>, Object> propertyMap) {
        this.title = title;
        this.propertyMap = propertyMap;
        this.initializeProperties();
    }

    private void initializeProperties() {
        this.propertyMap.forEach((prop, value) -> this.propertyData.add(new PropertyEntry((ModuleProperty<?>)prop, value)));
    }

    public void render() {
        if (ImGui.collapsingHeader((String)this.title, (int)32)) {
            new ArrayList<PropertyEntry>(this.propertyData).forEach(entry -> {
                ImGui.pushID((String)entry.toString());
                ImGui.text((String)RegistryInventory.MODULE_PROPERTY_MIAPI_REGISTRY.findKey(entry.property).toString());
                if (ImGui.inputText((String)"Value", (ImString)entry.value, (int)0)) {
                    try {
                        JsonElement element = JsonParser.parseString((String)entry.value.get());
                        this.propertyMap.put(entry.property, element);
                    }
                    catch (RuntimeException e) {
                        ImGui.text((String)"Invalid data!");
                    }
                }
                if (ImGui.button((String)"Remove")) {
                    this.propertyData.remove(entry);
                    this.propertyMap.remove(entry.property);
                }
                ImGui.popID();
            });
            if (ImGui.button((String)"Add Property")) {
                this.showPropertyDropdown = true;
                this.searchText.set("");
            }
            if (this.showPropertyDropdown) {
                ImGui.openPopup((String)"Property Selection");
                if (ImGui.beginPopupModal((String)"Property Selection")) {
                    if (ImGui.inputText((String)"Search", (ImString)this.searchText, (int)0)) {
                        // empty if block
                    }
                    ImGui.beginChild((String)"Property List", (float)200.0f, (float)200.0f);
                    RegistryInventory.MODULE_PROPERTY_MIAPI_REGISTRY.getFlatMap().forEach((id, property) -> {
                        if ((this.searchText.get().isEmpty() || id.toString().toLowerCase().contains(this.searchText.get().toLowerCase())) && ImGui.selectable((String)id.toString())) {
                            this.propertyData.add(new PropertyEntry((ModuleProperty<?>)property, "{}"));
                            this.propertyMap.put((ModuleProperty<?>)property, JsonParser.parseString((String)"{}"));
                            this.showPropertyDropdown = false;
                        }
                    });
                    ImGui.endChild();
                    if (ImGui.button((String)"Cancel")) {
                        this.showPropertyDropdown = false;
                    }
                    ImGui.endPopup();
                }
            }
        }
    }

    private static class PropertyEntry {
        final ModuleProperty<?> property;
        final ImString value;

        PropertyEntry(ModuleProperty<?> property, Object value) {
            this.property = property;
            this.value = new ImString(1024);
            this.value.set(value.toString());
        }
    }
}

