/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.editor.renderers;

import com.redpxnda.nucleus.pose.client.HumanoidPoseAnimation;
import imgui.ImGui;
import java.util.function.Consumer;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import smartin.miapi.editor.renderers.Vector3fEditor;

public class FrameMultiplierEditor {
    private final HumanoidPoseAnimation.FrameMultiplier multiplier;
    private final Consumer<HumanoidPoseAnimation.FrameMultiplier> onChange;
    private final Vector3fEditor positionEditor;
    private final Vector3fEditor rotationEditor;
    private final Vector3fEditor scaleEditor;

    public FrameMultiplierEditor(HumanoidPoseAnimation.FrameMultiplier multiplier, Consumer<HumanoidPoseAnimation.FrameMultiplier> onChange) {
        this.multiplier = multiplier;
        this.onChange = onChange;
        this.positionEditor = new Vector3fEditor("Position", 0.03125f, multiplier.position, v -> this.triggerChange());
        this.rotationEditor = new Vector3fEditor("Rotation", 1.0f, multiplier.rotation, v -> this.triggerChange());
        this.scaleEditor = new Vector3fEditor("Scale", 0.01f, multiplier.scale, v -> this.triggerChange());
    }

    public void render() {
        ImGui.text((String)"FrameMultiplier");
        this.positionEditor.render();
        this.rotationEditor.render();
        this.scaleEditor.render();
    }

    private void triggerChange() {
        this.onChange.accept(new HumanoidPoseAnimation.FrameMultiplier(new Vector3f((Vector3fc)this.multiplier.position), new Vector3f((Vector3fc)this.multiplier.rotation), new Vector3f((Vector3fc)this.multiplier.scale)));
    }

    public HumanoidPoseAnimation.FrameMultiplier getMultiplier() {
        return this.multiplier;
    }
}

