/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.editor.syntax;

import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;
import smartin.miapi.Miapi;
import smartin.miapi.editor.syntax.EditorInterface;
import smartin.miapi.modules.properties.util.EditorError;
import smartin.miapi.modules.properties.util.Validator;

public class CodecValidatorInterface
implements EditorInterface {
    private final Codec<?> codec;
    private final ResourceLocation id;
    private final String name;

    public CodecValidatorInterface(Codec<?> codec, String name) {
        this.codec = codec;
        this.name = name;
        this.id = Miapi.id("codec_validator", name.toLowerCase().replace(" ", "_"));
    }

    @Override
    public List<EditorError> validateContent(@Nullable JsonElement json, String rawContent) {
        ArrayList<EditorError> errors = new ArrayList<EditorError>();
        if (json == null) {
            errors.add(new EditorError(1, "Invalid JSON", EditorError.ErrorSeverity.ERROR));
            return errors;
        }
        try {
            DataResult result = this.codec.decode((DynamicOps)NbtOps.INSTANCE, (Object)((Tag)JsonOps.INSTANCE.convertTo((DynamicOps)NbtOps.INSTANCE, (JsonElement)Miapi.gson.fromJson(rawContent, JsonElement.class))));
            result.result().ifPresentOrElse(value -> {
                if (value instanceof Pair) {
                    Pair pair = (Pair)value;
                    errors.addAll(this.getErrorsFromValidator(pair.getFirst()));
                }
            }, () -> errors.add(new EditorError(1, "Failed to decode " + this.name + ": " + ((DataResult.Error)result.error().get()).message(), EditorError.ErrorSeverity.ERROR)));
        }
        catch (Exception e) {
            errors.add(new EditorError(1, "Failed to validate " + this.name + ": " + e.getMessage(), EditorError.ErrorSeverity.ERROR));
        }
        return errors;
    }

    public <T> List<EditorError> getErrorsFromValidator(T data) {
        try {
            return ((Validator)data).validate(1, data, true);
        }
        catch (ClassCastException classCastException) {
            return List.of();
        }
    }

    @Override
    public Map<EditorInterface.TextRange, Integer> getSyntaxHighlighting(String content) {
        return new HashMap<EditorInterface.TextRange, Integer>();
    }

    @Override
    public ResourceLocation getId() {
        return this.id;
    }
}

