/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.editor.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import imgui.ImGui;
import imgui.type.ImString;

public class JsonEditor {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final ImString content;
    private final String title;
    private final JsonElement initialValue;

    public JsonEditor(String title, JsonElement initialValue) {
        this.title = title;
        this.initialValue = initialValue;
        this.content = new ImString(4096);
        this.content.set(GSON.toJson(initialValue));
    }

    public void render() {
        if (ImGui.collapsingHeader((String)(this.title + "##" + System.identityHashCode(this)))) {
            if (ImGui.inputTextMultiline((String)("##" + this.title), (ImString)this.content, (int)0)) {
                try {
                    JsonParser.parseString((String)this.content.get());
                }
                catch (Exception e) {
                    ImGui.text((String)"Invalid JSON!");
                }
            }
            if (ImGui.button((String)"Format")) {
                try {
                    JsonElement element = JsonParser.parseString((String)this.content.get());
                    this.content.set(GSON.toJson(element));
                }
                catch (Exception e) {
                    ImGui.text((String)"Invalid JSON!");
                }
            }
        }
    }

    public JsonElement getValue() {
        try {
            return JsonParser.parseString((String)this.content.get());
        }
        catch (Exception e) {
            return this.initialValue;
        }
    }
}

