/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import smartin.miapi.entity.ItemProjectileEntity;

public class ItemProjectileRenderer
extends EntityRenderer<ItemProjectileEntity> {
    public ItemProjectileRenderer(EntityRendererProvider.Context ctx) {
        super(ctx);
    }

    public ResourceLocation getTextureLocation(ItemProjectileEntity entity) {
        return null;
    }

    public void render(ItemProjectileEntity entity, float yaw, float tickDelta, PoseStack matrixStack, MultiBufferSource vertexConsumers, int light) {
        ItemStack itemStack = entity.getPickupItem();
        if (itemStack != null && !itemStack.isEmpty()) {
            matrixStack.pushPose();
            matrixStack.last().pose().scale(2.0f);
            matrixStack.mulPose(Axis.YP.rotationDegrees(Mth.lerp((float)tickDelta, (float)entity.yRotO, (float)entity.getYRot()) - 90.0f));
            matrixStack.mulPose(Axis.ZP.rotationDegrees(Mth.lerp((float)tickDelta, (float)entity.xRotO, (float)entity.getXRot()) + 90.0f));
            matrixStack.last().pose().rotateXYZ(0.0f, 0.0f, 3.926991f);
            if (Minecraft.getInstance().player != null) {
                Minecraft.getInstance().getItemRenderer().renderStatic(itemStack, ItemDisplayContext.GROUND, light, OverlayTexture.NO_OVERLAY, matrixStack, vertexConsumers, Minecraft.getInstance().player.level(), 1);
            }
            matrixStack.popPose();
        }
    }
}

