/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.entity;

import com.redpxnda.nucleus.facet.FacetKey;
import com.redpxnda.nucleus.facet.FacetRegistry;
import com.redpxnda.nucleus.facet.entity.EntityFacet;
import com.redpxnda.nucleus.facet.network.clientbound.FacetSyncPacket;
import com.redpxnda.nucleus.network.PlayerSendable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import smartin.miapi.Miapi;
import smartin.miapi.attributes.AttributeRegistry;
import smartin.miapi.config.MiapiConfig;
import smartin.miapi.mixin.LivingEntityAccessor;
import smartin.miapi.registries.RegistryInventory;

public class StunHealthFacet
implements EntityFacet<CompoundTag> {
    private final LivingEntity livingEntity;
    private float currentAmount = 20.0f;
    public static final ResourceLocation facetIdentifier = Miapi.id("stun_current_health");
    public static FacetKey<StunHealthFacet> KEY = FacetRegistry.register((ResourceLocation)facetIdentifier, StunHealthFacet.class);

    public StunHealthFacet(LivingEntity entity) {
        this.livingEntity = entity;
    }

    public void takeStunDamage(float stunDamage, LivingEntity attacker) {
        this.currentAmount -= stunDamage;
        if (this.currentAmount <= 0.0f) {
            if (!this.livingEntity.hasEffect(RegistryInventory.stunResistanceEffect)) {
                this.livingEntity.addEffect(new MobEffectInstance(RegistryInventory.stunEffect, MiapiConfig.getServerConfig().stunEffectCategory.stunLength, 0, false, true), (Entity)attacker);
            }
            this.currentAmount = this.getMaxAmount();
        }
    }

    public float getCurrentStunHealth() {
        return this.currentAmount;
    }

    public void tick() {
        if (this.livingEntity.tickCount % 5 == 4) {
            this.currentAmount = Math.min(this.getCurrentStunHealth() + 2.0f, this.getMaxAmount());
            LivingEntity livingEntity = this.livingEntity;
            if (livingEntity instanceof ServerPlayer) {
                ServerPlayer serverPlayerEntity = (ServerPlayer)livingEntity;
                if (serverPlayerEntity.connection != null) {
                    this.sendToClient(serverPlayerEntity);
                }
            }
        }
    }

    public int ticksSinceLastAttack() {
        int lastAttackedTime = ((LivingEntityAccessor)this.livingEntity).getLastAttackedTime();
        if (lastAttackedTime > this.livingEntity.tickCount) {
            return this.livingEntity.tickCount;
        }
        return this.livingEntity.tickCount - lastAttackedTime;
    }

    public float getMaxAmount() {
        return (float)this.livingEntity.getAttributeValue(AttributeRegistry.STUN_MAX_HEALTH);
    }

    public CompoundTag toNbt() {
        CompoundTag compound = new CompoundTag();
        compound.putFloat("miapi:stun_current_health", this.getCurrentStunHealth());
        return compound;
    }

    public void sendToClient(Entity capHolder, ServerPlayer player) {
        if (player != null && player.connection != null && player.level() != null) {
            try {
                this.createPacket(capHolder).send(player);
            }
            catch (RuntimeException e) {
                Miapi.LOGGER.error("facet sync issue", (Throwable)e);
            }
        }
    }

    public void loadNbt(CompoundTag nbt) {
        this.currentAmount = nbt.getFloat("miapi:stun_current_health");
    }

    public PlayerSendable createPacket(Entity target) {
        return new FacetSyncPacket(target, KEY, (EntityFacet)this);
    }
}

