/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.events;

import com.google.common.collect.Multimap;
import com.redpxnda.nucleus.event.PrioritizedEvent;
import dev.architectury.event.EventResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableFloat;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jetbrains.annotations.Nullable;
import smartin.miapi.blocks.ModularWorkBenchEntity;
import smartin.miapi.client.gui.crafting.CraftingScreenHandler;
import smartin.miapi.craft.CraftAction;
import smartin.miapi.craft.stat.StatProvidersMap;
import smartin.miapi.entity.ItemProjectileEntity;
import smartin.miapi.entity.ProjectileWithBow;
import smartin.miapi.material.base.Material;
import smartin.miapi.material.generated.GeneratedMaterial;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.modules.properties.util.ComponentApplyProperty;

public class MiapiEvents {
    public static final PrioritizedEvent<LivingHurt> LIVING_HURT = PrioritizedEvent.createEventResult((Object[])new LivingHurt[0]);
    public static final PrioritizedEvent<LivingHurt> LIVING_HURT_AFTER = PrioritizedEvent.createEventResult((Object[])new LivingHurt[0]);
    public static final PrioritizedEvent<LivingHurt> LIVING_HURT_AFTER_ARMOR = PrioritizedEvent.createEventResult((Object[])new LivingHurt[0]);
    public static final PrioritizedEvent<LivingEntityXpAdjust> ADJUST_DROP_XP = PrioritizedEvent.createEventResult((Object[])new LivingEntityXpAdjust[0]);
    public static final PrioritizedEvent<EntityRide> START_RIDING = PrioritizedEvent.createLoop((Object[])new EntityRide[0]);
    public static final PrioritizedEvent<EntityRide> STOP_RIDING = PrioritizedEvent.createLoop((Object[])new EntityRide[0]);
    public static final PrioritizedEvent<StatUpdateEvent> STAT_UPDATE_EVENT = PrioritizedEvent.createEventResult((Object[])new StatUpdateEvent[0]);
    public static final PrioritizedEvent<ItemConvertEvent> CONVERT_ITEM = PrioritizedEvent.createEventResult((Object[])new ItemConvertEvent[0]);
    public static final PrioritizedEvent<CreateMaterialModularConvertersEvent> GENERATE_MATERIAL_CONVERTERS = PrioritizedEvent.createEventResult((Object[])new CreateMaterialModularConvertersEvent[0]);
    public static final PrioritizedEvent<PlayerTickEvent> PLAYER_TICK_START = PrioritizedEvent.createLoop((Object[])new PlayerTickEvent[0]);
    public static final PrioritizedEvent<PlayerTickEvent> PLAYER_TICK_END = PrioritizedEvent.createLoop((Object[])new PlayerTickEvent[0]);
    public static final PrioritizedEvent<LivingEntityTickEvent> LIVING_ENTITY_TICK_END = PrioritizedEvent.createLoop((Object[])new LivingEntityTickEvent[0]);
    public static final PrioritizedEvent<MaterialCraftEvent> MATERIAL_CRAFT_EVENT = PrioritizedEvent.createLoop((Object[])new MaterialCraftEvent[0]);
    public static final PrioritizedEvent<SmithingEvent> SMITHING_EVENT = PrioritizedEvent.createLoop((Object[])new SmithingEvent[0]);
    public static final PrioritizedEvent<LivingEntityAttributeBuild> LIVING_ENTITY_ATTRIBUTE_BUILD_EVENT = PrioritizedEvent.createLoop((Object[])new LivingEntityAttributeBuild[0]);
    public static final PrioritizedEvent<PlayerEquip> PLAYER_EQUIP_EVENT = PrioritizedEvent.createLoop((Object[])new PlayerEquip[0]);
    public static final PrioritizedEvent<DefaultLootFunctions> DEFAULT_LOOT_FUNCTIONS = PrioritizedEvent.createEventResult((Object[])new DefaultLootFunctions[0]);
    public static final PrioritizedEvent<DurabilityEvent> MODULAR_ITEM_DAMAGE = PrioritizedEvent.createLoop((Object[])new DurabilityEvent[0]);
    public static final PrioritizedEvent<InventoryTickEvent> INVENTORY_TICK = PrioritizedEvent.createEventResult((Object[])new InventoryTickEvent[0]);
    public static final PrioritizedEvent<CooldownAttackingWeaponGatherEvent> GET_ITEM_SHIELD_COOLDOWN = PrioritizedEvent.createLoop((Object[])new CooldownAttackingWeaponGatherEvent[0]);
    public static final PrioritizedEvent<ReloadEvent> ADJUST_RAW_DATA = PrioritizedEvent.createLoop((Object[])new ReloadEvent[0]);
    public static final PrioritizedEvent<EmptyEvent> POST_HOT_RELOAD = PrioritizedEvent.createLoop((Object[])new EmptyEvent[0]);
    public static final PrioritizedEvent<EmptyEvent> CLEAR_CACHE = PrioritizedEvent.createLoop((Object[])new EmptyEvent[0]);

    static {
        SMITHING_EVENT.register(listener -> {
            ComponentApplyProperty.updateItemStack(listener.itemStack, listener.registryAccess);
            return EventResult.pass();
        });
    }

    public static class MaterialCraft {
        public RegistryAccess registryAccess;
        public ItemStack itemStack;

        public MaterialCraft(ItemStack itemStack) {
            this.itemStack = itemStack;
        }
    }

    public static interface LivingHurt {
        public EventResult hurt(LivingHurtEvent var1);
    }

    public static interface LivingEntityXpAdjust {
        public EventResult death(LivingEntity var1, MutableFloat var2);
    }

    public static interface EntityRide {
        public void ride(Entity var1, Entity var2);
    }

    public static interface StatUpdateEvent {
        public EventResult update(ModularWorkBenchEntity var1, StatProvidersMap var2, int var3, Inventory var4, Player var5, CraftingScreenHandler var6);
    }

    public static interface ItemConvertEvent {
        public EventResult convert(ItemStack var1, Mutable<ItemStack> var2);
    }

    public static interface CreateMaterialModularConvertersEvent {
        public EventResult generated(Material var1, List<TieredItem> var2, List<ArmorItem> var3, boolean var4);
    }

    public static interface PlayerTickEvent {
        public EventResult tick(Player var1);
    }

    public static interface LivingEntityTickEvent {
        public EventResult tick(LivingEntity var1);
    }

    public static interface MaterialCraftEvent {
        public EventResult craft(MaterialCraftEventData var1);
    }

    public static interface SmithingEvent {
        public EventResult craft(MaterialCraft var1);
    }

    public static interface LivingEntityAttributeBuild {
        public EventResult build(AttributeSupplier.Builder var1);
    }

    public static interface PlayerEquip {
        public EventResult equip(Player var1, Map<EquipmentSlot, ItemStack> var2);
    }

    public static interface DefaultLootFunctions {
        public EventResult adjust(List<LootItemFunction> var1);
    }

    public static interface DurabilityEvent {
        public void durability(int var1, ItemStack var2, ServerLevel var3);
    }

    public static interface InventoryTickEvent {
        public void tick(ItemStack var1, Level var2, Entity var3, int var4, boolean var5);
    }

    public static interface CooldownAttackingWeaponGatherEvent {
        public void durability(MutableInt var1, ItemStack var2, ItemStack var3, LivingEntity var4, Entity var5);
    }

    public static interface ReloadEvent {
        public EventResult onReload(ReloadEventData var1);
    }

    public static interface EmptyEvent {
        public EventResult onReload();
    }

    public static interface ItemCraftingStatUpdate {
        public EventResult call(ModularWorkBenchEntity var1, Iterable<ItemStack> var2, @Nullable Player var3);
    }

    public static interface BlockCraftingStatUpdate {
        public EventResult call(ModularWorkBenchEntity var1, @Nullable Player var2);
    }

    public static interface BlockBreakEvent {
        public void breakBlock(ServerLevel var1, BlockPos var2, ItemStack var3, IntProvider var4);
    }

    public static interface GeneratedMaterialEvent {
        public EventResult generated(GeneratedMaterial var1, ItemStack var2, List<Item> var3, boolean var4);
    }

    public static class MaterialCraftEventData {
        public ItemStack crafted;
        public final ItemStack materialStack;
        public Material material;
        public ModuleInstance moduleInstance;
        CraftAction action;

        public MaterialCraftEventData(ItemStack crafted, ItemStack materialStack, Material material, ModuleInstance moduleInstance, CraftAction action) {
            this.crafted = crafted;
            this.material = material;
            this.materialStack = materialStack;
            this.moduleInstance = moduleInstance;
            this.action = action;
        }
    }

    public static interface LivingAttackEvent {
        public EventResult attack(@Nullable LivingEntity var1, @Nullable LivingEntity var2);
    }

    public static interface ItemStackAttributeEvent {
        public EventResult adjust(ItemStackAttributeEventHolder var1);
    }

    public static class ItemStackAttributeEventHolder {
        public ItemStack itemStack;
        public EquipmentSlot equipmentSlot;
        public Multimap<Attribute, AttributeModifier> attributeModifiers;

        public ItemStackAttributeEventHolder(ItemStack itemStack, EquipmentSlot equipmentSlot, Multimap<Attribute, AttributeModifier> attributeModifiers) {
            this.itemStack = itemStack;
            this.equipmentSlot = equipmentSlot;
            this.attributeModifiers = attributeModifiers;
        }
    }

    public static class LivingHurtEvent {
        public final LivingEntity defender;
        @Nullable
        public final Entity attacker;
        public DamageSource damageSource;
        public float amount;
        public boolean isCritical = false;

        public LivingHurtEvent(LivingEntity defender, Entity attacker, DamageSource damageSource, float amount) {
            this.defender = defender;
            this.attacker = attacker;
            this.damageSource = damageSource;
            this.amount = amount;
        }

        public static ItemStack getMainCausingStack(DamageSource damageSource) {
            Entity entity = damageSource.getDirectEntity();
            if (entity instanceof Projectile) {
                Projectile projectile = (Projectile)entity;
                ItemStack bow = ((ProjectileWithBow)projectile).getBowItem();
                if (bow != null && !bow.isEmpty()) {
                    return bow;
                }
                if (projectile instanceof ItemProjectileEntity) {
                    ItemProjectileEntity itemProjectile = (ItemProjectileEntity)projectile;
                    return itemProjectile.getPickupItem();
                }
            } else {
                entity = damageSource.getEntity();
                if (entity instanceof LivingEntity) {
                    LivingEntity attacker = (LivingEntity)entity;
                    return attacker.getMainHandItem();
                }
            }
            return ItemStack.EMPTY;
        }

        public static ItemStack getBowItemStack(DamageSource damageSource) {
            Projectile projectile;
            ItemStack bow;
            Entity entity = damageSource.getDirectEntity();
            if (entity instanceof Projectile && (bow = ((ProjectileWithBow)(projectile = (Projectile)entity)).getBowItem()) != null && !bow.isEmpty()) {
                return bow;
            }
            return ItemStack.EMPTY;
        }

        public ItemStack getMainCausingStack() {
            return LivingHurtEvent.getMainCausingStack(this.damageSource);
        }

        public Iterable<ItemStack> getCausingItemStackAndArmorOfAttacker() {
            return LivingHurtEvent.getCausingItemStackAndArmorOfAttacker(this.damageSource);
        }

        public static Iterable<ItemStack> getCausingItemStackAndArmorOfAttacker(DamageSource damageSource) {
            ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>();
            Entity entity = damageSource.getDirectEntity();
            if (entity instanceof Projectile) {
                Projectile projectile = (Projectile)entity;
                ItemStack bow = ((ProjectileWithBow)projectile).getBowItem();
                if (bow != null && !bow.isEmpty()) {
                    itemStacks.add(bow);
                }
                if (projectile instanceof ItemProjectileEntity) {
                    ItemProjectileEntity itemProjectile = (ItemProjectileEntity)projectile;
                    itemStacks.add(itemProjectile.getPickupItem());
                }
            }
            if ((entity = damageSource.getEntity()) instanceof LivingEntity) {
                LivingEntity attacker = (LivingEntity)entity;
                attacker.getArmorSlots().forEach(itemStacks::add);
                itemStacks.add(attacker.getMainHandItem());
            }
            return itemStacks;
        }
    }

    public static class ReloadEventData {
        public Map<ResourceLocation, String> data = new HashMap<ResourceLocation, String>();

        public void setData(ResourceLocation id, String data) {
        }
    }
}

