/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.forge;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.ItemAbility;
import net.neoforged.neoforge.common.extensions.IItemExtension;
import smartin.miapi.item.modular.ModularItem;
import smartin.miapi.item.modular.items.armor.ModularElytraItem;
import smartin.miapi.modules.abilities.toolabilities.AxeAbility;
import smartin.miapi.modules.abilities.toolabilities.HoeAbility;
import smartin.miapi.modules.abilities.toolabilities.ShovelAbility;
import smartin.miapi.modules.abilities.util.AbilityProperty;
import smartin.miapi.modules.abilities.util.ItemUseAbility;
import smartin.miapi.modules.properties.armor.CanWalkOnSnow;
import smartin.miapi.modules.properties.armor.EquipmentSlotProperty;
import smartin.miapi.modules.properties.armor.IsPiglinGold;
import smartin.miapi.modules.properties.enchanment.EnchantAbilityProperty;
import smartin.miapi.modules.properties.mining.MiningLevelProperty;
import smartin.miapi.registries.RegistryInventory;

public class Injection {
    public static void delegateMethods(Object source, Object target) {
        Method[] sourceMethods;
        Class<?> sourceClass = source.getClass();
        Class<?> targetClass = target.getClass();
        for (Method sourceMethod : sourceMethods = sourceClass.getDeclaredMethods()) {
            sourceMethod.setAccessible(true);
            try {
                Method targetMethod = targetClass.getMethod(sourceMethod.getName(), sourceMethod.getParameterTypes());
                Object returnValue = sourceMethod.invoke(source, new Object[0]);
                targetMethod.invoke(target, returnValue);
                System.out.println("Delegated " + sourceMethod.getName());
            }
            catch (NoSuchMethodException e) {
                System.out.println("No matching method in target for: " + sourceMethod.getName());
            }
            catch (Exception e) {
                System.out.println("Error invoking method: " + sourceMethod.getName());
                e.printStackTrace();
            }
        }
    }

    public static void setup() {
        RegistryInventory.MODULAR_ITEMS.addCallback(item -> Injection.delegateMethods(new NeoForgeItemMethods((Item)item){
            final /* synthetic */ Item val$item;
            {
                this.val$item = item;
            }

            public boolean isRepairable(ItemStack arg) {
                return this.val$item.isValidRepairItem(arg, arg);
            }
        }, item));
    }

    public static interface NeoForgeItemMethods
    extends IItemExtension {
        default public boolean isPiglinCurrency(ItemStack stack) {
            return stack.getItem() == PiglinAi.BARTERING_ITEM;
        }

        default public boolean makesPiglinsNeutral(ItemStack stack, LivingEntity wearer) {
            return IsPiglinGold.isPiglinGoldItem(stack);
        }

        default public boolean canEquip(ItemStack stack, EquipmentSlot armorType, LivingEntity entity) {
            return entity.getEquipmentSlotForItem(stack) == armorType || EquipmentSlotProperty.getSlot(stack).test(armorType);
        }

        default public boolean canPerformAction(ItemStack stack, ItemAbility toolAction) {
            if (ModularItem.isModularItem(stack)) {
                if (toolAction.equals(ItemAbilities.AXE_DIG)) {
                    return NeoForgeItemMethods.canMine(stack, "axe");
                }
                if (toolAction.equals(ItemAbilities.PICKAXE_DIG)) {
                    return NeoForgeItemMethods.canMine(stack, "pickaxe");
                }
                if (toolAction.equals(ItemAbilities.SHOVEL_DIG)) {
                    return NeoForgeItemMethods.canMine(stack, "shovel");
                }
                if (toolAction.equals(ItemAbilities.HOE_DIG)) {
                    return NeoForgeItemMethods.canMine(stack, "hoe");
                }
                if (toolAction.equals(ItemAbilities.SHEARS_DIG)) {
                    return NeoForgeItemMethods.canMine(stack, "shear");
                }
                if (toolAction.equals(ItemAbilities.SWORD_DIG)) {
                    return NeoForgeItemMethods.canMine(stack, "sword");
                }
                if (ItemAbilities.DEFAULT_AXE_ACTIONS.contains(toolAction)) {
                    return NeoForgeItemMethods.hasRightClickBehaviour(stack, AxeAbility.class::isInstance);
                }
                if (ItemAbilities.DEFAULT_HOE_ACTIONS.contains(toolAction)) {
                    return NeoForgeItemMethods.hasRightClickBehaviour(stack, HoeAbility.class::isInstance);
                }
                if (ItemAbilities.DEFAULT_SHOVEL_ACTIONS.contains(toolAction)) {
                    return NeoForgeItemMethods.hasRightClickBehaviour(stack, ShovelAbility.class::isInstance);
                }
            }
            return false;
        }

        private static boolean canMine(ItemStack stack, String type) {
            Optional<Map> optional = MiningLevelProperty.property.getData(stack);
            return optional.map(stringMiningRuleMap -> stringMiningRuleMap.containsKey(type)).orElse(false);
        }

        private static boolean hasRightClickBehaviour(ItemStack stack, Predicate<? super ItemUseAbility> predicate) {
            return AbilityProperty.property.getData(stack).map(abilities -> abilities.stream().anyMatch(a -> predicate.test(a.ability))).orElse(false);
        }

        default public int getEnchantmentValue(ItemStack stack) {
            return (int)EnchantAbilityProperty.getEnchantAbility(stack);
        }

        default public boolean canElytraFly(ItemStack stack, LivingEntity entity) {
            return stack.getItem() instanceof ModularElytraItem;
        }

        default public boolean canWalkOnPowderedSnow(ItemStack stack, LivingEntity wearer) {
            return CanWalkOnSnow.canSnowWalk(stack);
        }
    }
}

