/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.forge;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import smartin.miapi.Miapi;
import smartin.miapi.datapack.ReloadEvents;
import smartin.miapi.events.MiapiEvents;
import smartin.miapi.modules.conditions.ConditionManager;

public class MiapiReloadListenerForge
implements PreparableReloadListener {
    Supplier<RegistryAccess> registryAccess;
    static long timeStart;
    public static Map<ResourceLocation, String> reloadData;

    public MiapiReloadListenerForge(Supplier<RegistryAccess> registryAccess) {
        this.registryAccess = registryAccess;
    }

    public CompletableFuture load(ResourceManager manager, ProfilerFiller profiler, Executor executor) {
        LinkedHashMap data = new LinkedHashMap();
        ReloadEvents.SYNCED_PATHS.forEach((modID, dataPaths) -> dataPaths.forEach(dataPath -> {
            Map map = manager.listResourceStacks(dataPath, fileName -> true);
            map.forEach((identifier, resources) -> resources.forEach(resource -> {
                try {
                    String dataString;
                    try (BufferedReader reader = resource.openAsReader();){
                        dataString = reader.lines().collect(Collectors.joining());
                    }
                    data.put(identifier, dataString);
                }
                catch (Exception e) {
                    Miapi.LOGGER.warn("Error Loading Resource" + String.valueOf(identifier) + " " + String.valueOf(resources));
                }
            }));
        }));
        return CompletableFuture.completedFuture(data);
    }

    public CompletableFuture<Void> apply(Object data, ResourceManager manager, ProfilerFiller profiler, Executor executor) {
        return CompletableFuture.runAsync(() -> {
            HashMap<ResourceLocation, String> dataMap = new HashMap<ResourceLocation, String>((Map)data);
            HashMap<ResourceLocation, String> filteredMap = new HashMap<ResourceLocation, String>();
            dataMap.forEach((key, value) -> {
                if (!key.getPath().endsWith(".json")) {
                    filteredMap.put((ResourceLocation)key, (String)value);
                    return;
                }
                try {
                    JsonObject element = (JsonObject)Miapi.gson.fromJson(value, JsonObject.class);
                    if (!element.has("load_condition")) {
                        filteredMap.put((ResourceLocation)key, (String)value);
                        return;
                    }
                    boolean allowed = ConditionManager.get(element.get("load_condition")).isAllowed(new ConditionManager.ConditionContext(this){

                        @Override
                        public ConditionManager.ConditionContext copy() {
                            return this;
                        }
                    });
                    if (allowed) {
                        element.remove("load_condition");
                        Miapi.LOGGER.info("redid " + String.valueOf(key));
                        filteredMap.put((ResourceLocation)key, Miapi.gson.toJson((JsonElement)element));
                    }
                }
                catch (Exception e) {
                    filteredMap.put((ResourceLocation)key, (String)value);
                }
            });
            reloadData = filteredMap;
        });
    }

    public static void actualReload(RegistryAccess access) {
        MiapiEvents.ReloadEventData data = new MiapiEvents.ReloadEventData();
        data.data = new LinkedHashMap<ResourceLocation, String>();
        data.data.putAll(reloadData);
        ReloadEvents.RAW_DATA_PACKS.clear();
        ReloadEvents.RAW_DATA_PACKS.putAll(reloadData);
        ((MiapiEvents.ReloadEvent)MiapiEvents.ADJUST_RAW_DATA.invoker()).onReload(data);
        ++ReloadEvents.reloadCounter;
        timeStart = System.nanoTime();
        ReloadEvents.START.fireEvent(false, access);
        ReloadEvents.DataPackLoader.trigger(data.data);
        ReloadEvents.MAIN.fireEvent(false, access);
        ReloadEvents.END.fireEvent(false, access);
        Miapi.LOGGER.info("Server load took " + (double)(System.nanoTime() - timeStart) / 1000.0 / 1000.0 + " ms");
        --ReloadEvents.reloadCounter;
        if (Miapi.server != null) {
            Miapi.server.getPlayerList().getPlayers().forEach(ReloadEvents::triggerReloadOnClient);
        }
    }

    public CompletableFuture<Void> reload(PreparableReloadListener.PreparationBarrier preparationBarrier, ResourceManager resourceManager, ProfilerFiller preparationsProfiler, ProfilerFiller reloadProfiler, Executor backgroundExecutor, Executor gameExecutor) {
        return ((CompletableFuture)this.load(resourceManager, preparationsProfiler, backgroundExecutor).thenCompose(arg_0 -> ((PreparableReloadListener.PreparationBarrier)preparationBarrier).wait(arg_0))).thenAcceptAsync(a -> this.apply(a, resourceManager, reloadProfiler, gameExecutor));
    }

    static {
        reloadData = new HashMap<ResourceLocation, String>();
    }
}

