/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.forge;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.architectury.event.events.client.ClientLifecycleEvent;
import dev.architectury.event.events.common.LifecycleEvent;
import dev.architectury.platform.Platform;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.InterModComms;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.InterModEnqueueEvent;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.event.AddReloadListenerEvent;
import net.neoforged.neoforge.event.entity.EntityAttributeModificationEvent;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import net.neoforged.neoforge.registries.RegisterEvent;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import smartin.miapi.Miapi;
import smartin.miapi.attributes.AttributeRegistry;
import smartin.miapi.client.MiapiClient;
import smartin.miapi.client.atlas.ArmorModelManager;
import smartin.miapi.client.model.MiapiItemModel;
import smartin.miapi.client.model.item.ItemBakedModelReplacement;
import smartin.miapi.datapack.ReloadEvents;
import smartin.miapi.events.MiapiEvents;
import smartin.miapi.forge.ForgeModel;
import smartin.miapi.forge.MiapiGlobalLootModifier;
import smartin.miapi.forge.MiapiReloadListenerForge;
import smartin.miapi.forge.ModelWithHumanModel;
import smartin.miapi.forge.compat.ApotheosisCompat;
import smartin.miapi.forge.compat.QuarkCompat;
import smartin.miapi.forge.compat.epic_fight.EpicFightCompat;
import smartin.miapi.item.modular.VisualModularItem;
import smartin.miapi.modules.properties.attributes.AttributeProperty;
import smartin.miapi.modules.properties.compat.ht_treechop.TreechopUtil;
import smartin.miapi.modules.properties.render.ModelProperty;
import smartin.miapi.registries.RegistryInventory;

@Mod(value="miapi")
public class TrulyModularForge {
    public static int test = 0;
    public static final IEventBus BUS = ModLoadingContext.get().getActiveContainer().getEventBus();

    public TrulyModularForge() {
        NeoForge.EVENT_BUS.register((Object)new ServerEvents());
        Miapi.init();
        TrulyModularForge.loadCompat("epicfight", () -> EpicFightCompat.setup());
        TrulyModularForge.loadCompat("quark", QuarkCompat::setup);
        TrulyModularForge.loadCompat("apotheosis", ApotheosisCompat::setup);
        LifecycleEvent.SERVER_STARTING.register(instance -> TrulyModularForge.setupAttributes());
        ReloadEvents.START.subscribe((isClient, access) -> TrulyModularForge.setupAttributes());
        if (Platform.getEnv() == Dist.CLIENT) {
            ClientLifecycleEvent.CLIENT_STARTED.register((Object)new ClientLifecycleEvent.ClientState(this){

                public void stateChanged(Minecraft instance) {
                    RegistryInventory.MODULAR_ITEMS.getFlatMap().values().forEach(item -> {
                        Method[] methods = item.getClass().getDeclaredMethods();
                    });
                }
            });
        }
        MiapiEvents.GET_ITEM_SHIELD_COOLDOWN.register((Object)new MiapiEvents.CooldownAttackingWeaponGatherEvent(this){

            @Override
            public void durability(MutableInt cooldown, ItemStack attacking, ItemStack shield, LivingEntity defender, Entity attacker) {
                LivingEntity livingAttacker;
                if (cooldown.getValue() == 0 && attacker instanceof LivingEntity && (attacking.canDisableShield(shield, defender, livingAttacker = (LivingEntity)attacker) || attacking.canDisableShield(Items.SHIELD.getDefaultInstance(), defender, livingAttacker))) {
                    cooldown.setValue(100);
                }
            }
        }, -1.0f);
    }

    public static void setupAttributes() {
        AttributeRegistry.SWIM_SPEED = NeoForgeMod.SWIM_SPEED;
        AttributeProperty.replaceMap.put("miapi:generic.swim_speed", () -> (Attribute)AttributeRegistry.SWIM_SPEED.value());
    }

    public static void loadCompat(String modId, Runnable onLoaded) {
        try {
            if (Platform.isModLoaded((String)modId)) {
                onLoaded.run();
            }
        }
        catch (RuntimeException e) {
            Miapi.LOGGER.error("could not setup compat for " + modId, (Throwable)e);
        }
    }

    public static class ServerEvents {
        @SubscribeEvent
        public void addReloadListeners(AddReloadListenerEvent addReloadListenerEvent) {
            Miapi.registryAccess = addReloadListenerEvent.getRegistryAccess();
            addReloadListenerEvent.addListener((PreparableReloadListener)new MiapiReloadListenerForge(() -> ((AddReloadListenerEvent)addReloadListenerEvent).getRegistryAccess()));
        }
    }

    public static class ClientEvents {
    }

    @EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT}, modid="miapi")
    public static class ClientModEvents {
        @SubscribeEvent
        public static void entityRenderers(ModelEvent.ModifyBakingResult registerAdditional) {
            List<ModelResourceLocation> ids = RegistryInventory.MODULAR_ITEMS.getFlatMap().keySet().stream().map(ModelResourceLocation::inventory).toList();
            ModelProperty.textureGetter = registerAdditional.getTextureGetter();
            ids.forEach(id -> registerAdditional.getModels().put(id, new ItemBakedModelReplacement(){

                @Override
                public boolean isGui3d() {
                    return false;
                }

                @Override
                public boolean usesBlockLight() {
                    return false;
                }
            }));
            TrulyModularForge.setupAttributes();
        }

        @SubscribeEvent
        public static void registerKeybinds(RegisterKeyMappingsEvent registerAdditional) {
            MiapiClient.KEY_BINDINGS.addCallback(arg_0 -> ((RegisterKeyMappingsEvent)registerAdditional).register(arg_0));
        }

        @SubscribeEvent
        public static void setupArmorRender(RegisterClientExtensionsEvent itemExtention) {
            RegistryInventory.MODULAR_ITEMS.addCallback(item -> itemExtention.registerItem(new IClientItemExtensions(){
                public Map<ItemStack, ModelWithHumanModel> cache = new WeakHashMap<ItemStack, ModelWithHumanModel>();

                @Nullable
                public Font getFont(ItemStack stack, IClientItemExtensions.FontContext context) {
                    return super.getFont(stack, context);
                }

                public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                    return new BlockEntityWithoutLevelRenderer(this, Minecraft.getInstance().getBlockEntityRenderDispatcher(), Minecraft.getInstance().getEntityModels()){

                        public void renderByItem(ItemStack stack, ItemDisplayContext displayContext, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
                            MiapiItemModel model;
                            if (displayContext.equals((Object)ItemDisplayContext.GUI)) {
                                packedLight = 0xF000F0;
                                test += 100;
                                packedOverlay = OverlayTexture.NO_OVERLAY;
                                poseStack.translate(0.0f, 0.0f, 0.0f);
                                poseStack.last().transformNormal(new Vector3f(-1.0f, -1.0f, -1.0f), new Vector3f(0.0f, -1.0f, 0.0f));
                            }
                            if ((model = MiapiItemModel.getItemModel(stack)) != null) {
                                model.render(poseStack, stack, displayContext, 0.0f, buffer, null, packedLight, packedOverlay);
                            }
                            if (buffer instanceof MultiBufferSource.BufferSource) {
                                MultiBufferSource.BufferSource multiBufferSource = (MultiBufferSource.BufferSource)buffer;
                                multiBufferSource.endBatch();
                            }
                        }
                    };
                }

                public Model getGenericArmorModel(final LivingEntity livingEntity, final ItemStack itemStack, final EquipmentSlot equipmentSlot, HumanoidModel<?> original) {
                    if (VisualModularItem.isVisualModularItem(itemStack)) {
                        this.cache.computeIfAbsent(itemStack, i -> new ModelWithHumanModel(this, a -> RenderType.armorEntityGlint()){

                            public void renderToBuffer(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, int color) {
                                if (this.getHumanoidModel() != null && ForgeModel.source != null) {
                                    ArmorModelManager.renderArmorPiece(poseStack, ForgeModel.source, packedLight, equipmentSlot, itemStack, livingEntity, this.getHumanoidModel(), (EntityModel)this.getHumanoidModel());
                                }
                            }
                        });
                        ModelWithHumanModel model = this.cache.get(itemStack);
                        if (model != null) {
                            model.humanoidModel = original;
                            return model;
                        }
                    }
                    return super.getGenericArmorModel(livingEntity, itemStack, equipmentSlot, original);
                }

                public HumanoidModel<?> getHumanoidArmorModel(final LivingEntity livingEntity, final ItemStack itemStack, final EquipmentSlot equipmentSlot, HumanoidModel<?> original) {
                    if (VisualModularItem.isVisualModularItem(itemStack)) {
                        this.cache.computeIfAbsent(itemStack, i -> new ModelWithHumanModel(this, a -> RenderType.armorEntityGlint()){

                            public void renderToBuffer(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, int color) {
                                if (this.getHumanoidModel() != null && ForgeModel.source != null) {
                                    ArmorModelManager.renderArmorPiece(poseStack, ForgeModel.source, packedLight, equipmentSlot, itemStack, livingEntity, this.getHumanoidModel(), (EntityModel)this.getHumanoidModel());
                                }
                            }
                        });
                        ModelWithHumanModel model = this.cache.get(itemStack);
                        if (model != null) {
                            model.humanoidModel = original;
                            return model.humanoidModel;
                        }
                    }
                    return super.getHumanoidArmorModel(livingEntity, itemStack, equipmentSlot, original);
                }
            }, new Item[]{item}));
        }
    }

    @EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD, modid="miapi")
    public static class ModEvents {
        @SubscribeEvent
        public static void enqueueIMC(InterModEnqueueEvent event) {
            if (Platform.isModLoaded((String)"treechop")) {
                InterModComms.sendTo((String)"treechop", (String)"getTreeChopAPI", () -> TreechopUtil::setTreechopApi);
            }
        }

        @SubscribeEvent
        public static void register(RegisterEvent event) {
            event.register(NeoForgeRegistries.GLOBAL_LOOT_MODIFIER_SERIALIZERS.key(), Miapi.id("global_loot_mod"), () -> MiapiGlobalLootModifier.CODEC);
        }

        @SubscribeEvent
        public static void addEntityAttributes(EntityAttributeModificationEvent attributeModificationEvent) {
            AttributeRegistry.entityAttributeMap.forEach((id, attribute) -> attributeModificationEvent.getTypes().forEach(entityType -> attributeModificationEvent.add(entityType, attribute)));
        }
    }
}

