/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.forge.compat.epic_fight;

import com.mojang.blaze3d.vertex.PoseStack;
import com.redpxnda.nucleus.client.Rendering;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ElytraModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.layers.ElytraLayer;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import smartin.miapi.client.model.MiapiItemModel;
import smartin.miapi.item.modular.Transform;
import smartin.miapi.item.modular.VisualModularItem;
import smartin.miapi.mixin.client.ElytraEntityModelAccessor;
import smartin.miapi.mixin.client.ElytraFeatureRendererAccessor;
import smartin.miapi.mixin.client.LivingEntityRendererAccessor;
import yesman.epicfight.api.animation.Joint;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.client.mesh.HumanoidMesh;
import yesman.epicfight.client.renderer.patched.layer.ModelRenderLayer;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

@OnlyIn(value=Dist.CLIENT)
public class CustomModularArmorRenderer<E extends LivingEntity, T extends LivingEntityPatch<E>, M extends HumanoidModel<E>, AM extends HumanoidMesh>
extends ModelRenderLayer<E, T, M, HumanoidArmorLayer<E, M, M>, AM> {
    public static final Matrix4f wingMatrix = new Transform(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.4f, 0.0f), new Vector3f(1.0f, -1.0f, 1.0f)).toMatrix();
    List<ModelProvider> epicFightModelProviders = new ArrayList<ModelProvider>();

    public CustomModularArmorRenderer(AssetAccessor<AM> mesh) {
        super(mesh);
        this.addEFModelProvider(new String[]{"Root", "Torso", "Chest", "Shoulder_R", "Arm_R"}, "right_arm", new Transform(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(-0.0625f, 0.0625f, 0.0f), new Vector3f(-1.0f, 1.0f, 1.0f)).toMatrix());
        this.addEFModelProvider(new String[]{"Root", "Torso", "Chest", "Shoulder_L", "Arm_L"}, "left_arm", new Transform(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0625f, 0.0625f, 0.0f), new Vector3f(-1.0f, 1.0f, 1.0f)).toMatrix());
        this.addEFModelProvider(new String[]{"Root", "Thigh_R"}, "right_leg", null, EquipmentSlot.FEET, true);
        this.addEFModelProvider(new String[]{"Root", "Thigh_L"}, "left_leg", null, EquipmentSlot.FEET, true);
        this.addEFModelProvider(new String[]{"Root", "Thigh_R", "Leg_R"}, "right_leg", new Transform(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, -0.3f, 0.0f), new Vector3f(1.0f, 1.0f, 1.0f)).toMatrix(), EquipmentSlot.FEET, false);
        this.addEFModelProvider(new String[]{"Root", "Thigh_L", "Leg_L"}, "left_leg", new Transform(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, -0.3f, 0.0f), new Vector3f(1.0f, 1.0f, 1.0f)).toMatrix(), EquipmentSlot.FEET, false);
        this.addEFModelProvider(new String[]{"Root", "Torso", "Chest", "Head"}, "head", new Transform(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(1.0f, -1.0f, 1.0f)).toMatrix());
        this.addEFModelProvider(new String[]{"Root", "Torso", "Chest", "Head"}, "hat", new Transform(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(1.0f, -1.0f, 1.0f)).toMatrix());
        this.addEFModelProvider(new String[]{"Root", "Torso"}, "chest", new Transform(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.7f, 0.0f), new Vector3f(1.0f, -1.0f, 1.0f)).toMatrix());
        this.addEFModelProvider(new String[]{"Root", "Torso"}, "body", new Transform(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.7f, 0.0f), new Vector3f(1.0f, -1.0f, 1.0f)).toMatrix());
    }

    private void addEFModelProvider(String[] joint, String miapiJoint) {
        this.epicFightModelProviders.add(new ModelProvider(this, joint, miapiJoint, null));
    }

    private void addEFModelProvider(String[] joint, String miapiJoint, Matrix4f matrix4f) {
        this.epicFightModelProviders.add(new ModelProvider(this, joint, miapiJoint, matrix4f));
    }

    private void addEFModelProvider(String[] joint, String miapiJoint, Matrix4f matrix4f, EquipmentSlot equipmentSlot, boolean inverse) {
        ModelProvider modelProvider = new ModelProvider(this, joint, miapiJoint, matrix4f);
        modelProvider.inverse = inverse;
        modelProvider.equipmentSlot = equipmentSlot;
        this.epicFightModelProviders.add(modelProvider);
    }

    protected void renderLayer(T patch, E entity, @Nullable HumanoidArmorLayer<E, M, M> emmArmorFeatureRenderer, PoseStack poseStack, MultiBufferSource multiBufferSource, int i, OpenMatrix4f[] openMatrix4fs, float v, float v1, float v2, float v3) {
        float partial = (float)Rendering.getGameAndPartialTime();
        this.renderSlot(entity, patch, emmArmorFeatureRenderer, poseStack, multiBufferSource, i, EquipmentSlot.HEAD, openMatrix4fs, partial);
        this.renderSlot(entity, patch, emmArmorFeatureRenderer, poseStack, multiBufferSource, i, EquipmentSlot.CHEST, openMatrix4fs, partial);
        this.renderSlot(entity, patch, emmArmorFeatureRenderer, poseStack, multiBufferSource, i, EquipmentSlot.LEGS, openMatrix4fs, partial);
        this.renderSlot(entity, patch, emmArmorFeatureRenderer, poseStack, multiBufferSource, i, EquipmentSlot.FEET, openMatrix4fs, partial);
    }

    private void renderSlot(E entity, T patch, @NotNull HumanoidArmorLayer<E, M, M> emmArmorFeatureRenderer, PoseStack matrixStack, MultiBufferSource vertexConsumerProvider, int i, EquipmentSlot slot, OpenMatrix4f[] openMatrix4fs, float partial) {
        this.renderArmorPiece(matrixStack, vertexConsumerProvider, i, slot, entity.getItemBySlot(slot), (LivingEntity)entity, patch, openMatrix4fs, partial);
    }

    public void renderArmorPiece(PoseStack matrices, MultiBufferSource vertexConsumers, int light, EquipmentSlot armorSlot, ItemStack itemStack, LivingEntity entity, T patch, OpenMatrix4f[] openMatrix4fs, float partial) {
        if (!VisualModularItem.isVisualModularItem(itemStack)) {
            return;
        }
        matrices.pushPose();
        patch.getArmature().getPoseAsTransformMatrix(patch.getClientAnimator().getPose(partial), false);
        this.epicFightModelProviders.forEach(modelProvider -> {
            matrices.pushPose();
            if (modelProvider.apply(matrices, patch.getArmature()) && (modelProvider.equipmentSlot == null || modelProvider.equipmentSlot == armorSlot == !modelProvider.inverse)) {
                String key = modelProvider.tmId;
                MiapiItemModel miapiItemModel = MiapiItemModel.getItemModel(itemStack);
                for (int i = 0; i < modelProvider.efId.length; ++i) {
                }
                Joint joint = patch.getArmature().searchJointByName(modelProvider.efId[modelProvider.efId.length - 1]);
                matrices.mulPose(CustomModularArmorRenderer.toJomlMatrix(patch.getArmature().getBindedTransformFor(patch.getClientAnimator().getPose(partial), joint)));
                if (modelProvider.matrix4f != null) {
                    matrices.mulPose(modelProvider.matrix4f);
                }
                if (miapiItemModel != null) {
                    miapiItemModel.render(key, itemStack, matrices, ItemDisplayContext.HEAD, 0.0f, vertexConsumers, entity, light, OverlayTexture.NO_OVERLAY);
                }
            }
            matrices.popPose();
        });
        matrices.popPose();
        matrices.pushPose();
        Joint joint = patch.getArmature().searchJointByName("Chest");
        matrices.mulPose(CustomModularArmorRenderer.toJomlMatrix(patch.getArmature().getBindedTransformFor(patch.getClientAnimator().getPose(partial), joint)));
        matrices.mulPose(wingMatrix);
        EntityRenderer entityRenderer = Minecraft.getInstance().getEntityRenderDispatcher().getRenderer((Entity)entity);
        if (entityRenderer instanceof LivingEntityRenderer) {
            LivingEntityRenderer livingEntityRenderer = (LivingEntityRenderer)entityRenderer;
            Optional<Object> elytraFeatureRenderer = ((LivingEntityRendererAccessor)livingEntityRenderer).getFeatures().stream().filter(a -> a instanceof ElytraLayer).findAny();
            MiapiItemModel miapiItemModel = MiapiItemModel.getItemModel(itemStack);
            if (elytraFeatureRenderer.isPresent() && miapiItemModel != null) {
                ElytraModel elytraEntityModel = ((ElytraFeatureRendererAccessor)elytraFeatureRenderer.get()).getElytra();
                livingEntityRenderer.getModel().copyPropertiesTo(elytraEntityModel);
                matrices.pushPose();
                ModelPart part = ((ElytraEntityModelAccessor)elytraEntityModel).getLeftWing();
                part.translateAndRotate(matrices);
                miapiItemModel.render("left_wing", itemStack, matrices, ItemDisplayContext.HEAD, 0.0f, vertexConsumers, entity, light, OverlayTexture.NO_OVERLAY);
                matrices.popPose();
                matrices.pushPose();
                ModelPart rightWing = ((ElytraEntityModelAccessor)elytraEntityModel).getRightWing();
                rightWing.translateAndRotate(matrices);
                miapiItemModel.render("right_wing", itemStack, matrices, ItemDisplayContext.HEAD, 0.0f, vertexConsumers, entity, light, OverlayTexture.NO_OVERLAY);
                matrices.popPose();
            }
        }
        matrices.popPose();
    }

    public static Matrix4f toJomlMatrix(OpenMatrix4f openMatrix4f) {
        Matrix4f jomlMatrix = new Matrix4f();
        jomlMatrix.m00(openMatrix4f.m00);
        jomlMatrix.m01(openMatrix4f.m01);
        jomlMatrix.m02(openMatrix4f.m02);
        jomlMatrix.m03(openMatrix4f.m03);
        jomlMatrix.m10(openMatrix4f.m10);
        jomlMatrix.m11(openMatrix4f.m11);
        jomlMatrix.m12(openMatrix4f.m12);
        jomlMatrix.m13(openMatrix4f.m13);
        jomlMatrix.m20(openMatrix4f.m20);
        jomlMatrix.m21(openMatrix4f.m21);
        jomlMatrix.m22(openMatrix4f.m22);
        jomlMatrix.m23(openMatrix4f.m23);
        jomlMatrix.m30(openMatrix4f.m30);
        jomlMatrix.m31(openMatrix4f.m31);
        jomlMatrix.m32(openMatrix4f.m32);
        jomlMatrix.m33(openMatrix4f.m33);
        return jomlMatrix;
    }

    public class ModelProvider {
        public String tmId;
        public String[] efId = new String[0];
        public Matrix4f matrix4f;
        public EquipmentSlot equipmentSlot = null;
        public boolean inverse = false;

        public ModelProvider(CustomModularArmorRenderer this$0, String[] jointID, String tmId, Matrix4f matrix4f) {
            this.efId = jointID;
            this.tmId = tmId;
            this.matrix4f = matrix4f;
        }

        public boolean apply(PoseStack matrixStack, Armature armature) {
            return true;
        }
    }
}

