/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.forge.mixin;

import dev.architectury.event.EventResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Arrow;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import smartin.miapi.attributes.AttributeRegistry;
import smartin.miapi.events.MiapiEvents;
import smartin.miapi.mixin.LivingEntityAccessor;

@Mixin(value={LivingEntity.class})
public class LivingEntityMixin {
    private float storedValue;
    private DamageSource storedDamageSource;
    private MiapiEvents.LivingHurtEvent lastEvent;

    @Inject(method={"hurt(Lnet/minecraft/world/damagesource/DamageSource;F)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void miapi$damageEvent(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        EventResult result;
        Player entity;
        MiapiEvents.LivingHurtEvent livingHurtEvent = new MiapiEvents.LivingHurtEvent((LivingEntity)this, source.getEntity(), source, amount);
        Entity entity2 = source.getEntity();
        if (entity2 instanceof Player) {
            entity = (Player)entity2;
            livingHurtEvent.isCritical = this.hasCrited(entity, (LivingEntity)this);
        }
        if ((entity2 = source.getEntity()) instanceof Arrow) {
            entity = (Arrow)entity2;
        }
        if ((result = ((MiapiEvents.LivingHurt)MiapiEvents.LIVING_HURT.invoker()).hurt(livingHurtEvent)).interruptsFurtherEvaluation()) {
            cir.setReturnValue((Object)false);
        }
        this.lastEvent = livingHurtEvent;
        this.storedValue = livingHurtEvent.amount;
        this.storedDamageSource = livingHurtEvent.damageSource;
    }

    @ModifyVariable(method={"getDamageAfterArmorAbsorb(Lnet/minecraft/world/damagesource/DamageSource;F)F"}, at=@At(value="HEAD"), ordinal=0)
    private float miapi$modiyAppliedDamageEvent(float amount) {
        MiapiEvents.LivingHurtEvent livingHurtEvent = new MiapiEvents.LivingHurtEvent((LivingEntity)this, this.storedDamageSource.getEntity(), this.storedDamageSource, amount);
        if (this.storedDamageSource != null) {
            Entity entity = this.storedDamageSource.getEntity();
            if (entity instanceof Player) {
                Player entity2 = (Player)entity;
                livingHurtEvent.isCritical = this.hasCrited(entity2, (LivingEntity)this);
            }
            if ((entity = this.storedDamageSource.getEntity()) instanceof Arrow) {
                Arrow arrow = (Arrow)entity;
            }
        }
        ((MiapiEvents.LivingHurt)MiapiEvents.LIVING_HURT_AFTER_ARMOR.invoker()).hurt(livingHurtEvent);
        return livingHurtEvent.amount;
    }

    @Unique
    private boolean hasCrited(Player attacker, LivingEntity defender) {
        return Boolean.TRUE.equals(AttributeRegistry.hasCrittedLast.putIfAbsent(attacker, false));
    }

    @Inject(method={"hurt(Lnet/minecraft/world/damagesource/DamageSource;F)Z"}, at={@At(value="TAIL")})
    private void miapi$damageEventAfter(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        LivingEntity livingEntity = (LivingEntity)this;
        float lastDamageTaken = ((LivingEntityAccessor)livingEntity).getLastDamageTaken();
        MiapiEvents.LivingHurtEvent livingHurtEvent = new MiapiEvents.LivingHurtEvent((LivingEntity)this, source.getEntity(), source, lastDamageTaken);
        livingHurtEvent.isCritical = this.lastEvent.isCritical;
        ((MiapiEvents.LivingHurt)MiapiEvents.LIVING_HURT_AFTER.invoker()).hurt(livingHurtEvent);
    }

    @ModifyVariable(method={"hurt(Lnet/minecraft/world/damagesource/DamageSource;F)Z"}, at=@At(value="HEAD"), ordinal=0)
    private float miapi$damageEventValue(float value) {
        return this.storedValue;
    }

    @ModifyVariable(method={"hurt(Lnet/minecraft/world/damagesource/DamageSource;F)Z"}, at=@At(value="HEAD"), ordinal=0)
    private DamageSource miapi$damageEventSource(DamageSource value) {
        return this.storedDamageSource;
    }
}

