/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.forge.mixin.item;

import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.ItemAbility;
import org.spongepowered.asm.mixin.Mixin;
import smartin.miapi.item.modular.ModularItem;
import smartin.miapi.item.modular.items.BrokenModularVisualOnlyItem;
import smartin.miapi.item.modular.items.ExampleModularItem;
import smartin.miapi.item.modular.items.ExampleModularStrackableItem;
import smartin.miapi.item.modular.items.armor.ModularBoots;
import smartin.miapi.item.modular.items.armor.ModularChestPlate;
import smartin.miapi.item.modular.items.armor.ModularElytraItem;
import smartin.miapi.item.modular.items.armor.ModularHelmet;
import smartin.miapi.item.modular.items.armor.ModularLeggings;
import smartin.miapi.item.modular.items.bows.ModularArrow;
import smartin.miapi.item.modular.items.bows.ModularBow;
import smartin.miapi.item.modular.items.bows.ModularCrossbow;
import smartin.miapi.item.modular.items.shield.ModularNonVanillaShield;
import smartin.miapi.item.modular.items.shield.ModularVanillaShield;
import smartin.miapi.item.modular.items.shield.TowerShieldComponent;
import smartin.miapi.item.modular.items.tools.ModularAxe;
import smartin.miapi.item.modular.items.tools.ModularHoe;
import smartin.miapi.item.modular.items.tools.ModularMace;
import smartin.miapi.item.modular.items.tools.ModularPickaxe;
import smartin.miapi.item.modular.items.tools.ModularShovel;
import smartin.miapi.item.modular.items.tools.ModularSword;
import smartin.miapi.item.modular.items.tools.ModularWeapon;
import smartin.miapi.modules.abilities.toolabilities.AxeAbility;
import smartin.miapi.modules.abilities.toolabilities.HoeAbility;
import smartin.miapi.modules.abilities.toolabilities.ShovelAbility;
import smartin.miapi.modules.abilities.util.AbilityProperty;
import smartin.miapi.modules.abilities.util.ItemUseAbility;
import smartin.miapi.modules.properties.armor.CanWalkOnSnow;
import smartin.miapi.modules.properties.armor.EquipmentSlotProperty;
import smartin.miapi.modules.properties.armor.IsPiglinGold;
import smartin.miapi.modules.properties.enchanment.AllowedEnchantments;
import smartin.miapi.modules.properties.enchanment.EnchantAbilityProperty;
import smartin.miapi.modules.properties.mining.MiningLevelProperty;

@Mixin(value={ExampleModularItem.class, ExampleModularStrackableItem.class, BrokenModularVisualOnlyItem.class, ModularArrow.class, ModularCrossbow.class, ModularBow.class, ModularNonVanillaShield.class, ModularVanillaShield.class, TowerShieldComponent.class, ModularAxe.class, ModularHoe.class, ModularPickaxe.class, ModularShovel.class, ModularMace.class, ModularSword.class, ModularWeapon.class, ModularHelmet.class, ModularChestPlate.class, ModularElytraItem.class, ModularLeggings.class, ModularBoots.class})
public abstract class ModularItemTestMixin {
    public boolean makesPiglinsNeutral(ItemStack stack, LivingEntity wearer) {
        return IsPiglinGold.isPiglinGoldItem(stack);
    }

    public boolean canEquip(ItemStack stack, EquipmentSlot armorType, LivingEntity entity) {
        return entity.getEquipmentSlotForItem(stack) == armorType || EquipmentSlotProperty.getSlot(stack).test(armorType);
    }

    public boolean canPerformAction(ItemStack stack, ItemAbility toolAction) {
        if (ModularItem.isModularItem(stack)) {
            if (toolAction.equals(ItemAbilities.AXE_DIG)) {
                return ModularItemTestMixin.canMine(stack, "axe");
            }
            if (toolAction.equals(ItemAbilities.PICKAXE_DIG)) {
                return ModularItemTestMixin.canMine(stack, "pickaxe");
            }
            if (toolAction.equals(ItemAbilities.SHOVEL_DIG)) {
                return ModularItemTestMixin.canMine(stack, "shovel");
            }
            if (toolAction.equals(ItemAbilities.HOE_DIG)) {
                return ModularItemTestMixin.canMine(stack, "hoe");
            }
            if (toolAction.equals(ItemAbilities.SHEARS_DIG)) {
                return ModularItemTestMixin.canMine(stack, "shear");
            }
            if (toolAction.equals(ItemAbilities.SWORD_DIG)) {
                return ModularItemTestMixin.canMine(stack, "sword");
            }
            if (toolAction.equals(ItemAbilities.SWORD_SWEEP)) {
                return stack.getItem() instanceof SwordItem;
            }
            if (ItemAbilities.DEFAULT_AXE_ACTIONS.contains(toolAction)) {
                return ModularItemTestMixin.hasRightClickBehaviour(stack, AxeAbility.class::isInstance);
            }
            if (ItemAbilities.DEFAULT_HOE_ACTIONS.contains(toolAction)) {
                return ModularItemTestMixin.hasRightClickBehaviour(stack, HoeAbility.class::isInstance);
            }
            if (ItemAbilities.DEFAULT_SHOVEL_ACTIONS.contains(toolAction)) {
                return ModularItemTestMixin.hasRightClickBehaviour(stack, ShovelAbility.class::isInstance);
            }
        }
        return false;
    }

    private static boolean canMine(ItemStack stack, String type) {
        Optional<Map> optional = MiningLevelProperty.property.getData(stack);
        return optional.map(stringMiningRuleMap -> stringMiningRuleMap.containsKey(type) && ((MiningLevelProperty.MiningRule)stringMiningRuleMap.get(type)).speed().getValue() > 1.0).orElse(false);
    }

    private static boolean hasRightClickBehaviour(ItemStack stack, Predicate<? super ItemUseAbility> predicate) {
        return AbilityProperty.property.getData(stack).map(abilities -> abilities.stream().anyMatch(a -> predicate.test(a.ability))).orElse(false);
    }

    public int getEnchantmentValue(ItemStack stack) {
        return (int)EnchantAbilityProperty.getEnchantAbility(stack);
    }

    public boolean canElytraFly(ItemStack stack, LivingEntity entity) {
        return stack.getItem() instanceof ModularElytraItem;
    }

    public boolean canWalkOnPowderedSnow(ItemStack stack, LivingEntity wearer) {
        return CanWalkOnSnow.canSnowWalk(stack);
    }

    public boolean isPrimaryItemFor(ItemStack stack, Enchantment enchantment) {
        return AllowedEnchantments.canEnchant(stack, enchantment, stack.getItem() == Items.BOOK || enchantment.isPrimaryItem(stack));
    }
}

