/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.item;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.annotation.Nullable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import smartin.miapi.config.MiapiConfig;
import smartin.miapi.datapack.ReloadEvents;

public class FakeItemManager {
    private static ThreadLocal<Map<Item, ItemStack>> SHORT_CACHE = ThreadLocal.withInitial(HashMap::new);
    private static final Map<Item, ItemStack> LONG_CACHE = new ConcurrentHashMap<Item, ItemStack>();

    public static void getItemCall(ItemStack itemStack, Item item) {
        SHORT_CACHE.get().put(item, itemStack);
        LONG_CACHE.put(item, itemStack);
    }

    public static ItemStack getDefaultInstance(Item item) {
        if (MiapiConfig.getServerConfig().other.fakeItemStack) {
            ItemStack itemStack = SHORT_CACHE.get().getOrDefault(item, LONG_CACHE.getOrDefault(item, new ItemStack((ItemLike)item))).copy();
            return itemStack;
        }
        return new ItemStack((ItemLike)item);
    }

    @Nullable
    public static ItemStack getLastInstance(Item item) {
        ItemStack itemStack = SHORT_CACHE.get().getOrDefault(item, LONG_CACHE.get(item));
        if (itemStack != null) {
            // empty if block
        }
        return itemStack;
    }

    static {
        ReloadEvents.START.subscribe((isClient, registryAccess) -> {
            SHORT_CACHE = ThreadLocal.withInitial(HashMap::new);
            LONG_CACHE.clear();
        });
    }
}

