/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.item;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmithingRecipe;
import net.minecraft.world.item.crafting.SmithingRecipeInput;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import smartin.miapi.events.MiapiEvents;
import smartin.miapi.item.modular.VisualModularItem;
import smartin.miapi.material.MaterialProperty;
import smartin.miapi.material.base.Material;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.registries.RegistryInventory;

public class MaterialSmithingRecipe
implements SmithingRecipe {
    public static MapCodec<MaterialSmithingRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Ingredient.CODEC.fieldOf("template").forGetter(recipe -> recipe.smithingTemplate), (App)ResourceLocation.CODEC.fieldOf("base").forGetter(recipe -> recipe.startMaterial), (App)Ingredient.CODEC.fieldOf("addition").forGetter(recipe -> recipe.addition), (App)ResourceLocation.CODEC.fieldOf("result").forGetter(recipe -> recipe.resultMaterial)).apply((Applicative)instance, MaterialSmithingRecipe::new));
    public final ResourceLocation startMaterial;
    public final ResourceLocation resultMaterial;
    public final Ingredient smithingTemplate;
    public final Ingredient addition;

    public MaterialSmithingRecipe(Ingredient template, ResourceLocation baseMaterial, Ingredient addition, ResourceLocation resultMaterial) {
        this.startMaterial = baseMaterial;
        this.resultMaterial = resultMaterial;
        this.smithingTemplate = template;
        this.addition = addition;
    }

    public boolean isTemplateIngredient(@NotNull ItemStack stack) {
        return this.smithingTemplate.test(stack);
    }

    public boolean isBaseIngredient(ItemStack stack) {
        if (stack.getItem() instanceof VisualModularItem) {
            ModuleInstance instance = ItemModule.getModules(stack);
            return instance.allSubModules().stream().anyMatch(module -> {
                Material material = MaterialProperty.getMaterial(module);
                if (material != null) {
                    return material.getID().equals((Object)this.startMaterial);
                }
                return false;
            });
        }
        return false;
    }

    public boolean isAdditionIngredient(@NotNull ItemStack stack) {
        return this.addition.test(stack);
    }

    public boolean matches(SmithingRecipeInput inventory, @NotNull Level world) {
        return this.isTemplateIngredient(inventory.getItem(0)) && this.isBaseIngredient(inventory.getItem(1)) && this.addition.test(inventory.getItem(2));
    }

    @NotNull
    public ItemStack assemble(SmithingRecipeInput input, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        ItemStack old = input.getItem(1).copy();
        if (old.getItem() instanceof VisualModularItem) {
            ModuleInstance instance = ItemModule.getModules(old).copy();
            instance.allSubModules().forEach(module -> {
                Material material = MaterialProperty.getMaterial(module);
                if (material != null && material.getID().equals((Object)this.startMaterial)) {
                    MaterialProperty.setMaterial(module, MaterialProperty.MATERIAL_REGISTRY.get(this.resultMaterial));
                }
            });
            instance.writeToItem(old);
        }
        MiapiEvents.MaterialCraft data = new MiapiEvents.MaterialCraft(old);
        ((MiapiEvents.SmithingEvent)MiapiEvents.SMITHING_EVENT.invoker()).craft(data);
        return data.itemStack;
    }

    @NotNull
    public ItemStack getResultItem(HolderLookup.Provider registries) {
        return ItemStack.EMPTY;
    }

    public RecipeType<?> getType() {
        return RecipeType.SMITHING;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return RegistryInventory.serializer;
    }

    public static class Serializer
    implements RecipeSerializer<MaterialSmithingRecipe> {
        @NotNull
        public MapCodec<MaterialSmithingRecipe> codec() {
            return CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, MaterialSmithingRecipe> streamCodec() {
            return ByteBufCodecs.fromCodecWithRegistries((Codec)CODEC.codec());
        }
    }
}

