/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.item;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.RegistryOps;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import smartin.miapi.Miapi;
import smartin.miapi.datapack.ReloadEvents;
import smartin.miapi.item.modular.ModularItem;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.modules.properties.util.ComponentApplyProperty;
import smartin.miapi.registries.RegistryInventory;

public class ModularItemStackConverter {
    public static Map<ItemStack, RegistryOps.RegistryInfoLookup> lookupMap = new WeakHashMap<ItemStack, RegistryOps.RegistryInfoLookup>();
    public static List<ModularConverter> converters = new ArrayList<ModularConverter>();

    public static ItemStack getModularVersion(ItemStack original) {
        if (original.is(RegistryInventory.MIAPI_FORBIDDEN_TAG)) {
            return original;
        }
        if (ReloadEvents.isInReload()) {
            return original;
        }
        ItemStack converted = original.copy();
        if (original.getItem().getDefaultInstance().has(DataComponents.ATTRIBUTE_MODIFIERS)) {
            List oldEntries = ((ItemAttributeModifiers)original.getItem().getDefaultInstance().get(DataComponents.ATTRIBUTE_MODIFIERS)).modifiers();
            converted.update(DataComponents.ATTRIBUTE_MODIFIERS, (Object)ItemAttributeModifiers.EMPTY, old -> new ItemAttributeModifiers(old.modifiers().stream().filter(a -> !oldEntries.contains(a)).toList(), old.showInTooltip()));
        }
        for (ModularConverter converter : converters) {
            try {
                converted = converter.convert(converted);
            }
            catch (RuntimeException e) {
                Miapi.LOGGER.warn("failed to convert item" + String.valueOf(original.getItem()), (Throwable)e);
            }
        }
        if (ModularItem.isModularItem(converted)) {
            ModuleInstance moduleInstance = ItemModule.getModules(converted);
            if (moduleInstance.lookup == null && lookupMap.containsKey(original)) {
                moduleInstance.allSubModules().forEach(m -> {
                    m.lookup = lookupMap.get(original);
                });
            }
            if (Miapi.registryAccess != null) {
                ComponentApplyProperty.updateItemStack(converted, Miapi.registryAccess);
            }
        }
        return converted;
    }

    public static interface ModularConverter {
        public ItemStack convert(ItemStack var1);
    }
}

