/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.item;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.redpxnda.nucleus.pose.client.PoseAnimationResourceListener;
import com.redpxnda.nucleus.pose.server.ServerPoseFacet;
import java.util.Set;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;

public class PoseCommands {
    private static final SuggestionProvider<CommandSourceStack> POSE_SUGGESTIONS = (context, builder) -> {
        Set materialOptions = PoseAnimationResourceListener.animations.keySet();
        materialOptions.forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        return builder.buildFuture();
    };

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder runPose = (LiteralArgumentBuilder)Commands.literal((String)"miapi").then(Commands.literal((String)"pose").then(Commands.literal((String)"run").then(Commands.argument((String)"pose_id", (ArgumentType)ResourceLocationArgument.id()).suggests(POSE_SUGGESTIONS).then(Commands.argument((String)"off_hand", (ArgumentType)BoolArgumentType.bool()).executes(PoseCommands::executePose)))));
        LiteralArgumentBuilder stopPose = (LiteralArgumentBuilder)Commands.literal((String)"miapi").then(Commands.literal((String)"pose").then(Commands.literal((String)"stop").executes(PoseCommands::executePoseStop)));
        dispatcher.register(runPose);
        dispatcher.register(stopPose);
    }

    private static int executePose(CommandContext<CommandSourceStack> context) {
        ServerPoseFacet facet;
        String poseId = ResourceLocationArgument.getId(context, (String)"pose_id").toString();
        boolean offHand = BoolArgumentType.getBool(context, (String)"off_hand");
        if (((CommandSourceStack)context.getSource()).isPlayer() && (facet = (ServerPoseFacet)ServerPoseFacet.KEY.get((Entity)((CommandSourceStack)context.getSource()).getPlayer())) != null) {
            facet.set(poseId, ((CommandSourceStack)context.getSource()).getPlayer(), offHand ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND);
        }
        return 1;
    }

    private static int executePoseStop(CommandContext<CommandSourceStack> context) {
        if (((CommandSourceStack)context.getSource()).isPlayer()) {
            ServerPoseFacet facet = (ServerPoseFacet)ServerPoseFacet.KEY.get((Entity)((CommandSourceStack)context.getSource()).getPlayer());
            facet.reset(((CommandSourceStack)context.getSource()).getPlayer());
        }
        return 1;
    }
}

