/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.item.modular.items;

import com.redpxnda.nucleus.util.Color;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.TooltipFlag;
import org.lwjgl.system.NonnullDefault;
import smartin.miapi.config.MiapiConfig;
import smartin.miapi.item.FakeItemManager;
import smartin.miapi.item.modular.PlatformModularItemMethods;
import smartin.miapi.item.modular.VisualModularItem;
import smartin.miapi.item.modular.items.ModularToolMaterial;
import smartin.miapi.modules.properties.DisplayNameProperty;
import smartin.miapi.modules.properties.LoreProperty;
import smartin.miapi.modules.properties.RepairPriority;

@NonnullDefault
public class BrokenModularVisualOnlyItem
extends TieredItem
implements PlatformModularItemMethods,
VisualModularItem {
    public BrokenModularVisualOnlyItem() {
        super((Tier)new ModularToolMaterial(), new Item.Properties().stacksTo(1).durability(1000));
    }

    public Tier getTier() {
        ItemStack itemStack = FakeItemManager.getDefaultInstance((Item)this);
        if (MiapiConfig.getServerConfig().other.looseToolMaterial && itemStack != null) {
            return ModularToolMaterial.forItemStack(itemStack);
        }
        return super.getTier();
    }

    public boolean isValidRepairItem(ItemStack stack, ItemStack ingredient) {
        return RepairPriority.getRepairValue(stack, ingredient) > 0.0;
    }

    public ItemStack getDefaultInstance() {
        return FakeItemManager.getDefaultInstance((Item)this);
    }

    public int getBarWidth(ItemStack stack) {
        return 0;
    }

    public int getBarColor(ItemStack stack) {
        return Color.RED.argb();
    }

    public Component getName(ItemStack stack) {
        return Component.translatable((String)"miapi.broken_item.name", (Object[])new Object[]{DisplayNameProperty.getDisplayText(stack)});
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext tooltipContext, List<Component> list, TooltipFlag tooltipType) {
        LoreProperty.appendLoreTop(stack, list, tooltipContext, tooltipType);
    }
}

