/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.item.modular.items;

import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.block.Block;
import org.lwjgl.system.NonnullDefault;
import smartin.miapi.item.modular.VisualModularItem;
import smartin.miapi.modules.properties.DurabilityProperty;
import smartin.miapi.modules.properties.RepairPriority;
import smartin.miapi.modules.properties.attributes.AttributeUtil;
import smartin.miapi.modules.properties.enchanment.EnchantAbilityProperty;
import smartin.miapi.modules.properties.mining.MiningLevelProperty;

@NonnullDefault
public class ModularToolMaterial
implements Tier {
    public static ModularToolMaterial toolMaterial = new ModularToolMaterial();

    public int getUses() {
        return 50;
    }

    public float getSpeed() {
        return 5.0f;
    }

    public float getAttackDamageBonus() {
        return 5.0f;
    }

    public TagKey<Block> getIncorrectBlocksForDrops() {
        return BlockTags.INCORRECT_FOR_WOODEN_TOOL;
    }

    public int getEnchantmentValue() {
        return 15;
    }

    public Ingredient getRepairIngredient() {
        return Ingredient.EMPTY;
    }

    public static Tier forItemStack(final ItemStack itemStack) {
        if (itemStack == null || itemStack.isEmpty() || VisualModularItem.isVisualModularItem(itemStack)) {
            return new ModularToolMaterial();
        }
        final AtomicReference<TagKey> getIncorrectBlocksForDrops = new AtomicReference<TagKey>(BlockTags.INCORRECT_FOR_WOODEN_TOOL);
        final double maxSpeed = MiningLevelProperty.property.getData(itemStack).map(data -> {
            double max = 0.0;
            for (MiningLevelProperty.MiningRule rule : data.values()) {
                double current = rule.speed().getValue();
                max = Math.max(max, current);
                if (!rule.useMaterial() || current != max) continue;
                rule.respectMaterialBlacklists().stream().findAny().ifPresent(m -> getIncorrectBlocksForDrops.set(m.getIncorrectBlocksForDrops()));
            }
            return max;
        }).orElse(0.0);
        return new Tier(){

            public int getUses() {
                return DurabilityProperty.property.getValue(itemStack).orElse(50.0).intValue();
            }

            public float getSpeed() {
                return (float)maxSpeed;
            }

            public float getAttackDamageBonus() {
                return (float)AttributeUtil.getActualValue(itemStack, EquipmentSlot.MAINHAND, (Attribute)Attributes.ATTACK_DAMAGE.value());
            }

            public TagKey<Block> getIncorrectBlocksForDrops() {
                return (TagKey)getIncorrectBlocksForDrops.get();
            }

            public int getEnchantmentValue() {
                return (int)EnchantAbilityProperty.getEnchantAbility(itemStack);
            }

            public Ingredient getRepairIngredient() {
                return RepairPriority.getRepairIngredient(itemStack);
            }
        };
    }
}

