/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.item.modular.items.armor;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.lwjgl.system.NonnullDefault;
import smartin.miapi.Miapi;
import smartin.miapi.events.MiapiEvents;
import smartin.miapi.item.FakeItemManager;
import smartin.miapi.item.modular.ModularItem;
import smartin.miapi.item.modular.PlatformModularItemMethods;
import smartin.miapi.modules.properties.DisplayNameProperty;
import smartin.miapi.modules.properties.LoreProperty;
import smartin.miapi.modules.properties.RepairPriority;
import smartin.miapi.modules.properties.enchanment.EnchantAbilityProperty;
import smartin.miapi.modules.properties.mining.MiningLevelProperty;
import smartin.miapi.modules.properties.util.ComponentApplyProperty;
import smartin.miapi.registries.RegistryInventory;

@NonnullDefault
public class ModularBoots
extends ArmorItem
implements PlatformModularItemMethods,
ModularItem {
    public ModularBoots(Item.Properties settings) {
        super(RegistryInventory.armorMaterial, ArmorItem.Type.BOOTS, settings);
    }

    public ModularBoots() {
        super(RegistryInventory.armorMaterial, ArmorItem.Type.BOOTS, new Item.Properties().stacksTo(1).durability(50));
    }

    public void verifyComponentsAfterLoad(ItemStack stack) {
        ComponentApplyProperty.initializeItemStack(stack, Miapi.registryAccess);
        super.verifyComponentsAfterLoad(stack);
    }

    public ItemStack getDefaultInstance() {
        return FakeItemManager.getDefaultInstance((Item)this);
    }

    public Component getName(ItemStack stack) {
        return DisplayNameProperty.getDisplayText(stack);
    }

    public boolean isEnchantable(ItemStack itemStack) {
        return true;
    }

    public boolean isValidRepairItem(ItemStack stack, ItemStack ingredient) {
        return RepairPriority.getRepairValue(stack, ingredient) > 0.0;
    }

    public int getBarWidth(ItemStack stack) {
        return Math.round(13.0f - (float)stack.getDamageValue() * 13.0f / (float)ModularItem.getDurability(stack));
    }

    public int getBarColor(ItemStack stack) {
        float f = Math.max(0.0f, ((float)ModularItem.getDurability(stack) - (float)stack.getDamageValue()) / (float)ModularItem.getDurability(stack));
        return Mth.hsvToRgb((float)(f / 3.0f), (float)1.0f, (float)1.0f);
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        ((MiapiEvents.InventoryTickEvent)MiapiEvents.INVENTORY_TICK.invoker()).tick(stack, level, entity, slotId, isSelected);
        super.inventoryTick(stack, level, entity, slotId, isSelected);
    }

    public int getEnchantmentValue() {
        ItemStack itemStack = FakeItemManager.getLastInstance((Item)this);
        if (itemStack != null) {
            return (int)EnchantAbilityProperty.getEnchantAbility(itemStack);
        }
        return 15;
    }

    public ItemAttributeModifiers getDefaultAttributeModifiers() {
        return ItemAttributeModifiers.EMPTY;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext tooltipContext, List<Component> list, TooltipFlag tooltipType) {
        LoreProperty.appendLoreTop(stack, list, tooltipContext, tooltipType);
        super.appendHoverText(stack, tooltipContext, list, tooltipType);
    }

    public float getDestroySpeed(ItemStack stack, BlockState state) {
        return MiningLevelProperty.getDestroySpeed(stack, state);
    }

    public boolean mineBlock(ItemStack stack, Level level, BlockState state, BlockPos pos, LivingEntity miningEntity) {
        return MiningLevelProperty.mineBlock(stack, level, state, pos, miningEntity);
    }

    public boolean isCorrectToolForDrops(ItemStack stack, BlockState state) {
        return MiningLevelProperty.isCorrectToolForDrops(stack, state);
    }
}

