/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.item.modular.items.bows;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.system.NonnullDefault;
import smartin.miapi.Miapi;
import smartin.miapi.entity.ItemProjectileEntity;
import smartin.miapi.events.MiapiEvents;
import smartin.miapi.item.FakeItemManager;
import smartin.miapi.item.modular.ModularItem;
import smartin.miapi.item.modular.PlatformModularItemMethods;
import smartin.miapi.modules.properties.DisplayNameProperty;
import smartin.miapi.modules.properties.LoreProperty;
import smartin.miapi.modules.properties.enchanment.EnchantAbilityProperty;
import smartin.miapi.modules.properties.mining.MiningLevelProperty;
import smartin.miapi.modules.properties.util.ComponentApplyProperty;

@NonnullDefault
public class ModularArrow
extends ArrowItem
implements PlatformModularItemMethods,
ModularItem {
    public ModularArrow() {
        this(new Item.Properties().stacksTo(64));
    }

    public ModularArrow(Item.Properties settings) {
        super(settings);
    }

    public void verifyComponentsAfterLoad(ItemStack stack) {
        ComponentApplyProperty.initializeItemStack(stack, Miapi.registryAccess);
        super.verifyComponentsAfterLoad(stack);
    }

    public ItemStack getDefaultInstance() {
        return FakeItemManager.getDefaultInstance((Item)this);
    }

    public AbstractArrow createArrow(Level level, ItemStack ammo, @Nullable LivingEntity shooter, @Nullable ItemStack weapon) {
        return new ItemProjectileEntity(level, shooter, ammo.copyWithCount(1), weapon);
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        ((MiapiEvents.InventoryTickEvent)MiapiEvents.INVENTORY_TICK.invoker()).tick(stack, level, entity, slotId, isSelected);
        super.inventoryTick(stack, level, entity, slotId, isSelected);
    }

    public Projectile asProjectile(Level world, Position position, ItemStack stack, Direction direction) {
        ItemStack itemStack = stack.copy();
        itemStack.setCount(1);
        ItemProjectileEntity arrowEntity = new ItemProjectileEntity(world, position, itemStack);
        arrowEntity.setPosRaw(position.x(), position.y(), position.z());
        arrowEntity.pickup = AbstractArrow.Pickup.ALLOWED;
        return arrowEntity;
    }

    public Component getName(ItemStack stack) {
        return DisplayNameProperty.getDisplayText(stack);
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> list, TooltipFlag tooltipType) {
        LoreProperty.appendLoreTop(itemStack, list, tooltipContext, tooltipType);
    }

    public int getEnchantmentValue() {
        ItemStack itemStack = FakeItemManager.getLastInstance((Item)this);
        if (itemStack != null) {
            return (int)EnchantAbilityProperty.getEnchantAbility(itemStack);
        }
        return 15;
    }

    public float getDestroySpeed(ItemStack stack, BlockState state) {
        return MiningLevelProperty.getDestroySpeed(stack, state);
    }

    public boolean mineBlock(ItemStack stack, Level level, BlockState state, BlockPos pos, LivingEntity miningEntity) {
        return MiningLevelProperty.mineBlock(stack, level, state, pos, miningEntity);
    }

    public boolean isCorrectToolForDrops(ItemStack stack, BlockState state) {
        return MiningLevelProperty.isCorrectToolForDrops(stack, state);
    }
}

