/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.item.modular.items.bows;

import java.util.List;
import java.util.function.Predicate;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.lwjgl.system.NonnullDefault;
import smartin.miapi.Environment;
import smartin.miapi.Miapi;
import smartin.miapi.attributes.AttributeRegistry;
import smartin.miapi.client.model.ModularModelPredicateProvider;
import smartin.miapi.events.MiapiEvents;
import smartin.miapi.item.FakeItemManager;
import smartin.miapi.item.modular.ModularItem;
import smartin.miapi.item.modular.PlatformModularItemMethods;
import smartin.miapi.modules.properties.DisplayNameProperty;
import smartin.miapi.modules.properties.LoreProperty;
import smartin.miapi.modules.properties.RepairPriority;
import smartin.miapi.modules.properties.attributes.AttributeUtil;
import smartin.miapi.modules.properties.enchanment.EnchantAbilityProperty;
import smartin.miapi.modules.properties.projectile.DrawTimeProperty;
import smartin.miapi.modules.properties.util.ComponentApplyProperty;

@NonnullDefault
public class ModularBow
extends BowItem
implements PlatformModularItemMethods,
ModularItem {
    public static Predicate<ItemStack> projectile = ARROW_ONLY;

    public ModularBow() {
        super(new Item.Properties().stacksTo(1).durability(50));
        if (Environment.isClient()) {
            this.registerAnimations();
        }
    }

    public ItemStack getDefaultInstance() {
        return FakeItemManager.getDefaultInstance((Item)this);
    }

    public void verifyComponentsAfterLoad(ItemStack stack) {
        ComponentApplyProperty.initializeItemStack(stack, Miapi.registryAccess);
        super.verifyComponentsAfterLoad(stack);
    }

    public int getEnchantmentValue() {
        ItemStack itemStack = FakeItemManager.getLastInstance((Item)this);
        if (itemStack != null) {
            return (int)EnchantAbilityProperty.getEnchantAbility(itemStack);
        }
        return 15;
    }

    public boolean isEnchantable(ItemStack itemStack) {
        return true;
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        ((MiapiEvents.InventoryTickEvent)MiapiEvents.INVENTORY_TICK.invoker()).tick(stack, level, entity, slotId, isSelected);
        super.inventoryTick(stack, level, entity, slotId, isSelected);
    }

    public int getBarWidth(ItemStack stack) {
        return Math.round(13.0f - (float)stack.getDamageValue() * 13.0f / (float)ModularItem.getDurability(stack));
    }

    public int getBarColor(ItemStack stack) {
        float f = Math.max(0.0f, ((float)ModularItem.getDurability(stack) - (float)stack.getDamageValue()) / (float)ModularItem.getDurability(stack));
        return Mth.hsvToRgb((float)(f / 3.0f), (float)1.0f, (float)1.0f);
    }

    public boolean isValidRepairItem(ItemStack stack, ItemStack ingredient) {
        return RepairPriority.getRepairValue(stack, ingredient) > 0.0;
    }

    public Predicate<ItemStack> getAllSupportedProjectiles() {
        return projectile;
    }

    public Component getName(ItemStack stack) {
        return DisplayNameProperty.getDisplayText(stack);
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> list, TooltipFlag tooltipType) {
        LoreProperty.appendLoreTop(itemStack, list, tooltipContext, tooltipType);
    }

    public void releaseUsing(ItemStack stack, Level level, LivingEntity livingEntity, int timeCharged) {
        int i;
        float f;
        Player player;
        ItemStack itemStack;
        if (livingEntity instanceof Player && !(itemStack = (player = (Player)livingEntity).getProjectile(stack)).isEmpty() && !((double)(f = ModularBow.getPowerForTime(i = this.getUseDuration(stack, livingEntity) - timeCharged, stack, livingEntity)) < 0.1)) {
            List list = ModularBow.draw((ItemStack)stack, (ItemStack)itemStack, (LivingEntity)player);
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (!list.isEmpty()) {
                    float divergence = (float)Math.pow(12.0, -AttributeUtil.getActualValue(stack, EquipmentSlot.MAINHAND, (Attribute)AttributeRegistry.PROJECTILE_ACCURACY.value()));
                    float speed = (float)Math.max(0.1, AttributeUtil.getActualValue(stack, EquipmentSlot.MAINHAND, (Attribute)AttributeRegistry.PROJECTILE_SPEED.value()) + 3.0);
                    this.shoot(serverLevel, (LivingEntity)player, player.getUsedItemHand(), stack, list, f * speed, divergence, f == 1.0f, null);
                }
            }
            level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.ARROW_SHOOT, SoundSource.PLAYERS, 1.0f, 1.0f / (level.getRandom().nextFloat() * 0.4f + 1.2f) + f * 0.5f);
            player.awardStat(Stats.ITEM_USED.get((Object)this));
        }
    }

    protected Projectile createProjectile(Level level, LivingEntity shooter, ItemStack weapon, ItemStack ammo, boolean isCrit) {
        Projectile projectile1 = super.createProjectile(level, shooter, weapon, ammo, isCrit);
        return projectile1;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void registerAnimations() {
        ModularModelPredicateProvider.registerModelOverride((Item)this, ResourceLocation.parse((String)"pull"), (stack, world, entity, seed) -> {
            if (entity == null) {
                return 0.0f;
            }
            float power = ModularBow.getPowerForTime(entity.getTicksUsingItem(), stack, entity);
            return entity.getUseItem() != stack ? 0.0f : power;
        });
        ModularModelPredicateProvider.registerModelOverride((Item)this, ResourceLocation.parse((String)"pulling"), (stack, world, entity, seed) -> entity != null && entity.isUsingItem() && entity.getUseItem() == stack ? 1.0f : 0.0f);
    }

    public static float getPowerForTime(int charge, ItemStack itemStack, LivingEntity livingEntity) {
        double drawTime = DrawTimeProperty.property.getValue(itemStack).orElse(0.25);
        float maxLevel = Math.max(1.0f, (float)drawTime * 20.0f);
        float f = (float)charge / maxLevel;
        if ((f = (f * f + f * 2.0f) / 3.0f) > 1.0f) {
            f = 1.0f;
        }
        return f;
    }
}

