/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.item.modular.items.bows;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ChargedProjectiles;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.system.NonnullDefault;
import smartin.miapi.Environment;
import smartin.miapi.Miapi;
import smartin.miapi.attributes.AttributeRegistry;
import smartin.miapi.client.model.ModularModelPredicateProvider;
import smartin.miapi.entity.ItemProjectileEntity;
import smartin.miapi.entity.ProjectileWithBow;
import smartin.miapi.events.MiapiEvents;
import smartin.miapi.events.MiapiProjectileEvents;
import smartin.miapi.item.FakeItemManager;
import smartin.miapi.item.modular.ModularItem;
import smartin.miapi.item.modular.PlatformModularItemMethods;
import smartin.miapi.mixin.item.CrossbowItemAccessor;
import smartin.miapi.modules.properties.DisplayNameProperty;
import smartin.miapi.modules.properties.LoreProperty;
import smartin.miapi.modules.properties.RepairPriority;
import smartin.miapi.modules.properties.attributes.AttributeUtil;
import smartin.miapi.modules.properties.enchanment.EnchantAbilityProperty;
import smartin.miapi.modules.properties.projectile.DrawTimeProperty;
import smartin.miapi.modules.properties.projectile.IsCrossbowShootAble;
import smartin.miapi.modules.properties.util.ComponentApplyProperty;

@NonnullDefault
public class ModularCrossbow
extends CrossbowItem
implements PlatformModularItemMethods,
ModularItem {
    public ModularCrossbow(Item.Properties settings) {
        super(settings.stacksTo(1).durability(50));
        if (Environment.isClient()) {
            this.registerAnimations();
        }
    }

    public ModularCrossbow() {
        super(new Item.Properties().stacksTo(1).durability(50));
        if (Environment.isClient()) {
            this.registerAnimations();
        }
    }

    public ItemStack getDefaultInstance() {
        return FakeItemManager.getDefaultInstance((Item)this);
    }

    public void verifyComponentsAfterLoad(ItemStack stack) {
        ComponentApplyProperty.initializeItemStack(stack, Miapi.registryAccess);
        super.verifyComponentsAfterLoad(stack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void registerAnimations() {
        ModularModelPredicateProvider.registerModelOverride((Item)this, ResourceLocation.parse((String)"pull"), (stack, world, entity, seed) -> {
            if (entity == null) {
                return 0.0f;
            }
            int i = this.getUseDuration(stack, entity) - entity.getTicksUsingItem();
            return entity.getUseItem() != stack ? 0.0f : -ModularCrossbow.getPowerForTime(i, stack, entity);
        });
        ModularModelPredicateProvider.registerModelOverride((Item)this, ResourceLocation.parse((String)"pulling"), (stack, world, entity, seed) -> entity != null && entity.isUsingItem() && entity.getUseItem() == stack ? 1.0f : 0.0f);
        ModularModelPredicateProvider.registerModelOverride((Item)this, ResourceLocation.parse((String)"charged"), (stack, world, entity, seed) -> entity != null && ModularCrossbow.isCharged((ItemStack)stack) ? 1.0f : 0.0f);
    }

    public int getBarWidth(ItemStack stack) {
        return Math.round(13.0f - (float)stack.getDamageValue() * 13.0f / (float)ModularItem.getDurability(stack));
    }

    public int getBarColor(ItemStack stack) {
        float f = Math.max(0.0f, ((float)ModularItem.getDurability(stack) - (float)stack.getDamageValue()) / (float)ModularItem.getDurability(stack));
        return Mth.hsvToRgb((float)(f / 3.0f), (float)1.0f, (float)1.0f);
    }

    public boolean isEnchantable(ItemStack itemStack) {
        return true;
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        ((MiapiEvents.InventoryTickEvent)MiapiEvents.INVENTORY_TICK.invoker()).tick(stack, level, entity, slotId, isSelected);
        super.inventoryTick(stack, level, entity, slotId, isSelected);
    }

    public boolean isValidRepairItem(ItemStack stack, ItemStack ingredient) {
        return RepairPriority.getRepairValue(stack, ingredient) > 0.0;
    }

    public Component getName(ItemStack stack) {
        return DisplayNameProperty.getDisplayText(stack);
    }

    public int getEnchantmentValue() {
        ItemStack itemStack = FakeItemManager.getLastInstance((Item)this);
        if (itemStack != null) {
            return (int)EnchantAbilityProperty.getEnchantAbility(itemStack);
        }
        return 15;
    }

    protected Projectile createProjectile(Level level, LivingEntity shooter, ItemStack weapon, ItemStack ammo, boolean isCrit) {
        Item item;
        if (IsCrossbowShootAble.canCrossbowShoot(ammo) && (item = ammo.getItem()) instanceof ProjectileItem) {
            ProjectileItem projectileItem = (ProjectileItem)item;
            Projectile projectile = super.createProjectile(level, shooter, weapon, ammo, isCrit);
            if (projectile instanceof ItemProjectileEntity) {
                ItemProjectileEntity projectileEntity = (ItemProjectileEntity)projectile;
                projectileEntity.setCritArrow(isCrit);
            }
            ((ProjectileWithBow)projectile).setBowItem(weapon);
            return projectile;
        }
        Projectile projectile1 = super.createProjectile(level, shooter, weapon, ammo, isCrit);
        ((ProjectileWithBow)projectile1).setBowItem(weapon);
        return projectile1;
    }

    protected void shootProjectile(LivingEntity shooter, Projectile projectile, int index, float velocity, float inaccuracy, float angle, @Nullable LivingEntity target) {
        if (index != 0 && projectile instanceof ItemProjectileEntity) {
            ItemProjectileEntity entity = (ItemProjectileEntity)projectile;
            entity.pickup = AbstractArrow.Pickup.CREATIVE_ONLY;
        }
        super.shootProjectile(shooter, projectile, index, velocity, inaccuracy, angle, target);
    }

    public static List<ItemStack> drawPublic(ItemStack weapon, ItemStack ammo, LivingEntity shooter) {
        return ModularCrossbow.draw((ItemStack)weapon, (ItemStack)ammo, (LivingEntity)shooter);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        ItemStack crossbow = player.getItemInHand(usedHand);
        ChargedProjectiles chargedProjectiles = (ChargedProjectiles)crossbow.get(DataComponents.CHARGED_PROJECTILES);
        if (chargedProjectiles != null && !chargedProjectiles.isEmpty()) {
            float divergence = (float)Math.pow(12.0, -AttributeUtil.getActualValue(crossbow, EquipmentSlot.MAINHAND, (Attribute)AttributeRegistry.PROJECTILE_ACCURACY.value()));
            float speed = (float)Math.max(0.1, AttributeUtil.getActualValue(crossbow, EquipmentSlot.MAINHAND, (Attribute)AttributeRegistry.PROJECTILE_SPEED.value()) + (double)ModularCrossbow.getShootingPower(chargedProjectiles));
            if (((MiapiProjectileEvents.CrossbowContext)MiapiProjectileEvents.MODULAR_CROSSBOW_PRE_SHOT.invoker()).shoot((LivingEntity)player, crossbow).interruptsFurtherEvaluation()) {
                return InteractionResultHolder.consume((Object)crossbow);
            }
            this.performShooting(level, (LivingEntity)player, usedHand, crossbow, speed, divergence, null);
            if (((MiapiProjectileEvents.CrossbowContext)MiapiProjectileEvents.MODULAR_CROSSBOW_POST_SHOT.invoker()).shoot((LivingEntity)player, crossbow).interruptsFurtherEvaluation()) {
                return InteractionResultHolder.consume((Object)crossbow);
            }
            return InteractionResultHolder.consume((Object)crossbow);
        }
        if (!player.getProjectile(crossbow).isEmpty()) {
            ((CrossbowItemAccessor)((Object)this)).setStartSoundPlayed(false);
            ((CrossbowItemAccessor)((Object)this)).setMidLoadSoundPlayed(false);
            player.startUsingItem(usedHand);
            return InteractionResultHolder.consume((Object)crossbow);
        }
        return InteractionResultHolder.fail((Object)crossbow);
    }

    public void releaseUsing(ItemStack stack, Level level, LivingEntity livingEntity, int timeCharged) {
        int ticks = this.getUseDuration(stack, livingEntity) - timeCharged;
        float charge = ModularCrossbow.getPowerForTime(ticks, stack, livingEntity);
        MiapiProjectileEvents.CrossbowLoadingContext context = new MiapiProjectileEvents.CrossbowLoadingContext(livingEntity, stack, livingEntity.getProjectile(stack), EquipmentSlot.MAINHAND);
        if (charge >= 1.0f && !ModularCrossbow.isCharged((ItemStack)stack) && !((MiapiProjectileEvents.CrossbowContextEvent)MiapiProjectileEvents.MODULAR_CROSSBOW_PRE_LOAD.invoker()).load(context).interruptsFurtherEvaluation() && CrossbowItemAccessor.callTryLoadProjectiles(livingEntity, stack)) {
            if (((MiapiProjectileEvents.CrossbowContextEvent)MiapiProjectileEvents.MODULAR_CROSSBOW_POST_LOAD.invoker()).load(context).interruptsFurtherEvaluation()) {
                return;
            }
            CrossbowItem.ChargingSounds chargingSounds = ((CrossbowItemAccessor)((Object)this)).callGetChargingSounds(stack);
            chargingSounds.end().ifPresent(holder -> level.playSound((Player)null, livingEntity.getX(), livingEntity.getY(), livingEntity.getZ(), (SoundEvent)holder.value(), livingEntity.getSoundSource(), 1.0f, 1.0f / (level.getRandom().nextFloat() * 0.5f + 1.0f) + 0.2f));
        }
    }

    public Predicate<ItemStack> getAllSupportedProjectiles() {
        return super.getAllSupportedProjectiles().or(IsCrossbowShootAble::canCrossbowShoot);
    }

    private static float getPowerForTime(int timeLeft, ItemStack stack, LivingEntity shooter) {
        float f = (float)timeLeft / (float)ModularCrossbow.getChargeDuration(stack, shooter);
        if (f > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    public static int getChargeDuration(ItemStack stack, LivingEntity shooter) {
        double drawTime = DrawTimeProperty.property.getValue(stack).orElse(0.25);
        float f = EnchantmentHelper.modifyCrossbowChargingTime((ItemStack)stack, (LivingEntity)shooter, (float)((float)drawTime));
        return Mth.floor((float)(f * 20.0f));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        ChargedProjectiles chargedProjectiles = (ChargedProjectiles)stack.get(DataComponents.CHARGED_PROJECTILES);
        LoreProperty.appendLoreTop(stack, tooltipComponents, context, tooltipFlag);
        if (chargedProjectiles != null && !chargedProjectiles.isEmpty()) {
            ItemStack itemStack = (ItemStack)chargedProjectiles.getItems().getFirst();
            tooltipComponents.add((Component)Component.translatable((String)"item.minecraft.crossbow.projectile").append(CommonComponents.SPACE).append(itemStack.getDisplayName()));
            if (tooltipFlag.isAdvanced() && itemStack.is(Items.FIREWORK_ROCKET)) {
                ArrayList list = Lists.newArrayList();
                Items.FIREWORK_ROCKET.appendHoverText(itemStack, context, (List)list, tooltipFlag);
                if (!list.isEmpty()) {
                    for (int i = 0; i < list.size(); ++i) {
                        list.set(i, Component.literal((String)"  ").append((Component)list.get(i)).withStyle(ChatFormatting.GRAY));
                    }
                    tooltipComponents.addAll(list);
                }
            }
        }
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    private static float getShootingPower(ChargedProjectiles projectile) {
        return projectile.contains(Items.FIREWORK_ROCKET) ? 1.6f : 3.15f;
    }
}

