/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.item.modular.items.shield;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.commons.lang3.mutable.MutableFloat;
import org.lwjgl.system.NonnullDefault;
import smartin.miapi.Miapi;
import smartin.miapi.events.MeleeModularAttackEvents;
import smartin.miapi.events.MiapiEvents;
import smartin.miapi.item.FakeItemManager;
import smartin.miapi.item.modular.ModularItem;
import smartin.miapi.modules.abilities.util.ItemAbilityManager;
import smartin.miapi.modules.properties.DisplayNameProperty;
import smartin.miapi.modules.properties.LoreProperty;
import smartin.miapi.modules.properties.RepairPriority;
import smartin.miapi.modules.properties.enchanment.EnchantAbilityProperty;
import smartin.miapi.modules.properties.mining.MiningLevelProperty;
import smartin.miapi.modules.properties.util.ComponentApplyProperty;

@NonnullDefault
public class ModularNonVanillaShield
extends Item
implements ModularItem {
    public ModularNonVanillaShield() {
        this(new Item.Properties().stacksTo(1).durability(500).rarity(Rarity.COMMON));
    }

    public ModularNonVanillaShield(Item.Properties properties) {
        super(properties);
    }

    public void verifyComponentsAfterLoad(ItemStack stack) {
        ComponentApplyProperty.initializeItemStack(stack, Miapi.registryAccess);
        super.verifyComponentsAfterLoad(stack);
    }

    public ItemStack getDefaultInstance() {
        return FakeItemManager.getDefaultInstance(this);
    }

    public float getAttackDamageBonus(Entity target, float damage, DamageSource damageSource) {
        MutableFloat mutableFloat = new MutableFloat(0.0f);
        if (damageSource.getWeaponItem() != null) {
            ((MeleeModularAttackEvents.GetAttackDamageBonus)MeleeModularAttackEvents.ATTACK_DAMAGE_BONUS.invoker()).getAttackDamageBonus(target, damageSource.getWeaponItem(), damage, damageSource, mutableFloat);
        }
        return mutableFloat.floatValue();
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        return ((MeleeModularAttackEvents.HurtEnemy)MeleeModularAttackEvents.HURT_ENEMY.invoker()).hurtEnemy(stack, target, attacker).interruptsFurtherEvaluation();
    }

    public void postHurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        ((MeleeModularAttackEvents.HurtEnemy)MeleeModularAttackEvents.HURT_ENEMY_POST.invoker()).hurtEnemy(stack, target, attacker);
    }

    public int getBarWidth(ItemStack stack) {
        return Math.round(13.0f - (float)stack.getDamageValue() * 13.0f / (float)ModularItem.getDurability(stack));
    }

    public int getBarColor(ItemStack stack) {
        float f = Math.max(0.0f, ((float)ModularItem.getDurability(stack) - (float)stack.getDamageValue()) / (float)ModularItem.getDurability(stack));
        return Mth.hsvToRgb((float)(f / 3.0f), (float)1.0f, (float)1.0f);
    }

    public boolean isEnchantable(ItemStack itemStack) {
        return true;
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        ((MiapiEvents.InventoryTickEvent)MiapiEvents.INVENTORY_TICK.invoker()).tick(stack, level, entity, slotId, isSelected);
        super.inventoryTick(stack, level, entity, slotId, isSelected);
    }

    public boolean isValidRepairItem(ItemStack stack, ItemStack ingredient) {
        return RepairPriority.getRepairValue(stack, ingredient) > 0.0;
    }

    public Component getName(ItemStack stack) {
        return DisplayNameProperty.getDisplayText(stack);
    }

    public int getEnchantmentValue() {
        ItemStack itemStack = FakeItemManager.getLastInstance(this);
        if (itemStack != null) {
            return (int)EnchantAbilityProperty.getEnchantAbility(itemStack);
        }
        return 15;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return ItemAbilityManager.getUseAction(stack, () -> super.getUseAnimation(stack));
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return ItemAbilityManager.getMaxUseTime(stack, entity, () -> super.getUseDuration(stack, entity));
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        return ItemAbilityManager.use(world, user, hand, () -> super.use(world, user, hand));
    }

    public void releaseUsing(ItemStack stack, Level world, LivingEntity user, int remainingUseTicks) {
        ItemAbilityManager.onStoppedUsing(stack, world, user, remainingUseTicks, () -> super.releaseUsing(stack, world, user, remainingUseTicks));
    }

    public ItemStack finishUsingItem(ItemStack stack, Level world, LivingEntity user) {
        return ItemAbilityManager.finishUsing(stack, world, user, () -> super.finishUsingItem(stack, world, user));
    }

    public void onUseTick(Level world, LivingEntity user, ItemStack stack, int remainingUseTicks) {
        ItemAbilityManager.usageTick(world, user, stack, remainingUseTicks, () -> super.onUseTick(world, user, stack, remainingUseTicks));
    }

    public boolean useOnRelease(ItemStack stack) {
        return ItemAbilityManager.useOnRelease(stack, () -> super.useOnRelease(stack));
    }

    public InteractionResult interactLivingEntity(ItemStack stack, Player user, LivingEntity entity, InteractionHand hand) {
        return ItemAbilityManager.useOnEntity(stack, user, entity, hand, () -> super.interactLivingEntity(stack, user, entity, hand));
    }

    public InteractionResult useOn(UseOnContext context) {
        return ItemAbilityManager.useOnBlock(context, () -> super.useOn(context));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext tooltipContext, List<Component> list, TooltipFlag tooltipType) {
        LoreProperty.appendLoreTop(stack, list, tooltipContext, tooltipType);
        super.appendHoverText(stack, tooltipContext, list, tooltipType);
    }

    public float getDestroySpeed(ItemStack stack, BlockState state) {
        return MiningLevelProperty.getDestroySpeed(stack, state);
    }

    public boolean mineBlock(ItemStack stack, Level level, BlockState state, BlockPos pos, LivingEntity miningEntity) {
        return MiningLevelProperty.mineBlock(stack, level, state, pos, miningEntity);
    }

    public boolean isCorrectToolForDrops(ItemStack stack, BlockState state) {
        return MiningLevelProperty.isCorrectToolForDrops(stack, state);
    }
}

