/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.item.modular.items.shield;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.codec.ByteBufCodecs;

public class TowerShieldComponent {
    public static Codec<TowerShieldComponent> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.intRange((int)0, (int)255).fieldOf("blocks").forGetter(component -> component.blockCount), (App)Codec.LONG.fieldOf("last_active_tick").forGetter(component -> component.lastTickActive)).apply((Applicative)instance, (blocks, tick) -> {
        TowerShieldComponent component = new TowerShieldComponent(0L);
        component.blockCount = blocks;
        return component;
    }));
    public static DataComponentType<TowerShieldComponent> TOWER_SHIELD_COMPONENT = DataComponentType.builder().persistent(CODEC).networkSynchronized(ByteBufCodecs.fromCodec(CODEC)).build();
    public int blockCount;
    public long lastTickActive;

    public TowerShieldComponent(long lastTickActive) {
        this.lastTickActive = lastTickActive;
    }

    public void update(long lastTickActiveTick, int cooldown) {
        long tick = this.lastTickActive - lastTickActiveTick;
        int countReduction = (int)Math.floor((double)((int)tick) / (double)cooldown);
        this.blockCount = Math.max(0, this.blockCount - countReduction);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TowerShieldComponent that = (TowerShieldComponent)o;
        return this.blockCount == that.blockCount && this.lastTickActive == that.lastTickActive;
    }

    public int hashCode() {
        return Objects.hash(this.blockCount, this.lastTickActive);
    }
}

