/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.loot;

import com.redpxnda.nucleus.codec.auto.AutoCodec;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import smartin.miapi.Miapi;
import smartin.miapi.modules.properties.mining.AutoSmeltProperty;
import smartin.miapi.registries.RegistryInventory;

public class AutoSmeltFunction
implements LootItemFunction {
    public static AutoCodec<AutoSmeltFunction> CODEC = AutoCodec.of(AutoSmeltFunction.class);

    public LootItemFunctionType<? extends LootItemFunction> getType() {
        return RegistryInventory.autoSmeltFunctionLootItemFunctionType;
    }

    public ItemStack apply(ItemStack itemStack, LootContext lootContext) {
        if (lootContext.hasParam(LootContextParams.TOOL) && AutoSmeltProperty.property.hasValue((ItemStack)lootContext.getParam(LootContextParams.TOOL))) {
            ItemStack smeltStack;
            if (itemStack.isEmpty()) {
                return itemStack;
            }
            Optional optional = lootContext.getLevel().getRecipeManager().getRecipeFor(RecipeType.SMELTING, (RecipeInput)new SingleRecipeInput(itemStack), (Level)lootContext.getLevel());
            if (optional.isPresent() && !(smeltStack = ((RecipeHolder)optional.get()).value().getResultItem((HolderLookup.Provider)lootContext.getLevel().registryAccess())).isEmpty()) {
                return smeltStack.copyWithCount(smeltStack.getCount());
            }
            Miapi.LOGGER.warn("Couldn't smelt {} because there is no smelting recipe", (Object)itemStack);
            return itemStack;
        }
        return itemStack;
    }
}

