/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.loot;

import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import org.jetbrains.annotations.NotNull;
import smartin.miapi.Miapi;
import smartin.miapi.item.ModularItemStackConverter;
import smartin.miapi.item.modular.ModularItem;
import smartin.miapi.item.modular.VisualModularItem;
import smartin.miapi.material.AllowedMaterial;
import smartin.miapi.material.MaterialProperty;
import smartin.miapi.material.base.Material;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.modules.properties.AllowedInLootProperty;
import smartin.miapi.modules.properties.ItemIdProperty;
import smartin.miapi.modules.properties.slot.SlotProperty;
import smartin.miapi.registries.RegistryInventory;

public record ModuleSwapLootFunction(ResourceLocation material, double chance, Optional<List<ResourceLocation>> blacklist, Optional<List<ResourceLocation>> whitelist, boolean allowStackable) implements LootItemFunction
{
    public static MapCodec<ModuleSwapLootFunction> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceLocation.CODEC.optionalFieldOf("material", (Object)Miapi.id("empty")).forGetter(c -> c.material), (App)Codec.DOUBLE.fieldOf("chance").orElse((Object)1.0).forGetter(c -> c.chance), (App)Codec.list((Codec)ResourceLocation.CODEC).optionalFieldOf("blacklist").forGetter(c -> c.blacklist), (App)Codec.list((Codec)ResourceLocation.CODEC).optionalFieldOf("whitelist").forGetter(c -> c.whitelist), (App)Codec.BOOL.optionalFieldOf("allow_stackable", (Object)false).forGetter(c -> c.allowStackable())).apply((Applicative)instance, ModuleSwapLootFunction::new));

    @NotNull
    public LootItemFunctionType<? extends LootItemFunction> getType() {
        return RegistryInventory.moduleSwapLootFunctionLootItemFunctionType;
    }

    public ItemStack apply(ItemStack stack, LootContext lootContext) {
        ItemStack modular = ModularItemStackConverter.getModularVersion(stack);
        if (ModularItem.isModularItem(modular)) {
            if (modular.isStackable() && !this.allowStackable()) {
                return stack;
            }
            ModuleInstance root = ItemModule.getModules(modular);
            if (VisualModularItem.isVisualModularItem(stack)) {
                return stack;
            }
            Material highestMaterial = MaterialProperty.getMaterial(root);
            for (ModuleInstance module : root.allSubModules()) {
                Material otherMaterial = MaterialProperty.getMaterial(module);
                if (highestMaterial == null) {
                    highestMaterial = otherMaterial;
                    continue;
                }
                if (otherMaterial == null || !this.isHigher(highestMaterial, otherMaterial)) continue;
                highestMaterial = otherMaterial;
            }
            if (this.material != null) {
                Material fromJson = MaterialProperty.MATERIAL_REGISTRY.get(this.material);
                if (highestMaterial == null || fromJson != null && this.isHigher(highestMaterial, fromJson)) {
                    highestMaterial = fromJson;
                }
            }
            root = this.randomizeModuleAndChildren(root, highestMaterial, lootContext.getRandom());
            root.writeToItem(modular);
            modular = ItemIdProperty.changeId(modular);
        }
        return modular;
    }

    ModuleInstance randomizeModuleAndChildren(ModuleInstance moduleInstance, Material fallBackMaterial, RandomSource randomSource) {
        if ((double)randomSource.nextFloat() <= this.chance()) {
            try {
                moduleInstance = this.findPossibleSubstitute(moduleInstance, randomSource);
            }
            catch (RuntimeException e) {
                Miapi.LOGGER.error("could not randomize module", (Throwable)e);
            }
        }
        LinkedHashMap<String, ModuleInstance> submodules = new LinkedHashMap<String, ModuleInstance>(moduleInstance.getSubModuleMap());
        for (Map.Entry entry : submodules.entrySet()) {
            moduleInstance.setSubModule((String)entry.getKey(), this.randomizeModuleAndChildren((ModuleInstance)entry.getValue(), fallBackMaterial, randomSource));
            moduleInstance.clearCaches();
        }
        return moduleInstance;
    }

    ModuleInstance findPossibleSubstitute(ModuleInstance module, RandomSource randomSource) {
        List<ItemModule> possibleSubstitutes = RegistryInventory.ITEM_MODULE_MIAPI_REGISTRY.getFlatMap().values().stream().filter(m -> {
            if (this.whitelist().isPresent() && !this.whitelist().get().contains(m.id())) {
                return false;
            }
            if (this.blacklist().isPresent() && this.blacklist().get().contains(m.id())) {
                return false;
            }
            if (!(AllowedInLootProperty.property.isTrue((ItemModule)m) || this.whitelist().isPresent() && this.whitelist().get().contains(m.id()))) {
                return false;
            }
            Map<String, SlotProperty.ModuleSlot> testSlots = SlotProperty.getSlots(module);
            LinkedHashMap slots = new LinkedHashMap(SlotProperty.getInstance().getData((ItemModule)m).orElse(new LinkedHashMap()));
            for (String key : testSlots.keySet()) {
                if (!slots.containsKey(key)) {
                    return false;
                }
                ModuleInstance subModule = module.getSubModule(key);
                if (subModule == null || ((SlotProperty.ModuleSlot)slots.get(key)).allowedIn(subModule)) continue;
                return false;
            }
            SlotProperty.ModuleSlot parentSlot = SlotProperty.getSlotIn(module);
            if (parentSlot != null && !parentSlot.allowedIn((ItemModule)m)) {
                return false;
            }
            Material material1 = MaterialProperty.getMaterial(module);
            Optional data = AllowedMaterial.property.getData((ItemModule)m);
            if (material1 != null) {
                if (data.isEmpty()) {
                    return false;
                }
                if (!((AllowedMaterial.AllowedMaterialData)data.get()).isValid(material1)) {
                    return false;
                }
            }
            return true;
        }).toList();
        if (possibleSubstitutes.isEmpty()) {
            return module;
        }
        int randomIndex = randomSource.nextInt(possibleSubstitutes.size());
        ModuleInstance moduleInstance = new ModuleInstance(possibleSubstitutes.get(randomIndex));
        moduleInstance.moduleData = new HashMap<ResourceLocation, JsonElement>(module.moduleData);
        module.subModules.forEach(moduleInstance::setSubModule);
        moduleInstance.clearCaches();
        return moduleInstance;
    }

    public boolean isHigher(Material material, Material other) {
        int otherMiningLevel;
        int roughMiningLevel = this.getTagSize(material.getIncorrectBlocksForDrops());
        if (roughMiningLevel != (otherMiningLevel = this.getTagSize(other.getIncorrectBlocksForDrops()))) {
            return otherMiningLevel < roughMiningLevel;
        }
        double tierDiff = this.isHigher(material, other, "tier", false);
        if (tierDiff != 0.0) {
            return tierDiff > 0.0;
        }
        double hardness = this.isHigher(material, other, "hardness", true);
        if (hardness != 0.0) {
            return hardness > 0.5;
        }
        double flexibility = this.isHigher(material, other, "flexibility", true);
        if (flexibility != 0.0) {
            return flexibility > 1.0;
        }
        return false;
    }

    public double isHigher(Material material, Material other, String stat, boolean canBeZero) {
        double materialHardness = material.getDouble(stat);
        double otherMaterialHardness = other.getDouble(stat);
        if (!canBeZero ? materialHardness != otherMaterialHardness && materialHardness != 0.0 && otherMaterialHardness != 0.0 : materialHardness != otherMaterialHardness) {
            return materialHardness - otherMaterialHardness;
        }
        return 0.0;
    }

    public int getTagSize(TagKey<Block> tag) {
        return BuiltInRegistries.BLOCK.getTag(tag).map(holders -> (int)holders.stream().count()).orElse(0);
    }
}

