/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.material;

import com.google.gson.JsonElement;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec2;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import smartin.miapi.Miapi;
import smartin.miapi.blocks.ModularWorkBenchEntity;
import smartin.miapi.blueprint.BlueprintComponent;
import smartin.miapi.client.gui.InteractAbleWidget;
import smartin.miapi.client.gui.crafting.crafter.replace.MaterialCraftingWidget;
import smartin.miapi.craft.CraftAction;
import smartin.miapi.craft.MaterialCraftInfo;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.modules.properties.render.ServerReplaceProperty;
import smartin.miapi.modules.properties.util.CraftingProperty;

public class BlueprintCrafting
extends ServerReplaceProperty
implements CraftingProperty {
    public static ResourceLocation KEY = Miapi.id("runtime_blueprint_property");
    double materialCostClient = 0.0;
    double materialRequirementClient = 0.0;
    int slotHeight = 19;

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public InteractAbleWidget createGui(int x, int y, int width, int height, CraftAction craftAction) {
        BlueprintComponent blueprintComponent = BlueprintComponent.getBlueprint(craftAction.data, craftAction.screenHandler);
        if (blueprintComponent != null && !blueprintComponent.useMaterialCrafting()) {
            return new MaterialCraftingWidget(new MaterialCraftInfo(){

                @Override
                public int getSlotHeight() {
                    return BlueprintCrafting.this.slotHeight;
                }

                @Override
                public void setSlotHeight(int newHeight) {
                    BlueprintCrafting.this.slotHeight = newHeight;
                }

                @Override
                public double getMaterialCostClient() {
                    return BlueprintCrafting.this.materialCostClient;
                }

                @Override
                public double getMaterialRequirementClient() {
                    return BlueprintCrafting.this.materialRequirementClient;
                }

                @Override
                public boolean renderMaterialWidget() {
                    return false;
                }
            }, x, y, width, height, craftAction);
        }
        return null;
    }

    @Override
    public List<Vec2> getSlotPositions() {
        return List.of(new Vec2(96.0f, (float)(this.slotHeight - 12)));
    }

    @Override
    public boolean shouldExecuteOnCraft(@Nullable ModuleInstance module, ModuleInstance root, ItemStack stack, CraftAction craftAction) {
        BlueprintComponent blueprintComponent = BlueprintComponent.getBlueprint(craftAction.data, craftAction.screenHandler);
        return blueprintComponent != null;
    }

    @Override
    public float getPriority() {
        return -10.0f;
    }

    @Override
    public boolean canPerform(ItemStack old, ItemStack crafting, @Nullable ModularWorkBenchEntity bench, Player player, CraftAction craftAction, ItemModule module, List<ItemStack> inventory, Map<ResourceLocation, JsonElement> data) {
        BlueprintComponent blueprintComponent = BlueprintComponent.getBlueprint(craftAction.data, craftAction.screenHandler);
        if (blueprintComponent != null) {
            if (blueprintComponent.useMaterialCrafting()) {
                return true;
            }
            ItemStack input = inventory.getFirst();
            this.materialRequirementClient = blueprintComponent.getCost();
            this.materialCostClient = 0.0;
            if (blueprintComponent.isValidCorrectType(input, blueprintComponent.retrieve(craftAction.screenHandler))) {
                this.materialCostClient = input.getCount();
                return blueprintComponent.isValid(input, blueprintComponent.retrieve(craftAction.screenHandler));
            }
            return false;
        }
        return true;
    }

    @Override
    public ItemStack preview(ItemStack old, ItemStack crafting, Player player, ModularWorkBenchEntity bench, CraftAction craftAction, ItemModule module, List<ItemStack> inventory, Map<ResourceLocation, JsonElement> data) {
        ModuleInstance moduleInstance;
        BlueprintComponent blueprintComponent = BlueprintComponent.getBlueprint(craftAction.data, craftAction.screenHandler);
        if (blueprintComponent != null && (moduleInstance = craftAction.getModifyingModuleInstance(crafting)) != null) {
            blueprintComponent.apply(moduleInstance);
            moduleInstance.getRoot().writeToItem(crafting);
        }
        return crafting;
    }

    @Override
    public List<ItemStack> performCraftAction(ItemStack old, ItemStack crafting, Player player, @Nullable ModularWorkBenchEntity bench, CraftAction craftAction, ItemModule module, List<ItemStack> inventory, Map<ResourceLocation, JsonElement> data) {
        List<ItemStack> result = CraftingProperty.super.performCraftAction(old, crafting, player, bench, craftAction, module, inventory, data);
        BlueprintComponent blueprintComponent = BlueprintComponent.getBlueprint(craftAction.data, craftAction.screenHandler);
        if (blueprintComponent != null && !blueprintComponent.useMaterialCrafting()) {
            result.set(1, blueprintComponent.adjustCost(inventory.getFirst()));
        }
        return result;
    }
}

