/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.material;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mojang.serialization.codecs.UnboundedMapCodec;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.block.Block;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import smartin.miapi.Environment;
import smartin.miapi.Miapi;
import smartin.miapi.blueprint.IngredientWithCount;
import smartin.miapi.events.MiapiEvents;
import smartin.miapi.item.modular.StatResolver;
import smartin.miapi.material.MaterialIcons;
import smartin.miapi.material.MaterialVariant;
import smartin.miapi.material.base.IngredientController;
import smartin.miapi.material.base.Material;
import smartin.miapi.material.base.PropertyController;
import smartin.miapi.material.palette.FallbackColorer;
import smartin.miapi.material.palette.MaterialRenderController;
import smartin.miapi.material.palette.MaterialRenderControllers;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.ModuleDataPropertiesManager;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.modules.conditions.ConditionManager;
import smartin.miapi.modules.properties.render.ColorProperty;
import smartin.miapi.modules.properties.util.MergeType;
import smartin.miapi.modules.properties.util.ModuleProperty;

public class CodecMaterial
implements Material {
    ResourceLocation id;
    public Optional<JsonElement> iconJson;
    Optional<JsonElement> paletteJson;
    Optional<JsonElement> dyePaletteJson;
    Map<String, Map<ModuleProperty<?>, Object>> mergedAllAppliedProperties = new HashMap();
    Map<String, Map<ModuleProperty<?>, Object>> mergedAllVisualProperties = new HashMap();
    Map<String, Map<ModuleProperty<?>, Object>> normalProperties = new HashMap();
    Map<String, Map<ModuleProperty<?>, Object>> displayProperties = new HashMap();
    Map<String, Map<ModuleProperty<?>, Object>> hiddenProperties = new HashMap();
    public List<String> groups;
    List<String> guiGroups;
    public List<String> textureKeys;
    Optional<TagKey<Block>> incorrectForTool = Optional.empty();
    Optional<Integer> color = Optional.empty();
    public List<IngredientWithCount> items;
    public Map<String, String> stringData = new HashMap<String, String>();
    public Map<String, Double> doubleMap = new HashMap<String, Double>();
    public Optional<Component> translation = Optional.empty();
    @OnlyIn(value=Dist.CLIENT)
    public MaterialIcons.MaterialIcon icon;
    @OnlyIn(value=Dist.CLIENT)
    protected MaterialRenderController palette;
    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    protected MaterialRenderController dyeAblePalette;
    public Either<Boolean, List<Holder<Item>>> toGenerate = Either.left((Object)false);
    public List<MaterialVariant> variants = new ArrayList<MaterialVariant>();
    public static final Codec<CodecMaterial> CODEC = new Codec<CodecMaterial>(){

        public <T> DataResult<Pair<CodecMaterial, T>> decode(DynamicOps<T> ops, T input) {
            HashMap<String, String> stringData = new HashMap<String, String>();
            HashMap<String, Double> doubleMap = new HashMap<String, Double>();
            try {
                ((JsonElement)ops.convertTo((DynamicOps)JsonOps.INSTANCE, input)).getAsJsonObject().asMap().forEach((key, element) -> {
                    if (element.isJsonPrimitive()) {
                        try {
                            stringData.put((String)key, element.getAsString());
                        }
                        catch (Exception e) {
                            Miapi.LOGGER.debug("Failed to read '{}' as string: {}", key, (Object)e.getMessage());
                        }
                        try {
                            doubleMap.put((String)key, element.getAsDouble());
                        }
                        catch (Exception e) {
                            Miapi.LOGGER.debug("Failed to read '{}' as double: {}", key, (Object)e.getMessage());
                        }
                    }
                });
            }
            catch (Exception e) {
                Miapi.LOGGER.error("Error converting input during decode: {}", input, (Object)e);
                return DataResult.error(() -> "Failed to parse input: " + e.getMessage());
            }
            DataResult dataResult = INNER_CODEC.decode(ops, input);
            if (dataResult.isSuccess()) {
                try {
                    ((CodecMaterial)((Pair)dataResult.getOrThrow()).getFirst()).setData(stringData, doubleMap);
                }
                catch (Exception e) {
                    Miapi.LOGGER.error("Failed to attach parsed data to CodecMaterial", (Throwable)e);
                    return DataResult.error(() -> "Failed to attach parsed data: " + e.getMessage());
                }
            } else {
                Miapi.LOGGER.warn("INNER_CODEC failed to decode input: {}", input);
                Miapi.LOGGER.warn(((DataResult.Error)dataResult.error().get()).message());
            }
            return dataResult;
        }

        public <T> DataResult<T> encode(CodecMaterial input, DynamicOps<T> ops, T prefix) {
            UnboundedMapCodec stringCodec = Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.STRING);
            prefix = stringCodec.encode(input.stringData, ops, prefix).result().get();
            UnboundedMapCodec doubleCodec = Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.DOUBLE);
            prefix = doubleCodec.encode(input.doubleMap, ops, prefix).result().get();
            return INNER_CODEC.encode((Object)input, ops, prefix);
        }
    };
    public static final Codec<CodecMaterial> INNER_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)StatResolver.Codecs.JSONELEMENT_CODEC.optionalFieldOf("icon").forGetter(material -> material.iconJson), (App)StatResolver.Codecs.JSONELEMENT_CODEC.optionalFieldOf("color_palette").forGetter(material -> material.paletteJson), (App)StatResolver.Codecs.JSONELEMENT_CODEC.optionalFieldOf("dye_color_palette").forGetter(material -> material.dyePaletteJson), (App)Codec.STRING.listOf().optionalFieldOf("groups", new ArrayList()).forGetter(m -> m.getGroups().stream().filter(g -> m.getGuiGroups().contains(g)).toList()), (App)Codec.STRING.listOf().optionalFieldOf("hidden_groups", new ArrayList()).forGetter(m -> m.getGroups().stream().filter(g -> !m.getGuiGroups().contains(g)).toList()), (App)Codec.STRING.listOf().optionalFieldOf("gui_groups", new ArrayList()).forGetter(m -> m.getGuiGroups().stream().filter(g -> !m.getGroups().contains(g)).toList()), (App)Codec.unboundedMap((Codec)Codec.STRING, StatResolver.Codecs.JSONELEMENT_CODEC).optionalFieldOf("properties", new HashMap()).forGetter(m -> PropertyController.toJsonMap(m.normalProperties)), (App)Codec.unboundedMap((Codec)Codec.STRING, StatResolver.Codecs.JSONELEMENT_CODEC).optionalFieldOf("display_properties", new HashMap()).forGetter(m -> PropertyController.toJsonMap(m.displayProperties)), (App)Codec.unboundedMap((Codec)Codec.STRING, StatResolver.Codecs.JSONELEMENT_CODEC).optionalFieldOf("hidden_properties", new HashMap()).forGetter(m -> PropertyController.toJsonMap(m.hiddenProperties)), (App)Codec.STRING.listOf().optionalFieldOf("textures", List.of("default")).forGetter(CodecMaterial::getTextureKeys), (App)ResourceLocation.CODEC.optionalFieldOf("mining_level").forGetter(material -> Optional.of(material.getIncorrectBlocksForDrops().location())), (App)ComponentSerialization.CODEC.optionalFieldOf("translation").forGetter(material -> material.translation), (App)Codec.STRING.optionalFieldOf("color").forGetter(m -> Optional.of(Long.toHexString((long)m.getColor(new ModuleInstance(ItemModule.empty)) & 0xFFFFFFFFFFFFFFFFL))), (App)IngredientWithCount.CODEC.listOf().optionalFieldOf("items", new ArrayList()).forGetter(material -> material.items), (App)Codec.either(Miapi.FIXED_BOOL_CODEC, (Codec)ItemStack.ITEM_NON_AIR_CODEC.listOf()).optionalFieldOf("generate_converters", (Object)Either.left((Object)false)).forGetter(m -> m.toGenerate), (App)MaterialVariant.CODEC.listOf().optionalFieldOf("variants", new ArrayList()).forGetter(m -> m.variants)).apply((Applicative)instance, CodecMaterial::new));
    private static List<TieredItem> tieredItems;
    private static List<ArmorItem> armorItems;
    @OnlyIn(value=Dist.CLIENT)
    public FallbackColorer fallbackColorer;

    public CodecMaterial(Optional<JsonElement> iconJson, Optional<JsonElement> paletteJson, Optional<JsonElement> dyePaletteJson, List<String> groups, List<String> hiddenGroups, List<String> guiGroups, Map<String, JsonElement> property, Map<String, JsonElement> visualProperty, Map<String, JsonElement> hiddenProperty, List<String> textureKeys, Optional<ResourceLocation> incorrectForToolId, Optional<Component> translation, Optional<String> color, List<IngredientWithCount> items, Either<Boolean, List<Holder<Item>>> generateConverters, List<MaterialVariant> variants) {
        this.variants = variants;
        this.iconJson = iconJson;
        this.paletteJson = paletteJson;
        this.dyePaletteJson = dyePaletteJson;
        this.groups = new ArrayList<String>(groups);
        this.guiGroups = new ArrayList<String>(guiGroups);
        this.guiGroups.addAll(groups);
        this.groups.addAll(hiddenGroups);
        this.textureKeys = textureKeys;
        this.translation = translation;
        if (incorrectForToolId.isPresent()) {
            Optional<Pair> found = BuiltInRegistries.BLOCK.getTags().filter(pair -> ((TagKey)pair.getFirst()).location().equals(incorrectForToolId.get())).findAny();
            found.ifPresent(tagKeyNamedPair -> {
                this.incorrectForTool = Optional.of((TagKey)tagKeyNamedPair.getFirst());
            });
        }
        if (color.isPresent()) {
            try {
                long longValue = Long.parseLong(color.get(), 16);
                this.color = Optional.of((int)(longValue & 0xFFFFFFFFL));
            }
            catch (RuntimeException e) {
                Miapi.LOGGER.info("failed color decoding");
            }
        }
        this.items = items;
        this.toGenerate = generateConverters;
        hiddenProperty.forEach((type, json) -> {
            Map<ModuleProperty<?>, Object> data = ModuleDataPropertiesManager.resolvePropertiesFromJson(json);
            this.mergedAllAppliedProperties.put((String)type, data);
            this.hiddenProperties.put((String)type, data);
        });
        property.forEach((type, json) -> {
            Map<ModuleProperty<?>, Object> data = ModuleDataPropertiesManager.resolvePropertiesFromJson(json);
            this.mergedAllAppliedProperties.put((String)type, data);
            this.mergedAllVisualProperties.put((String)type, data);
            this.normalProperties.put((String)type, data);
        });
        visualProperty.forEach((type, json) -> {
            Map<ModuleProperty<?>, Object> data = ModuleDataPropertiesManager.resolvePropertiesFromJson(json);
            this.mergedAllVisualProperties.put((String)type, data);
            this.displayProperties.put((String)type, data);
        });
        if (Environment.isClient()) {
            this.clientSetup(iconJson, paletteJson, dyePaletteJson);
        }
    }

    public void setup() {
        if (Environment.isClient()) {
            this.clientSetup(this.iconJson, this.paletteJson, this.dyePaletteJson);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void clientSetup(Optional<JsonElement> iconJson, Optional<JsonElement> paletteJson, Optional<JsonElement> dyePaletteJson) {
        if (iconJson.isPresent()) {
            JsonPrimitive primitive;
            JsonElement jsonElement = iconJson.get();
            this.icon = jsonElement instanceof JsonPrimitive && (primitive = (JsonPrimitive)jsonElement).isString() ? new MaterialIcons.TextureMaterialIcon(ResourceLocation.parse((String)primitive.getAsString())) : MaterialIcons.getMaterialIcon(this.id, iconJson.get());
        }
        if (paletteJson.isPresent()) {
            this.palette = MaterialRenderControllers.creators.get(paletteJson.get().getAsJsonObject().get("type").getAsString()).createPalette(paletteJson.get(), this);
            if (this.color.isEmpty()) {
                this.color = Optional.of(this.palette.getAverageColor().argb());
            }
        }
        dyePaletteJson.ifPresent(element -> {
            this.dyeAblePalette = MaterialRenderControllers.creators.get(element.getAsJsonObject().get("type").getAsString()).createPalette((JsonElement)element, this);
        });
    }

    public CodecMaterial copy() {
        CodecMaterial copy = new CodecMaterial(this.iconJson, this.paletteJson, this.dyePaletteJson, new ArrayList<String>(this.groups), List.of(), new ArrayList<String>(this.guiGroups), PropertyController.toJsonMap(this.normalProperties), PropertyController.toJsonMap(this.hiddenProperties), PropertyController.toJsonMap(this.displayProperties), new ArrayList<String>(this.textureKeys), this.incorrectForTool.map(TagKey::location), this.translation, this.color.map(Integer::toHexString), new ArrayList<IngredientWithCount>(this.items), this.toGenerate, new ArrayList<MaterialVariant>(this.variants));
        copy.id = this.id;
        copy.stringData = new HashMap<String, String>(this.stringData);
        copy.doubleMap = new HashMap<String, Double>(this.doubleMap);
        copy.mergedAllAppliedProperties = new HashMap(this.mergedAllAppliedProperties);
        copy.mergedAllVisualProperties = new HashMap(this.mergedAllVisualProperties);
        copy.incorrectForTool = this.incorrectForTool;
        copy.translation = this.translation;
        copy.iconJson = this.iconJson;
        copy.paletteJson = this.paletteJson;
        copy.dyePaletteJson = this.dyePaletteJson;
        if (Environment.isClient()) {
            this.copyClient(copy);
        }
        return copy;
    }

    @OnlyIn(value=Dist.CLIENT)
    private void copyClient(CodecMaterial copy) {
        if (this.iconJson.isPresent()) {
            JsonPrimitive primitive;
            JsonElement jsonElement = this.iconJson.get();
            copy.icon = jsonElement instanceof JsonPrimitive && (primitive = (JsonPrimitive)jsonElement).isString() ? new MaterialIcons.TextureMaterialIcon(ResourceLocation.parse((String)primitive.getAsString())) : MaterialIcons.getMaterialIcon(this.id, this.iconJson.get());
        }
        if (copy.paletteJson.isPresent()) {
            copy.palette = MaterialRenderControllers.creators.get(copy.paletteJson.get().getAsJsonObject().get("type").getAsString()).createPalette(copy.paletteJson.get(), this);
            if (copy.color.isEmpty()) {
                copy.color = Optional.of(this.palette.getAverageColor().argb());
            }
        }
        if (copy.dyePaletteJson.isPresent()) {
            copy.dyeAblePalette = MaterialRenderControllers.creators.get(copy.dyePaletteJson.get().getAsJsonObject().get("type").getAsString()).createPalette(copy.dyePaletteJson.get(), this);
            if (copy.color.isEmpty()) {
                copy.color = Optional.of(this.dyeAblePalette.getAverageColor().argb());
            }
        }
    }

    public void merge(CodecMaterial material) {
        if (material.iconJson.isPresent()) {
            this.iconJson = material.iconJson;
        }
        if (material.paletteJson.isPresent()) {
            this.paletteJson = material.paletteJson;
            this.palette = MaterialRenderControllers.creators.get(this.paletteJson.get().getAsJsonObject().get("type").getAsString()).createPalette(this.paletteJson.get(), this);
        }
        if (material.dyePaletteJson.isPresent()) {
            this.dyePaletteJson = material.paletteJson;
            this.dyeAblePalette = MaterialRenderControllers.creators.get(this.dyePaletteJson.get().getAsJsonObject().get("type").getAsString()).createPalette(this.dyePaletteJson.get(), this);
        }
        this.groups = new ArrayList<String>(this.groups);
        this.groups.addAll(material.groups);
        this.guiGroups = new ArrayList<String>(this.guiGroups);
        this.guiGroups.addAll(material.guiGroups);
        CodecMaterial.mergeProperties(material.mergedAllAppliedProperties, this.mergedAllAppliedProperties);
        CodecMaterial.mergeProperties(material.mergedAllVisualProperties, this.mergedAllVisualProperties);
        this.textureKeys = new ArrayList<String>(this.textureKeys);
        this.textureKeys.addAll(material.textureKeys);
        material.incorrectForTool.ifPresent(tagKey -> {
            this.incorrectForTool = Optional.of(tagKey);
        });
        if (material.color.isPresent()) {
            this.color = material.color;
        }
        this.items = new ArrayList<IngredientWithCount>(this.items);
        this.items.addAll(material.items);
        this.toGenerate = material.toGenerate;
        this.stringData.putAll(material.stringData);
        this.doubleMap.putAll(material.doubleMap);
        material.translation.ifPresent(value -> {
            this.translation = Optional.of(value);
        });
        if (Environment.isClient()) {
            this.mergeClient(material);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void mergeClient(CodecMaterial material) {
        if (material.icon != null) {
            this.icon = material.icon;
        }
        if (material.palette != null) {
            this.palette = material.palette;
        }
        this.dyeAblePalette = material.dyeAblePalette;
    }

    private static void mergeProperties(Map<String, Map<ModuleProperty<?>, Object>> source, Map<String, Map<ModuleProperty<?>, Object>> target) {
        source.forEach((key, sourceProperties) -> {
            Map targetProperties = target.getOrDefault(key, new HashMap());
            sourceProperties.forEach((property, sourceValue) -> {
                if (targetProperties.containsKey(property)) {
                    Object targetValue = targetProperties.get(property);
                    targetProperties.put(property, ItemModule.merge(property, targetValue, sourceValue, MergeType.SMART));
                } else {
                    targetProperties.put(property, sourceValue);
                }
            });
            target.put((String)key, targetProperties);
        });
    }

    public void setID(ResourceLocation id) {
        this.id = id;
        ArrayList<String> g = new ArrayList<String>(this.groups);
        g.addFirst(this.getStringID());
        this.groups = g;
        this.guiGroups = new ArrayList<String>(this.guiGroups);
    }

    public void setData(Map<String, String> stringData, Map<String, Double> doubleMap) {
        this.stringData = stringData;
        this.doubleMap = doubleMap;
    }

    @Override
    public double getDouble(String property) {
        return this.doubleMap.getOrDefault(property, 0.0);
    }

    @Override
    public String getData(String property) {
        return this.stringData.getOrDefault(property, "");
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public int renderIcon(GuiGraphics drawContext, int x, int y) {
        if (this.icon == null) {
            return 0;
        }
        return this.icon.render(drawContext, x, y);
    }

    @Override
    public void addSmithingGroup() {
        if (!this.groups.contains("smithing")) {
            this.groups = new ArrayList<String>(this.groups);
            this.groups.add("smithing");
        }
        if (!this.guiGroups.contains("smithing")) {
            this.guiGroups = new ArrayList<String>(this.guiGroups);
            this.guiGroups.add("smithing");
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean hasIcon() {
        return this.icon != null;
    }

    @Override
    public ResourceLocation getID() {
        return this.id;
    }

    @Override
    public List<String> getGroups() {
        return this.groups;
    }

    @Override
    public List<String> getGuiGroups() {
        return this.guiGroups;
    }

    @Override
    public Map<ModuleProperty<?>, Object> materialProperties(String key) {
        return this.mergedAllAppliedProperties.getOrDefault(key, new HashMap());
    }

    @Override
    public Map<ModuleProperty<?>, Object> getDisplayMaterialProperties(String key) {
        return this.mergedAllVisualProperties.getOrDefault(key, new HashMap());
    }

    @Override
    public List<String> getAllPropertyKeys() {
        return new ArrayList<String>(this.mergedAllAppliedProperties.keySet());
    }

    @Override
    public List<String> getAllDisplayPropertyKeys() {
        return new ArrayList<String>(this.mergedAllVisualProperties.keySet());
    }

    @Override
    public List<String> getTextureKeys() {
        return this.textureKeys;
    }

    private static List<TieredItem> getTieredItems() {
        if (tieredItems == null) {
            tieredItems = BuiltInRegistries.ITEM.stream().filter(TieredItem.class::isInstance).map(i -> (TieredItem)i).toList();
        }
        return tieredItems;
    }

    private static List<ArmorItem> getArmorItems() {
        if (armorItems == null) {
            armorItems = BuiltInRegistries.ITEM.stream().filter(ArmorItem.class::isInstance).map(i -> (ArmorItem)i).toList();
        }
        return armorItems;
    }

    public void generateConverters(boolean isClient) {
        if (this.toGenerate.left().isPresent()) {
            if (((Boolean)this.toGenerate.left().get()).booleanValue()) {
                ArrayList<TieredItem> matchedTiered = null;
                ArrayList<ArmorItem> matchedArmor = null;
                for (TieredItem tieredItem : CodecMaterial.getTieredItems()) {
                    if (this.getPriorityOfIngredientItem(tieredItem.getDefaultInstance()) == null) continue;
                    if (matchedTiered == null) {
                        matchedTiered = new ArrayList<TieredItem>();
                    }
                    matchedTiered.add(tieredItem);
                }
                for (ArmorItem armorItem : CodecMaterial.getArmorItems()) {
                    if (this.getPriorityOfIngredientItem(armorItem.getDefaultInstance()) == null) continue;
                    if (matchedArmor == null) {
                        matchedArmor = new ArrayList<ArmorItem>();
                    }
                    matchedArmor.add(armorItem);
                }
                if (matchedTiered != null && !matchedTiered.isEmpty() || matchedArmor != null && !matchedArmor.isEmpty()) {
                    ((MiapiEvents.CreateMaterialModularConvertersEvent)MiapiEvents.GENERATE_MATERIAL_CONVERTERS.invoker()).generated(this, matchedTiered != null ? matchedTiered : List.of(), matchedArmor != null ? matchedArmor : List.of(), isClient);
                }
            }
        } else {
            List<Item> items = ((List)this.toGenerate.right().get()).stream().map(Holder::value).toList();
            ((MiapiEvents.CreateMaterialModularConvertersEvent)MiapiEvents.GENERATE_MATERIAL_CONVERTERS.invoker()).generated(this, items.stream().filter(TieredItem.class::isInstance).map(i -> (TieredItem)i).toList(), items.stream().filter(ArmorItem.class::isInstance).map(i -> (ArmorItem)i).toList(), isClient);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public int getColor(ModuleInstance context) {
        return this.color.orElse(Color.BLACK.getRGB());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public MaterialRenderController getRenderController(ModuleInstance context, ItemDisplayContext mode) {
        if (context.contextStack != null && this.dyeAblePalette != null && ColorProperty.hasColor(context.contextStack, context)) {
            return this.dyeAblePalette;
        }
        if (this.palette == null) {
            if (this.fallbackColorer == null) {
                this.fallbackColorer = new FallbackColorer(this);
            }
            return this.fallbackColorer;
        }
        return this.palette;
    }

    @Override
    public boolean canBeDyed() {
        return this.dyePaletteJson.isPresent();
    }

    @Override
    public double getValueOfItem(ItemStack item) {
        if (this.items == null) {
            return 0.0;
        }
        for (IngredientWithCount value : this.items) {
            if (!value.ingredient.test(item)) continue;
            return value.count;
        }
        return 0.0;
    }

    @Override
    public Double getPriorityOfIngredientItem(ItemStack item) {
        if (this.items == null) {
            return null;
        }
        for (IngredientWithCount value : this.items) {
            if (!value.ingredient.test(item)) continue;
            return value.count;
        }
        return null;
    }

    @Override
    public Ingredient getRepairIngredient() {
        return IngredientController.mergeIngredients(this.items.stream().map(ingredientWithCount -> ingredientWithCount.ingredient));
    }

    @Override
    public JsonObject getDebugJson() {
        return ((JsonElement)CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this).getOrThrow()).getAsJsonObject();
    }

    @Override
    public TagKey<Block> getIncorrectBlocksForDrops() {
        return this.incorrectForTool.orElse((TagKey<Block>)BlockTags.INCORRECT_FOR_WOODEN_TOOL);
    }

    @Override
    public Material getMaterial(ModuleInstance moduleInstance, Map<ModuleProperty<?>, Object> properties) {
        ConditionManager.ConditionContext context = ConditionManager.moduleContext(moduleInstance, properties);
        for (MaterialVariant variant : this.variants) {
            if (!variant.condition().isAllowed(context)) continue;
            CodecMaterial material = this.copy();
            material.setID(this.getID());
            material.merge(variant.overwrite());
            material.setID(this.getID());
            material.setup();
            return material;
        }
        return this;
    }

    public int hashCode() {
        return this.getID().hashCode() + 13 * this.variants.size();
    }

    @Override
    public Component getTranslation() {
        return this.translation.orElseGet(() -> Component.translatable((String)("miapi.material." + this.getStringID())));
    }
}

