/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.material;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.architectury.event.EventResult;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import smartin.miapi.Environment;
import smartin.miapi.Miapi;
import smartin.miapi.datapack.ReloadEvents;
import smartin.miapi.events.MiapiEvents;
import smartin.miapi.item.modular.StatResolver;
import smartin.miapi.material.JsonMaterial;
import smartin.miapi.material.MaterialProperty;
import smartin.miapi.material.base.Material;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.modules.properties.util.ModuleProperty;

public class ComponentMaterial
extends JsonMaterial {
    public static ResourceLocation KEY = Miapi.id("component_runtime_material");
    public JsonObject overWrite;
    public Material parent;
    public double cost = 1.0;
    public static MapCodec<ComponentMaterial> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.DOUBLE.optionalFieldOf("cost", (Object)1.0).forGetter(material -> material.cost), (App)StatResolver.Codecs.JSONELEMENT_CODEC.optionalFieldOf("overwrite", (Object)new JsonObject()).forGetter(material -> material.overWrite), (App)ResourceLocation.CODEC.fieldOf("parent").forGetter(material -> material.parent.getID())).apply((Applicative)instance, (cost, json, materialKey) -> {
        Material material = MaterialProperty.MATERIAL_REGISTRY.get((ResourceLocation)materialKey);
        return new ComponentMaterial(material, (JsonElement)json, (double)cost, Environment.isClient());
    }));
    public static DataComponentType<ComponentMaterial> NBT_MATERIAL_COMPONENT = DataComponentType.builder().persistent(CODEC.codec()).networkSynchronized(ByteBufCodecs.fromCodec((Codec)CODEC.codec())).build();

    public ComponentMaterial(Material parent, JsonElement overwrite, double cost, boolean isClient) {
        super(KEY, parent.getDebugJson().deepCopy(), isClient);
        while (parent instanceof ComponentMaterial) {
            ComponentMaterial componentMaterial = (ComponentMaterial)parent;
            parent = componentMaterial.parent;
        }
        this.parent = parent;
        this.overWrite = overwrite.getAsJsonObject();
        this.mergeJson(overwrite, isClient);
        this.cost = cost;
    }

    public ComponentMaterial(Material parent, JsonObject overwrite, boolean isClient) {
        super(KEY, parent.getDebugJson().deepCopy(), isClient);
        while (parent instanceof ComponentMaterial) {
            ComponentMaterial componentMaterial = (ComponentMaterial)parent;
            parent = componentMaterial.parent;
        }
        this.parent = parent;
        this.overWrite = overwrite;
        this.mergeJson((JsonElement)overwrite, isClient);
    }

    @Override
    public void mergeJson(JsonElement rootElement, boolean isClient) {
        JsonObject object;
        if (rootElement.isJsonObject() && (object = rootElement.getAsJsonObject()).has("cost")) {
            this.cost = object.get("cost").getAsDouble();
        }
        super.mergeJson(rootElement, isClient);
    }

    @Override
    public Component getTranslation() {
        if (this.parent == null) {
            return super.getTranslation();
        }
        return this.parent.getTranslation();
    }

    @Override
    public ResourceLocation getID() {
        return KEY;
    }

    public static void setup() {
        ReloadEvents.MAIN.subscribe((isClient, registryAccess) -> {
            JsonObject object = new JsonObject();
            MaterialProperty.MATERIAL_REGISTRY.register(KEY, (Material)new ComponentMaterial(new JsonMaterial(KEY, object, isClient), new JsonObject(), isClient));
        }, -1.0f);
        MiapiEvents.MATERIAL_CRAFT_EVENT.register(data -> {
            Material patt0$temp = data.material;
            if (patt0$temp instanceof ComponentMaterial) {
                ComponentMaterial componentMaterial = (ComponentMaterial)patt0$temp;
                componentMaterial.writeMaterial(data.moduleInstance);
                data.moduleInstance.getRoot().writeToItem(data.crafted);
            }
            return EventResult.pass();
        });
    }

    @Override
    public Material getMaterial(ModuleInstance moduleInstance, Map<ModuleProperty<?>, Object> properties) {
        return this;
    }

    public void writeMaterial(ModuleInstance moduleInstance) {
    }

    @Override
    public Optional<MapCodec<? extends Material>> codec() {
        return Optional.of(CODEC);
    }

    @Override
    @Nullable
    public Material getMaterialFromIngredient(ItemStack ingredient) {
        return (Material)ingredient.getComponents().get(NBT_MATERIAL_COMPONENT);
    }

    public Optional<Material> decode(JsonObject object) {
        try {
            String parentID = object.get("parent").getAsString();
            Material parentMaterial = MaterialProperty.MATERIAL_REGISTRY.get(ResourceLocation.parse((String)parentID));
            if (parentMaterial == null) {
                Miapi.LOGGER.error("Could not find Material:" + parentID);
                return Optional.empty();
            }
            return Optional.of(new ComponentMaterial(parentMaterial, object, Environment.isClient()));
        }
        catch (Exception e) {
            Miapi.LOGGER.error("Could not find Material", (Throwable)e);
            return Optional.empty();
        }
    }

    @Override
    public double getValueOfItem(ItemStack itemStack) {
        ComponentMaterial material = (ComponentMaterial)itemStack.getComponents().get(NBT_MATERIAL_COMPONENT);
        if (material != null) {
            return material.cost;
        }
        return 0.0;
    }

    @Override
    public Double getPriorityOfIngredientItem(ItemStack itemStack) {
        if (itemStack.getComponents().has(NBT_MATERIAL_COMPONENT)) {
            return -5.0;
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ComponentMaterial other = (ComponentMaterial)obj;
        return Double.compare(other.cost, this.cost) == 0 && Objects.equals(this.overWrite, other.overWrite) && (this.parent == other.parent || this.parent != null && other.parent != null && Objects.equals(this.parent.getID(), other.parent.getID()));
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.overWrite, this.parent != null ? this.parent.getID() : null, this.cost);
    }
}

