/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.material;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.serialization.Codec;
import com.redpxnda.nucleus.codec.auto.AutoCodec;
import com.redpxnda.nucleus.codec.behavior.CodecBehavior;
import com.redpxnda.nucleus.codec.misc.MiscCodecs;
import com.redpxnda.nucleus.codec.misc.PolyCodec;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Matrix4f;
import org.joml.Quaternionf;

public class MaterialIcons {
    public static final Map<String, MaterialIconCreator> iconCreators = new HashMap<String, MaterialIconCreator>();
    public static MaterialIconCreator textureIconCreator;

    public static MaterialIcon getMaterialIcon(ResourceLocation materialKey, JsonElement element) {
        return iconCreators.get(element.getAsJsonObject().get("type").getAsString()).create(element, materialKey);
    }

    public static void setup() {
        textureIconCreator = (element, mat) -> {
            JsonPrimitive primitive;
            if (!(element instanceof JsonObject)) {
                throw new RuntimeException("JSON data for the icon of the '" + String.valueOf(mat) + "' material is not a JSON object! -> " + String.valueOf(element));
            }
            JsonObject object = (JsonObject)element;
            JsonElement patt0$temp = object.get("path");
            if (!(patt0$temp instanceof JsonPrimitive) || !(primitive = (JsonPrimitive)patt0$temp).isString()) {
                throw new RuntimeException("'path' field for the icon of the '" + String.valueOf(mat) + "' material is either missing, or not a string! -> " + String.valueOf(element));
            }
            return new TextureMaterialIcon(ResourceLocation.parse((String)primitive.getAsString()));
        };
        iconCreators.put("texture", textureIconCreator);
        Codec byItem = BuiltInRegistries.ITEM.byNameCodec().xmap(Item::getDefaultInstance, ItemStack::getItem);
        iconCreators.put("item", (element, mat) -> {
            int n;
            if (!(element instanceof JsonObject)) {
                throw new RuntimeException("JSON data for the icon of the '" + String.valueOf(mat) + "' material is not a JSON object! -> " + String.valueOf(element));
            }
            JsonObject object = (JsonObject)element;
            if (!object.has("item")) {
                throw new RuntimeException("'item' field for the icon of the '" + String.valueOf(mat) + "' material is missing! -> " + String.valueOf(element));
            }
            ItemStack stack = (ItemStack)MiscCodecs.quickParse((JsonElement)object.get("item"), (Codec)PolyCodec.of((Codec[])new Codec[]{byItem, ItemStack.CODEC}), s -> new RuntimeException("Failed to parse item for the icon of the '" + String.valueOf(mat) + "' material! -> " + s));
            JsonElement patt0$temp = object.get("offset");
            if (patt0$temp instanceof JsonPrimitive) {
                JsonPrimitive prim = (JsonPrimitive)patt0$temp;
                n = prim.getAsInt();
            } else {
                n = 16;
            }
            int offset = n;
            SpinSettings spin = object.has("spin") ? (SpinSettings)MiscCodecs.quickParse((JsonElement)object.get("spin"), SpinSettings.CODEC, s -> new RuntimeException("Failed to parse spin settings for item icon of the '" + String.valueOf(mat) + "' material! -> " + s)) : null;
            return new ItemMaterialIcon(stack, offset, spin);
        });
        iconCreators.put("entity", (element, materialKey) -> {
            EntityIconHolder holder = (EntityIconHolder)MiscCodecs.quickParse((JsonElement)element, EntityIconHolder.codec, s -> new RuntimeException("Failed to parse entity icon for the '" + String.valueOf(materialKey) + "' material! -> " + s));
            return new EntityMaterialIcon(holder);
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void renderRotatingItem(GuiGraphics context, ItemStack stack, int x, int y, int z, SpinSettings spin) {
        if (stack.isEmpty()) {
            return;
        }
        ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
        BakedModel bakedModel = itemRenderer.getModel(stack, (Level)Minecraft.getInstance().level, (LivingEntity)Minecraft.getInstance().player, 0);
        context.pose().pushPose();
        context.pose().translate((float)(x + 8), (float)(y + 8), (float)(150 + (bakedModel.isGui3d() ? z : 0)));
        boolean bl = !bakedModel.usesBlockLight();
        context.pose().mulPose(new Matrix4f().scaling(1.0f, -1.0f, 1.0f));
        context.pose().scale(16.0f, 16.0f, 16.0f);
        spin.multiplyMatrices(context.pose());
        if (bl) {
            Lighting.setupForFlatItems();
        }
        itemRenderer.render(stack, ItemDisplayContext.GUI, false, context.pose(), (MultiBufferSource)context.bufferSource(), 0xF000F0, OverlayTexture.NO_OVERLAY, bakedModel);
        context.flush();
        if (bl) {
            Lighting.setupFor3DItems();
        }
        context.pose().popPose();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void renderRotatingEntity(GuiGraphics context, int x, int y, int z, EntityIconHolder holder) {
        if (holder.actual == null) {
            holder.actual = holder.entity.create((Level)Minecraft.getInstance().level);
        }
        EntityRenderDispatcher renderer = Minecraft.getInstance().getEntityRenderDispatcher();
        context.pose().pushPose();
        context.pose().translate((float)(x + 8) + holder.x, (float)(y + 16) - holder.y, (float)(150 + z));
        context.pose().mulPose(new Matrix4f().scaling(1.0f, -1.0f, 1.0f));
        context.pose().scale(16.0f, 16.0f, 16.0f);
        context.pose().scale(holder.scale, holder.scale, holder.scale);
        if (holder.spin != null) {
            holder.spin.multiplyMatrices(context.pose());
        }
        renderer.render(holder.actual, 0.0, 0.0, 0.0, 0.0f, 0.0f, context.pose(), (MultiBufferSource)Minecraft.getInstance().renderBuffers().bufferSource(), 0xF000F0);
        context.flush();
        context.pose().popPose();
    }

    public static interface MaterialIconCreator {
        public MaterialIcon create(JsonElement var1, ResourceLocation var2);
    }

    public static interface MaterialIcon {
        @OnlyIn(value=Dist.CLIENT)
        public int render(GuiGraphics var1, int var2, int var3);
    }

    @CodecBehavior.Override(value="codec")
    @AutoCodec.Settings(defaultOptionalBehavior=@CodecBehavior.Optional)
    public static class SpinSettings {
        public static final Codec<SpinSettings> CODEC = AutoCodec.of(SpinSettings.class).codec();
        public boolean x = false;
        public boolean y = true;
        public boolean z = false;
        public int originX = 0;
        public int originY = 0;
        public int originZ = 0;
        public float speed = 1.0f;

        public void multiplyMatrices(PoseStack matrices) {
            float amount = (float)Util.getMillis() * (1.745E-4f * this.speed);
            matrices.rotateAround(new Quaternionf().rotationXYZ(this.x ? amount : 0.0f, this.y ? amount : 0.0f, this.z ? amount : 0.0f), (float)this.originX, (float)this.originY, (float)this.originZ);
        }
    }

    public static class EntityIconHolder {
        public static final Codec<EntityIconHolder> codec = AutoCodec.of(EntityIconHolder.class).codec();
        @AutoCodec.Ignored
        public Entity actual = null;
        public EntityType<?> entity;
        @CodecBehavior.Optional
        public int offset = 16;
        @CodecBehavior.Optional
        public float x = 0.0f;
        @CodecBehavior.Optional
        public float y = 0.0f;
        @CodecBehavior.Optional
        public float scale = 0.85f;
        @CodecBehavior.Optional
        public SpinSettings spin = null;
    }

    public record EntityMaterialIcon(EntityIconHolder holder) implements MaterialIcon
    {
        @Override
        @OnlyIn(value=Dist.CLIENT)
        public int render(GuiGraphics context, int x, int y) {
            MaterialIcons.renderRotatingEntity(context, x, y, 0, this.holder);
            return this.holder.offset;
        }
    }

    public record ItemMaterialIcon(ItemStack item, int offset, SpinSettings spin) implements MaterialIcon
    {
        @Override
        @OnlyIn(value=Dist.CLIENT)
        public int render(GuiGraphics context, int x, int y) {
            if (this.spin != null) {
                MaterialIcons.renderRotatingItem(context, this.item, x, y, 0, this.spin);
            } else {
                context.renderItem(this.item, x, y);
            }
            return this.offset;
        }
    }

    public record TextureMaterialIcon(ResourceLocation texture) implements MaterialIcon
    {
        @Override
        @OnlyIn(value=Dist.CLIENT)
        public int render(GuiGraphics context, int x, int y) {
            context.blit(this.texture, x, y, 0.0f, 0.0f, 16, 16, 16, 16);
            return 16;
        }
    }
}

