/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.material;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.MapCodec;
import io.netty.handler.codec.DecoderException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import smartin.miapi.Miapi;
import smartin.miapi.datapack.ReloadEvents;
import smartin.miapi.item.modular.StatResolver;
import smartin.miapi.material.CodecMaterial;
import smartin.miapi.material.CopyParentMaterialProperty;
import smartin.miapi.material.MaterialOverwriteProperty;
import smartin.miapi.material.base.Material;
import smartin.miapi.mixin.NamedAccessor;
import smartin.miapi.modules.ModuleDataPropertiesManager;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.modules.cache.ModularItemCache;
import smartin.miapi.modules.properties.util.CodecProperty;
import smartin.miapi.modules.properties.util.MergeAble;
import smartin.miapi.modules.properties.util.MergeType;
import smartin.miapi.modules.properties.util.ModuleProperty;
import smartin.miapi.registries.MiapiRegistry;
import smartin.miapi.registries.RegistryInventory;

public class MaterialProperty
extends CodecProperty<ResourceLocation> {
    public static final ResourceLocation KEY = Miapi.id("material");
    public static ModuleProperty property;
    public static MiapiRegistry<Material> MATERIAL_REGISTRY;
    public static Codec<Material> MATERIAL_CODEC;

    public MaterialProperty() {
        super(ResourceLocation.CODEC);
        property = this;
        StatResolver.registerResolver("material", new StatResolver.Resolver(this){

            @Override
            public double resolveDouble(String data, ModuleInstance instance) {
                try {
                    Material material = MaterialProperty.getMaterial(instance);
                    if (material != null) {
                        return material.getDouble(data);
                    }
                }
                catch (Exception exception) {
                    Miapi.LOGGER.warn("Error during Material Resolve", (Throwable)exception);
                }
                return 0.0;
            }

            @Override
            public String resolveString(String data, ModuleInstance instance) {
                try {
                    Material material = MaterialProperty.getMaterial(instance);
                    if (material != null) {
                        return material.getData(data);
                    }
                }
                catch (Exception exception) {
                    Miapi.LOGGER.warn("Error during Material Resolve", (Throwable)exception);
                }
                return "";
            }
        });
        ReloadEvents.END.subscribe((isClient, registryAccess) -> {
            if (isClient) {
                Minecraft.getInstance().execute(() -> RenderSystem.assertOnRenderThread());
            }
        }, 1.0f);
        ReloadEvents.END.subscribe((isClient, registryAccess) -> {
            HolderSet.Named named = BuiltInRegistries.ITEM.getOrCreateTag(RegistryInventory.MIAPI_MATERIALS);
            if (named instanceof NamedAccessor) {
                NamedAccessor namedAccessor = (NamedAccessor)named;
                MATERIAL_REGISTRY.getFlatMap().forEach((id, material) -> {});
                namedAccessor.callBind(List.of());
            }
            Miapi.LOGGER.info("Loaded " + MATERIAL_REGISTRY.getFlatMap().size() + " Materials");
        });
        ModularItemCache.MODULE_CACHE_SUPPLIER.put(KEY.toString(), MaterialProperty::getMaterialRaw);
    }

    public static void loadMaterialExtention(ResourceLocation path, String data, RegistryAccess registryAccess) {
        try {
            JsonParser parser = new JsonParser();
            JsonObject obj = parser.parse(data).getAsJsonObject();
            String idString = obj.get("key").getAsString();
            Material material = MATERIAL_REGISTRY.get(Miapi.id(idString));
            if (material != null && material instanceof CodecMaterial) {
                CodecMaterial codecMaterial = (CodecMaterial)material;
                CodecMaterial toMerge = (CodecMaterial)((Pair)CodecMaterial.CODEC.decode((DynamicOps)RegistryOps.create((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)registryAccess), (Object)obj).getOrThrow(s -> new DecoderException("Could not decode Material Extention " + s))).getFirst();
                codecMaterial.merge(toMerge);
            } else {
                Miapi.LOGGER.error("Miapi could not find Material for Material extension " + idString + " " + String.valueOf(path));
            }
        }
        catch (RuntimeException e) {
            Miapi.LOGGER.error("Miapi could not find Material for Material extension " + String.valueOf(path), (Throwable)e);
        }
    }

    @Override
    public ResourceLocation merge(ResourceLocation left, ResourceLocation right, MergeType mergeType) {
        return MergeAble.decideLeftRight(left, right, mergeType);
    }

    public static List<String> getTextureKeys() {
        HashSet<String> textureKeys = new HashSet<String>();
        textureKeys.add("base");
        for (Material material : MATERIAL_REGISTRY.getFlatMap().values()) {
            textureKeys.add(material.getStringID());
            textureKeys.addAll(material.getTextureKeys());
        }
        return new ArrayList<String>(textureKeys);
    }

    @Nullable
    public static Material getMaterialFromIngredient(ItemStack item) {
        double lowestPrio = Double.MAX_VALUE;
        Material foundMaterial = null;
        for (Material material : MATERIAL_REGISTRY.getFlatMap().values().stream().toList()) {
            Double matPrio = material.getPriorityOfIngredientItem(item);
            if (matPrio == null || !(matPrio < lowestPrio)) continue;
            lowestPrio = matPrio;
            foundMaterial = material;
        }
        if (foundMaterial != null) {
            return foundMaterial.getMaterialFromIngredient(item);
        }
        return null;
    }

    @Nullable
    public static Material getMaterial(JsonElement element) {
        if (element.isJsonPrimitive()) {
            ResourceLocation materialID = Miapi.id(element.getAsString());
            Material material = MATERIAL_REGISTRY.get(materialID);
            if (material != null) {
                return material;
            }
        } else {
            try {
                JsonObject materialSaveData = element.getAsJsonObject();
                ResourceLocation materialID = Miapi.id(materialSaveData.get("type").getAsString());
                Material material = MATERIAL_REGISTRY.get(materialID);
                if (material != null) {
                    if (material.codec().isEmpty()) {
                        return material;
                    }
                    material = (Material)((Pair)material.codec().get().codec().decode((DynamicOps)RegistryOps.create((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)Miapi.registryAccess), (Object)materialSaveData).getOrThrow()).getFirst();
                    return material;
                }
            }
            catch (RuntimeException exception) {
                Miapi.LOGGER.error("Failed complex material decoding with error", (Throwable)exception);
            }
        }
        return null;
    }

    @Nullable
    public static Material getMaterial(ModuleInstance instance) {
        return instance.getFromCache(KEY.toString(), () -> null);
    }

    private static Material getMaterialRaw(ModuleInstance instance) {
        Material material;
        JsonElement element;
        Material jsonMaterial;
        if (instance.moduleData.containsKey(KEY) && (jsonMaterial = MaterialProperty.getMaterial(element = instance.moduleData.get(KEY))) != null) {
            return MaterialOverwriteProperty.property.adjustMaterial(instance, jsonMaterial.getMaterial(instance, instance.initializedProperties));
        }
        if (property.getData(instance).isPresent() && (material = MATERIAL_REGISTRY.get((ResourceLocation)property.getData(instance).get())) != null) {
            material = material.getMaterial(instance, instance.initializedProperties);
            return MaterialOverwriteProperty.property.adjustMaterial(instance, material);
        }
        if (CopyParentMaterialProperty.property.isTrue(instance) && instance.getParent() != null) {
            return MaterialOverwriteProperty.property.adjustMaterial(instance, MaterialProperty.getMaterial(instance.getParent()));
        }
        return null;
    }

    @Nullable
    public static Material getMaterial(Map<ModuleProperty<?>, Object> properties) {
        ResourceLocation id = (ResourceLocation)properties.get(property);
        if (id != null) {
            return MATERIAL_REGISTRY.get(id);
        }
        return null;
    }

    public static void setMaterial(ModuleInstance instance, Material material) {
        if (material.codec().isEmpty()) {
            instance.moduleData.put(KEY, (JsonElement)new JsonPrimitive(material.getID().toString()));
        } else {
            instance.moduleData.put(KEY, MaterialProperty.encodeMaterial(material));
        }
        ModuleDataPropertiesManager.setProperty(instance, property, null);
        material.setMaterial(instance);
    }

    private static <T extends Material> JsonElement encodeMaterial(T material) {
        MapCodec<? extends Material> codec = material.codec().orElseThrow(() -> new IllegalStateException("Material does not have a codec!"));
        Codec typedCodec = codec.codec();
        JsonElement element = (JsonElement)typedCodec.encodeStart((DynamicOps)RegistryOps.create((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)Miapi.registryAccess), material).getOrThrow();
        JsonObject object = element.getAsJsonObject();
        object.addProperty("type", material.getID().toString());
        return object;
    }

    static {
        MATERIAL_REGISTRY = MiapiRegistry.getInstance(Material.class);
        MATERIAL_CODEC = new Codec<Material>(){

            public <T> DataResult<Pair<Material, T>> decode(DynamicOps<T> ops, T input) {
                JsonElement element = (JsonElement)ops.convertTo((DynamicOps)JsonOps.INSTANCE, input);
                Material material = MaterialProperty.getMaterial(element);
                return new DataResult.Success((Object)Pair.of((Object)material, input), Lifecycle.stable());
            }

            public <T> DataResult<T> encode(Material input, DynamicOps<T> ops, T prefix) {
                Object element = input.codec().isPresent() ? MaterialProperty.encodeMaterial(input) : new JsonPrimitive(input.getID().toString());
                Object data = JsonOps.INSTANCE.convertTo(ops, element);
                return DataResult.success((Object)data);
            }
        };
    }
}

