/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.material.composite;

import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import smartin.miapi.Environment;
import smartin.miapi.Miapi;
import smartin.miapi.item.modular.StatResolver;
import smartin.miapi.material.DefaultMaterial;
import smartin.miapi.material.DelegatingMaterial;
import smartin.miapi.material.base.Material;
import smartin.miapi.material.composite.Composite;
import smartin.miapi.material.palette.FallbackColorer;
import smartin.miapi.material.palette.MaterialRenderController;
import smartin.miapi.material.palette.MaterialRenderControllers;
import smartin.miapi.modules.ModuleInstance;

public record PaletteComposite(JsonElement json) implements Composite
{
    public static ResourceLocation ID = Miapi.id("material_palette");
    public static MapCodec<Composite> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)StatResolver.Codecs.JSONELEMENT_CODEC.fieldOf("palette").forGetter(composite -> {
        if (composite instanceof PaletteComposite) {
            PaletteComposite materialCopyComposite = (PaletteComposite)composite;
            return materialCopyComposite.json();
        }
        return null;
    })).apply((Applicative)instance, element -> {
        if (Environment.isClient()) {
            try {
                MaterialRenderControllers.creators.get(element.getAsJsonObject().get("type").getAsString()).createPalette((JsonElement)element, new DefaultMaterial());
            }
            catch (RuntimeException e) {
                Miapi.LOGGER.error("could not decode palette in Palette-Composite", (Throwable)e);
            }
        }
        return new PaletteComposite((JsonElement)element);
    }));

    @Override
    public Material composite(Material parent, boolean isClient) {
        return new DelegatingMaterial(parent){
            @OnlyIn(value=Dist.CLIENT)
            final MaterialRenderController controller;
            {
                this.controller = PaletteComposite.this.getController(PaletteComposite.this.json, this.parent);
            }

            @Override
            @OnlyIn(value=Dist.CLIENT)
            public MaterialRenderController getRenderController(ModuleInstance context, ItemDisplayContext mode) {
                return this.controller;
            }

            @Override
            @OnlyIn(value=Dist.CLIENT)
            public int getColor(ModuleInstance context) {
                return this.controller.getAverageColor().abgr();
            }

            @Override
            @OnlyIn(value=Dist.CLIENT)
            public int getColor(ModuleInstance context, ItemDisplayContext mode) {
                return this.controller.getAverageColor().abgr();
            }
        };
    }

    @OnlyIn(value=Dist.CLIENT)
    private MaterialRenderController getController(JsonElement jsonElement, Material parent) {
        try {
            return MaterialRenderControllers.creators.get(jsonElement.getAsJsonObject().get("type").getAsString()).createPalette(jsonElement, parent);
        }
        catch (RuntimeException e) {
            return new FallbackColorer(parent);
        }
    }

    @Override
    public ResourceLocation getID() {
        return ID;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PaletteComposite that = (PaletteComposite)obj;
        return Objects.equals(this.json, that.json);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.json);
    }
}

