/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.material.composite.material;

import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import smartin.miapi.Miapi;
import smartin.miapi.material.base.Material;
import smartin.miapi.material.composite.Composite;
import smartin.miapi.material.composite.material.BasicOtherMaterialComposite;
import smartin.miapi.material.composite.material.CompositeFromOtherMaterial;

public class DatapackComposite
extends BasicOtherMaterialComposite {
    public static ResourceLocation ID = Miapi.id("data_composite");
    public static MapCodec<DatapackComposite> INNER_MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Miapi.ID_CODEC.fieldOf("data_composite").forGetter(m -> m.dataComposite)).apply((Applicative)instance, DatapackComposite::new));
    public static MapCodec<DatapackComposite> MAP_CODEC = CompositeFromOtherMaterial.getCodec(INNER_MAP_CODEC);
    public static final Map<ResourceLocation, List<Composite>> DATA_COMPOSITE_REGISTRY = new HashMap<ResourceLocation, List<Composite>>();
    public ResourceLocation dataComposite;
    public List<Composite> composites = List.of();
    public static Codec<List<Composite>> DATA_PACK_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Composite.CODEC.listOf().fieldOf("composites").forGetter(c -> c)).apply((Applicative)instance, c -> c));

    public DatapackComposite(ResourceLocation dataComposite) {
        this.dataComposite = dataComposite;
        if (!DATA_COMPOSITE_REGISTRY.containsKey(dataComposite)) {
            Miapi.LOGGER.error("Data Composite " + String.valueOf(dataComposite) + " NOT FOUND!");
        } else {
            this.composites = DatapackComposite.copy(DATA_COMPOSITE_REGISTRY.get(dataComposite));
        }
    }

    public static List<Composite> copy(List<Composite> copies) {
        return (List)((Pair)Composite.CODEC.listOf().decode((DynamicOps)JsonOps.INSTANCE, (Object)((JsonElement)Composite.CODEC.listOf().encodeStart((DynamicOps)JsonOps.INSTANCE, copies).getOrThrow())).getOrThrow()).getFirst();
    }

    @Override
    public Material composite(Material parent, boolean isClient) {
        if (!DATA_COMPOSITE_REGISTRY.containsKey(this.dataComposite)) {
            Miapi.LOGGER.error("Data Composite " + String.valueOf(this.dataComposite) + " NOT FOUND!");
        }
        Material build = parent;
        for (Composite composite : this.composites) {
            if (composite instanceof CompositeFromOtherMaterial) {
                CompositeFromOtherMaterial otherMaterial = (CompositeFromOtherMaterial)composite;
                otherMaterial.setMaterial(this.material);
            }
            build = composite.composite(build, isClient);
        }
        return build;
    }

    @Override
    public void setMaterial(Material material) {
        super.setMaterial(material);
        for (Composite composite : this.composites) {
            if (!(composite instanceof CompositeFromOtherMaterial)) continue;
            CompositeFromOtherMaterial otherMaterial = (CompositeFromOtherMaterial)composite;
            otherMaterial.setMaterial(material);
        }
    }

    @Override
    public ResourceLocation getID() {
        return ID;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DatapackComposite that = (DatapackComposite)obj;
        return this.overWriteAble == that.overWriteAble && Objects.equals(this.material, that.material) && Objects.equals(this.dataComposite, that.dataComposite) && Objects.equals(this.composites, that.composites);
    }

    public int hashCode() {
        return Objects.hash(this.material, this.overWriteAble, this.dataComposite, this.composites);
    }
}

