/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.material.composite.material;

import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import smartin.miapi.Miapi;
import smartin.miapi.item.modular.StatResolver;
import smartin.miapi.material.DelegatingMaterial;
import smartin.miapi.material.base.Material;
import smartin.miapi.material.composite.material.BasicOtherMaterialComposite;
import smartin.miapi.material.composite.material.CompositeFromOtherMaterial;
import smartin.miapi.material.palette.MaskColorer;
import smartin.miapi.material.palette.MaterialRenderController;
import smartin.miapi.material.palette.SpriteColorer;
import smartin.miapi.modules.ModuleInstance;

public class MaterialLayerPaletteComposite
extends BasicOtherMaterialComposite {
    public static ResourceLocation ID = Miapi.id("material_palette_layer");
    public static MapCodec<MaterialLayerPaletteComposite> INNER_MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)StatResolver.Codecs.JSONELEMENT_CODEC.fieldOf("palette").forGetter(m -> m.mask)).apply((Applicative)instance, MaterialLayerPaletteComposite::new));
    public static MapCodec<MaterialLayerPaletteComposite> MAP_CODEC = CompositeFromOtherMaterial.getCodec(INNER_MAP_CODEC);
    public JsonElement mask;

    public MaterialLayerPaletteComposite(JsonElement masker) {
        this.mask = masker;
    }

    @Override
    public Material composite(Material parent, boolean isClient) {
        return new DelegatingMaterial(parent){
            private MaterialRenderController cachedRenderController;
            {
                this.cachedRenderController = null;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            @OnlyIn(value=Dist.CLIENT)
            public MaterialRenderController getRenderController(ModuleInstance context, ItemDisplayContext mode) {
                MaterialRenderController materialController;
                if (this.cachedRenderController != null) return this.cachedRenderController;
                MaterialRenderController parentController = this.parent.getRenderController(context, mode);
                this.cachedRenderController = materialController = MaterialLayerPaletteComposite.this.material.getRenderController(context, mode);
                if (parentController instanceof SpriteColorer) {
                    SpriteColorer basePalette = (SpriteColorer)parentController;
                    if (materialController instanceof SpriteColorer) {
                        SpriteColorer addPalette = (SpriteColorer)materialController;
                        try {
                            MaskColorer.Masker masker = MaskColorer.getMaskerFromJson(MaterialLayerPaletteComposite.this.mask);
                            if (masker instanceof MaskColorer.SpriteMasker) {
                                MaskColorer.SpriteMasker masker1 = (MaskColorer.SpriteMasker)masker;
                                masker1.offsetAble = this.parent.hashCode() * 11 + MaterialLayerPaletteComposite.this.material.hashCode() * 47;
                            }
                            this.cachedRenderController = new MaskColorer(this.parent, basePalette, addPalette, masker);
                            return this.cachedRenderController;
                        }
                        catch (RuntimeException e) {
                            Miapi.LOGGER.error("raw json was " + String.valueOf(MaterialLayerPaletteComposite.this.mask));
                            Miapi.LOGGER.error("Cannot read mask for material_palette_layer ", (Throwable)e);
                            return this.cachedRenderController;
                        }
                    }
                }
                Miapi.LOGGER.error("layer was not applied due to material controllers not supporting this");
                return this.cachedRenderController;
            }
        };
    }

    private static int stableHash(String input) {
        int hash = 7;
        for (char c : input.toCharArray()) {
            hash = hash * 31 + c;
        }
        return hash;
    }

    @Override
    public ResourceLocation getID() {
        return ID;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MaterialLayerPaletteComposite that = (MaterialLayerPaletteComposite)obj;
        return this.overWriteAble == that.overWriteAble && Objects.equals(this.material, that.material) && Objects.equals(this.mask.toString(), that.mask.toString());
    }

    public int hashCode() {
        return Objects.hash(this.material, this.overWriteAble, this.mask);
    }
}

